/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitRunTimeRules;
import com.sigrity.orbit.factory.CoreFactory;
import com.sigrity.orbit.factory.PartFactory;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDlg;
import com.sigrity.orbit.iov.IOViewEditBlockDlg;
import java.awt.Color;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.FocusManager;
import javax.swing.JOptionPane;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.ArrayUtils;

public class IOViewSerializer {
    static final String CELLINSTANCENAME = "CellInstanceName";
    static final String NETNAME = "NetName";
    static final String SIDE = "Side";
    static final String WIDTH = "Width";
    static final String HEIGHT = "Height";
    static final String TEMPLATENAME = "TemplateName";
    static final String PINNAME = "PinName";
    static final String COREDOMAIN = "CoreDomain";
    static final String IODOMAIN = "IODomain";
    static final String FIXEDORDER = "FixedOrder";
    static final String PGCELLCOUNT = "PGCellCount";
    static final String DEVICETYPE = "DeviceType";
    static final String PARENTNET = "ParentNet";
    public static final String FLDNAME_IMPORTID = "IOView.ImportID";
    DevicePath rootDevicePath;
    Db db;
    int goodRows = 0;
    int badRows = 0;
    IOView ioView;
    String lastPinName = "";
    Design design;
    Unit unit;
    private Map<String, Position> name2Position = new HashMap<String, Position>();
    private static boolean mSaveSynthesizedTemplate;
    private static DevicePath exportRootDevicePath;

    Device createDevice(String name) {
        return null;
    }

    DevicePath getOrCreateDevicePath(Db db, String fullDevicePathString) {
        int lastSlashIndex = fullDevicePathString.indexOf(47);
        String devicePathString = fullDevicePathString;
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePathString);
        while (dp == null || !devicePathString.equals(fullDevicePathString)) {
            String deviceName;
            Device device;
            devicePathString = fullDevicePathString.substring(0, lastSlashIndex);
            dp = DevicePath.fromString((Db)db, (String)devicePathString);
            if (dp != null) continue;
            int slashIndex = devicePathString.lastIndexOf(47);
            if (slashIndex == -1) {
                slashIndex = 0;
            }
            if ((device = this.createDevice(deviceName = devicePathString.substring(slashIndex, lastSlashIndex))) == null) {
                ALog.logError((String)"Failed to create device");
                throw new IllegalArgumentException("Failed to create device");
            }
            lastSlashIndex = fullDevicePathString.indexOf(47, lastSlashIndex);
        }
        return dp;
    }

    public void importCSV(String diePathString, String filePath) {
        this.db = OrbitApp.getCurDb();
        this.design = Design.getDesign((Db)this.db);
        this.unit = this.design.getUnit();
        this.rootDevicePath = DevicePath.fromString((Db)this.db, (String)diePathString);
        if (this.rootDevicePath == null) {
            ALog.logInfo((String)(diePathString + " does not exist"));
        }
        if (IOView.theIOView == null) {
            return;
        }
        this.ioView = IOView.theIOView;
        this.ioView.clear();
        this.ioView.setDelayBuilding(true);
        File file = new File(filePath);
        BOMInputStream fis = null;
        try {
            fis = new BOMInputStream((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Unable to read '%s'.", (Object[])new Object[]{filePath});
            return;
        }
        class CSVtoIOView {
            UUID importID;
            private CSVDocument document;
            private Set<String> mInstanceNames = new HashSet<String>();
            private Set<String> mPersonalityNames = new HashSet<String>();
            private Set<String> mCoverDeviceNames = new HashSet<String>();
            String instanceName;
            String netName;
            String sideName;
            String widthName;
            String heightName;
            String gapName;
            String insetName;
            String hierarchy;
            String templateName;
            String personalityGapName;
            String personalityInsetName;
            String decorationName;
            String modeName;
            String attributeName;
            String pinName;
            String pinTypeName;
            String pinPersonalityName;
            String diffPairName;
            String netLockedName;
            String xLoc;
            String yLoc;
            String xForm;
            String gridName;
            String ignoreName;
            String isBump;
            String decoratorName;
            String desiredPath;
            String placementGroup;
            IOViewBlock lastBlock = null;
            IOViewBlock lastPBlock = null;
            private long nWarningMultiplePinsInSynthesizedTemplate = 0L;

            CSVtoIOView(BOMInputStream fis) {
                this.importID = UUID.randomUUID();
                try {
                    CSVDOMParser parser2 = new CSVDOMParser(true, null);
                    this.document = parser2.parse((InputStream)fis);
                }
                catch (CSVDOMParser.CSVDOMException e) {
                    ALog.logError((Throwable)e, (String)"Error reading input file.", (Object[])new Object[0]);
                }
            }

            private String findLastInterface(String devicePath) {
                Object[] deviceNames = devicePath.split("/");
                ArrayUtils.reverse((Object[])deviceNames);
                for (Object dName : deviceNames) {
                    if (this.mInstanceNames.contains(dName)) continue;
                    return dName;
                }
                return null;
            }

            private String findLastCoverDevice(String devicePath) {
                Object[] deviceNames = devicePath.split("/");
                ArrayUtils.reverse((Object[])deviceNames);
                for (Object dName : deviceNames) {
                    if (this.mInstanceNames.contains(dName) || this.mPersonalityNames.contains(dName)) continue;
                    return dName;
                }
                return null;
            }

            private void parseHierarchy() {
                for (int i = 0; i < this.document.getItemCount(); ++i) {
                    this.getRow(i);
                    this.mInstanceNames.add(this.instanceName);
                    APair<List<String>, String> pnscdn = this.getPersonalityNamesAndCoverDeviceName(this.hierarchy);
                    this.mPersonalityNames.addAll((Collection)pnscdn.first);
                    if (((String)pnscdn.second).isEmpty()) continue;
                    this.mCoverDeviceNames.add((String)pnscdn.second);
                }
            }

            private APair<List<String>, String> getPersonalityNamesAndCoverDeviceName(String str) {
                List<String> personalityNames;
                String[] strings = str.split("/");
                String coverDeviceName = "";
                if (this.isBump.isEmpty()) {
                    personalityNames = Arrays.asList(strings);
                } else {
                    coverDeviceName = strings[strings.length - 1];
                    personalityNames = new LinkedList<String>(Arrays.asList(Arrays.copyOf(strings, strings.length - 1)));
                }
                return new APair(personalityNames, (Object)coverDeviceName);
            }

            void process() {
                for (int i = 0; i < this.document.getItemCount(); ++i) {
                    this.getRow(i);
                    if (!this.isBump.isEmpty()) continue;
                    boolean status = this.addIOPad(i);
                    if (!status) {
                        ++IOViewSerializer.this.badRows;
                        continue;
                    }
                    ++IOViewSerializer.this.goodRows;
                }
                ALog.logInfo((String)("There were " + IOViewSerializer.this.goodRows + " device(s) read"));
            }

            private String getColumnData(int row, String colName) {
                try {
                    return this.document.getItemValue(row, colName);
                }
                catch (Exception e) {
                    ALog.logError((String)e.getMessage());
                    return "";
                }
            }

            private void getRow(int i) {
                this.instanceName = this.getColumnData(i, IOViewSerializer.CELLINSTANCENAME);
                this.netName = this.getColumnData(i, IOViewSerializer.NETNAME);
                this.sideName = this.getColumnData(i, IOViewSerializer.SIDE);
                this.widthName = this.getColumnData(i, IOViewSerializer.WIDTH);
                this.heightName = this.getColumnData(i, IOViewSerializer.HEIGHT);
                this.gapName = this.getColumnData(i, "Gap");
                this.insetName = this.getColumnData(i, "Inset");
                this.hierarchy = this.getColumnData(i, "Personality");
                this.templateName = this.getColumnData(i, IOViewSerializer.TEMPLATENAME);
                this.personalityGapName = this.getColumnData(i, "PersonalityGap");
                this.personalityInsetName = this.getColumnData(i, "PersonalityInset");
                this.decorationName = this.getColumnData(i, "Decoration");
                this.modeName = this.getColumnData(i, "Mode");
                this.attributeName = this.getColumnData(i, "Attribute");
                this.pinName = this.getColumnData(i, IOViewSerializer.PINNAME);
                this.pinTypeName = this.getColumnData(i, "PinType");
                this.pinPersonalityName = this.getColumnData(i, "PinPersonality");
                this.diffPairName = this.getColumnData(i, "DiffPair");
                this.netLockedName = this.getColumnData(i, "NetLocked");
                this.xLoc = this.getColumnData(i, "XLoc");
                this.yLoc = this.getColumnData(i, "YLoc");
                this.xForm = this.getColumnData(i, "XForm");
                this.gridName = this.getColumnData(i, "Grid");
                this.ignoreName = this.getColumnData(i, "Ignore");
                this.decoratorName = this.getColumnData(i, "DecorationName");
                this.desiredPath = this.getColumnData(i, "DesiredPath");
                this.isBump = this.getColumnData(i, "Bump");
                this.placementGroup = this.getColumnData(i, "PlacementGroup");
                this.instanceName = this.instanceName.replace(" ", "");
                this.pinName = this.pinName.replace(" ", "");
                this.netName = this.netName.replace(" ", "");
            }

            boolean addIOPad(int i) {
                if (!this.ignoreName.isEmpty()) {
                    return false;
                }
                if (this.hierarchy.equals("CORE")) {
                    Position position = new Position(this.xLoc, this.yLoc, this.xForm);
                    IOViewSerializer.this.name2Position.put(this.instanceName, position);
                    return true;
                }
                Optional<Personality> p = this.getOrCreatePersonality();
                boolean blockAlreadyMade = false;
                IOViewBlock block = this.addIOViewBlock();
                if (block == null) {
                    blockAlreadyMade = true;
                    block = this.lastBlock;
                }
                if (!this.pinName.isEmpty()) {
                    IOViewSerializer.this.lastPinName = this.pinName;
                    if (!this.netName.isEmpty()) {
                        IOViewBlock.PinAttribute pattr = this.addPinAttribute(block);
                        try {
                            this.setPinAndNetUp(block, pattr, blockAlreadyMade, i);
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    if (!this.diffPairName.isEmpty()) {
                        IOViewSerializer.this.makeDiffPair(this.netName, this.diffPairName);
                    }
                }
                if (blockAlreadyMade) {
                    if (!this.pinName.isEmpty()) {
                        this.setPinTypeAndPersonality(block);
                    }
                    return false;
                }
                block.parent = null;
                block.inset = IOViewSerializer.this.unit.fromUserString(this.insetName);
                block.gap = IOViewSerializer.this.unit.fromUserString(this.gapName);
                block.side = IOViewDlg.Side.determineSide(this.sideName);
                block.defaultXform = this.xForm != null && !this.xForm.isEmpty() ? DeviceTemplate.DefTransform.valueOf((String)this.xForm) : DeviceTemplate.DefTransform.N;
                try {
                    this.addDeviceTemplate(block, i);
                }
                catch (Exception e) {
                    return false;
                }
                IOView.addBlockToParent(block, this.lastPBlock, -1);
                block.parent = this.lastPBlock;
                block.makeDbDevice();
                Device device = block.devicePath.getLast();
                if (p.isPresent()) {
                    device.assignToPersonality(p.get());
                }
                device.setSourceType(this.decorationName.equalsIgnoreCase("true") ? Device.SourceType.DECORATOR : Device.SourceType.DIESPREADSHEET);
                Long group = AUtil.parseLong((String)this.placementGroup);
                if (group == null) {
                    group = 0L;
                }
                device.setPlacementGroup(group.longValue());
                if (!this.decoratorName.isEmpty()) {
                    IOView.setDecorationName(block.getParent(), this.decoratorName);
                }
                if (!this.modeName.isEmpty()) {
                    device.setValue("IOView.Mode", (Object)this.modeName);
                }
                block.hard = this.attributeName.equalsIgnoreCase("hard");
                block.parent.ignoreGrid = this.gridName.equalsIgnoreCase("None");
                if (!this.pinName.isEmpty()) {
                    this.addDevicePin(block);
                }
                if (block.side == IOViewDlg.Side.Core.getOrdinal()) {
                    this.setCoreTransform(block);
                }
                if (!this.desiredPath.isEmpty()) {
                    this.setInterface();
                }
                return true;
            }

            private boolean isCreatedByThisImport(Personality p) {
                Object v = p.getValue(IOViewSerializer.FLDNAME_IMPORTID);
                if (v != null) {
                    UUID id = (UUID)v;
                    return id.equals(this.importID);
                }
                return false;
            }

            private IOViewBlock addIOViewBlock() {
                IOViewBlock block;
                if (this.instanceName.startsWith("$") || this.lastBlock != null && this.lastBlock.getName().equals(this.instanceName) && !IOViewSerializer.this.lastPinName.equals(this.pinName)) {
                    String name;
                    String string = name = this.instanceName.startsWith("$") ? this.instanceName.substring(1) : this.instanceName;
                    if (this.lastBlock == null || !this.lastBlock.getName().equals(name)) {
                        this.lastBlock = block = new IOViewBlock(name);
                    } else {
                        block = null;
                    }
                } else {
                    this.lastBlock = block = new IOViewBlock(this.instanceName);
                }
                return block;
            }

            private Device createCoverDevice(String name, String hierarchy) {
                String parentDPStr = hierarchy.substring(0, hierarchy.lastIndexOf(47));
                DevicePath parentDP = DevicePath.fromString((Db)IOViewSerializer.this.db, (String)parentDPStr);
                Device parent = parentDP.getDevice();
                String templateName = hierarchy.replace("/", "_");
                templateName = templateName.replace(".", "t");
                DeviceTemplate t = DeviceTemplate.getDeviceTemplate((Substrate)parent.getSubstrate(), (String)templateName);
                if (t == null) {
                    t = DeviceTemplate.create((Substrate)parent.getSubstrate(), (String)templateName, (boolean)false);
                    t.setType(DeviceTemplate.Type.COVER);
                }
                return new Device(name, parentDP.getDeviceTemplate(), t);
            }

            private String getPersonalityNameFromHierarchy(DevicePath rootDevicePath, String devicePath) {
                if (devicePath.startsWith(".")) {
                    devicePath = devicePath.substring(1);
                }
                if (devicePath.startsWith("/")) {
                    return rootDevicePath.getString() + devicePath;
                }
                return rootDevicePath.getString() + "/" + devicePath;
            }

            private Optional<Personality> getOrCreatePersonality() {
                String psn = this.getPersonalityNameFromHierarchy(IOViewSerializer.this.rootDevicePath, this.hierarchy);
                Optional<Personality> p = Personality.getPersonality((DeviceTemplate)IOViewSerializer.this.rootDevicePath.getLast().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)psn);
                if (p.isPresent()) {
                    if (this.isCreatedByThisImport((Personality)p.get())) {
                        return p;
                    }
                    ((Personality)p.get()).deleteFromDb();
                }
                String[] names = this.hierarchy.split("/");
                p = this.createDevicePersonality(psn, names[names.length - 1]);
                return p;
            }

            private Optional<Personality> createDevicePersonality(String personalityName, String shortName) {
                IOViewBlock pBlock = new IOViewBlock(personalityName);
                pBlock.parent = null;
                pBlock.setDesiredName(shortName);
                pBlock.gap = IOViewSerializer.this.unit.fromUserString(this.personalityGapName);
                pBlock.inset = IOViewSerializer.this.unit.fromUserString(this.personalityInsetName);
                pBlock.side = IOViewDlg.Side.determineSide(this.sideName);
                pBlock.devicePath = IOViewSerializer.this.rootDevicePath;
                pBlock.createDevicePersonality(shortName);
                IOView.addBlockToSide(pBlock, pBlock.side, -1);
                this.lastPBlock = pBlock;
                Optional p = Personality.getPersonality((DeviceTemplate)IOViewSerializer.this.rootDevicePath.getLast().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)personalityName);
                if (p.isPresent()) {
                    Constraint.setConstraintValue((DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.IGNORE_GRID, (Object)this.gridName.equalsIgnoreCase("None"));
                    ((Personality)p.get()).setValue(IOViewSerializer.FLDNAME_IMPORTID, (Object)this.importID);
                }
                return p;
            }

            private String getErrorMsg() {
                Object msg = "";
                if (this.nWarningMultiplePinsInSynthesizedTemplate != 0L) {
                    msg = (String)msg + "More than one pin in synthesized template detected!";
                }
                if (!((String)msg).isEmpty()) {
                    ALog.flogWarn((String)msg, (Object[])new Object[0]);
                }
                return msg;
            }

            private DeviceTemplate getOrCreateSingleIOPadTemplate(int i, IOViewBlock block, String originalTemplateName) {
                if (this.widthName == null || this.heightName == null) {
                    ALog.flogWarn((String)"On Device %d : Template %s can not be found in the design", (Object[])new Object[]{i, this.templateName});
                    throw new IllegalArgumentException();
                }
                block.width = IOViewSerializer.this.unit.fromUserString(this.widthName);
                block.height = IOViewSerializer.this.unit.fromUserString(this.heightName);
                int j = 0;
                Object tName = originalTemplateName;
                do {
                    DeviceTemplate t;
                    if (this.isAValidTemplateWithPin(t = PartFactory.makeIOPadTemplate(IOViewSerializer.this.rootDevicePath.getLast(), block.width, block.height, this.pinName, false, null, true, (String)tName), this.pinName)) {
                        return t;
                    }
                    tName = originalTemplateName + ++j;
                    ++this.nWarningMultiplePinsInSynthesizedTemplate;
                } while (this.nWarningMultiplePinsInSynthesizedTemplate < 99999L);
                ALog.flogWarn((String)"On Device %d : Template %s can not be found in the design", (Object[])new Object[]{i, tName});
                ALog.flogWarn((String)"Synthesized template should have only one signle PAD.", (Object[])new Object[0]);
                ALog.flogWarn((String)"Have created too many syntheszied template:%d.", (Object[])new Object[]{this.nWarningMultiplePinsInSynthesizedTemplate});
                throw new IllegalArgumentException();
            }

            private boolean isAValidTemplateWithPin(DeviceTemplate t, String pinN) {
                if (t == null) {
                    return false;
                }
                if (pinN.isEmpty()) {
                    return true;
                }
                return t.getPins().stream().anyMatch(p -> p.getName().equals(pinN));
            }

            private void addDeviceTemplate(IOViewBlock block, int i) {
                if (this.templateName.isEmpty()) {
                    block.width = IOViewSerializer.this.unit.fromUserString(this.widthName);
                    block.height = IOViewSerializer.this.unit.fromUserString(this.heightName);
                    block.byTemplate = false;
                } else {
                    this.templateName = this.templateName.replace(" ", "");
                    DeviceTemplate t = DeviceTemplate.getDeviceTemplate((Substrate)IOViewSerializer.this.rootDevicePath.getSubstrate(), (String)this.templateName);
                    if (t == null) {
                        ALog.flogWarn((String)"Template:'%s' not in design. Would create a default template for instance:'%s'.", (Object[])new Object[]{this.templateName, this.instanceName});
                    }
                    if (!this.isAValidTemplateWithPin(t, this.pinName)) {
                        t = this.getOrCreateSingleIOPadTemplate(i, block, this.templateName);
                    }
                    block.template = t;
                    block.byTemplate = true;
                }
            }

            private void addDevicePin(IOViewBlock block) {
                Device d;
                PinInstance dp;
                PinTemplate dtp = block.template.getPinByName(this.pinName);
                if (dtp == null) {
                    dtp = PartFactory.makeIOPadPinTemplate(block.template, this.pinName, true, null, true);
                }
                if (!this.pinTypeName.isEmpty()) {
                    dtp.setType(PinTemplate.Type.valueOf((String)this.pinTypeName));
                } else {
                    dtp.setType(PinTemplate.Type.IOPAD);
                }
                if (!this.pinPersonalityName.isEmpty() && (dp = (d = block.devicePath.getLast()).getPinByName(this.pinName)) != null) {
                    Personality pinP = Personality.getOrCreate((DeviceTemplate)IOViewSerializer.this.rootDevicePath.getLast().getTemplate(), (Personality.Type)Personality.Type.PORT, (String)this.pinPersonalityName, per -> {
                        Color c = AUtil.colorFromString((String)Personality.nextColor());
                        if (c != null) {
                            per.setColor(c);
                        }
                    });
                    dp.assignToPersonality(pinP);
                }
            }

            private IOViewBlock.PinAttribute addPinAttribute(IOViewBlock block) {
                IOViewBlock.PinAttribute pattr = new IOViewBlock.PinAttribute();
                block.pinAttributes.add(pattr);
                pattr.pinName = this.pinName;
                pattr.netName = this.netName;
                pattr.locked = this.netLockedName.equals("true");
                return pattr;
            }

            private void setPinAndNetUp(IOViewBlock block, IOViewBlock.PinAttribute pattr, boolean blockAlreadyMade, int i) {
                if (!blockAlreadyMade) {
                    return;
                }
                if (block == null || block.devicePath == null) {
                    String name = this.instanceName.startsWith("$") ? this.instanceName.substring(1) : this.instanceName;
                    ALog.flogWarn((String)"On Device %d : Can not find the device being referenced %s", (Object[])new Object[]{i, name});
                    throw new IllegalArgumentException();
                }
                Device instance = block.devicePath.getLast();
                PinInstance port = instance.getPinByName(this.pinName);
                if (port == null) {
                    ALog.flogWarn((String)"Can not find a pin called %s on device %s one is being created", (Object[])new Object[]{this.pinName, block.devicePath.toString()});
                    PinTemplate pinTemplate = PartFactory.makeIOPadPinTemplate(block.devicePath.getLast().getTemplate(), this.pinName, true, this.netName, true);
                    port = instance.getPin(pinTemplate);
                }
                if (port != null) {
                    Device device = block.devicePath.getLast();
                    DeviceTemplate template = device.getTemplate();
                    if (template.hasExactlyOneDeviceInstance()) {
                        port.setNet(template.getNetUnused());
                    }
                    if (!this.netName.equals("NetUnused")) {
                        NetMap.mapThroughPath((DevicePath)block.devicePath, (PinInstance)port, (String)this.netName);
                    }
                    if (pattr.locked) {
                        port.setNetSetterType(PinInstance.NetSetterType.INTERACTIVE_USER);
                    }
                } else {
                    ALog.flogWarn((String)"On Device %d : There is no pin %s", (Object[])new Object[]{i, this.pinName});
                }
            }

            private void setPinTypeAndPersonality(IOViewBlock block) {
                Device d;
                PinInstance dp;
                PinTemplate dtp = block.template.getPinByName(this.pinName);
                if (dtp == null) {
                    dtp = PartFactory.makeIOPadPinTemplate(block.template, this.pinName, true, null, true);
                }
                dtp.setType(this.pinTypeName.isEmpty() ? PinTemplate.Type.IOPAD : PinTemplate.Type.valueOf((String)this.pinTypeName));
                if (!this.pinPersonalityName.isEmpty() && (dp = (d = block.devicePath.getLast()).getPinByName(this.pinName)) != null) {
                    Personality pinP = Personality.getOrCreate((DeviceTemplate)IOViewSerializer.this.rootDevicePath.getLast().getTemplate(), (Personality.Type)Personality.Type.PORT, (String)this.pinPersonalityName, per -> {
                        Color c = AUtil.colorFromString((String)Personality.nextColor());
                        if (c != null) {
                            per.setColor(c);
                        }
                    });
                    dp.assignToPersonality(pinP);
                }
            }

            private void setCoreTransform(IOViewBlock block) {
                long x = IOViewSerializer.this.unit.fromUserString(this.xLoc);
                long y = IOViewSerializer.this.unit.fromUserString(this.yLoc);
                APair xform = AGeomUtil.getActualOrient((String)this.xForm);
                Device core = block.devicePath.getLast();
                core.setLoc(new APoint2D(x, y));
                if (xform != null) {
                    core.setRotate(((Float)xform.first).floatValue());
                    core.setMirror(((Boolean)xform.second).booleanValue());
                }
            }

            private void setInterface() {
                DevicePath interfacePath = new DevicePath(IOViewSerializer.this.rootDevicePath);
                int interfaceIdx = this.lastBlock.devicePath.size() - 2;
                interfacePath.add(this.lastBlock.devicePath.get(interfaceIdx));
                if (this.desiredPath.startsWith("./")) {
                    String fullPath = this.desiredPath.replace("./", IOViewSerializer.this.rootDevicePath.toString() + "/");
                    CoreFactory.moveInterface(IOViewSerializer.this.db, interfacePath.toString(), fullPath);
                }
            }
        }
        CSVtoIOView builder = new CSVtoIOView(fis);
        builder.parseHierarchy();
        builder.process();
        String errMsg = builder.getErrorMsg();
        if (this.rootDevicePath == null || this.rootDevicePath.getLast() == null) {
            String msg = String.format("Errorneous rootDevicePath:'%s'", this.rootDevicePath);
            ALog.logError((String)msg);
            throw new IllegalArgumentException(msg);
        }
        this.rootDevicePath.getLast().getTemplate().setSourceFile(filePath);
        this.rootDevicePath.getLast().getTemplate().setSourceFileModifiedTime(file.lastModified());
        for (Map.Entry<String, Position> entry : this.name2Position.entrySet()) {
            Optional p;
            String corePersonalityName = entry.getKey();
            Position position = entry.getValue();
            if (position == null || !(p = Personality.getPersonality((DeviceTemplate)this.rootDevicePath.getLast().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)corePersonalityName)).isPresent()) continue;
            Device core = ((Personality)p.get()).getParentDevicePath().getLast();
            long x = this.unit.fromUserString(position.x);
            long y = this.unit.fromUserString(position.y);
            APair xform = AGeomUtil.getActualOrient((String)position.xform);
            core.setLoc(new APoint2D(x, y));
            if (xform == null) continue;
            core.setRotate(((Float)xform.first).floatValue());
            core.setMirror(((Boolean)xform.second).booleanValue());
        }
        OrbitRunTimeRules ortr = new OrbitRunTimeRules();
        ortr.updateAllDevices(this.db);
        this.ioView.setDelayBuilding(false);
        IOView.buildCanvasFromIOView(-1);
        OrbitIO.getApp().refreshCurrentView(false);
        if (!errMsg.isEmpty()) {
            try {
                Window activeWindow = FocusManager.getCurrentManager().getActiveWindow();
                JOptionPane.showMessageDialog(activeWindow, errMsg, "Warning", 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void makeDiffPair(String netName, String diffPairName) {
        DeviceTemplate dieTemplate = this.rootDevicePath.getLast().getTemplate();
        Net netOnPin = dieTemplate.getNet(netName);
        if (netOnPin == null) {
            netOnPin = Net.create((DeviceTemplate)dieTemplate, (String)netName);
        }
        Personality netPersonality = Personality.getOrCreate((DeviceTemplate)dieTemplate, (Personality.Type)Personality.Type.NET, (String)diffPairName, per -> {
            Color c = AUtil.colorFromString((String)Personality.nextColor());
            if (c != null) {
                per.setColor(c);
            }
            Constraint.getOrCreate((DbObject)per, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH, (Object)true);
        });
        netOnPin.assignToPersonality(netPersonality, null);
    }

    public static void exportCSV(String pathName) {
        IOViewSerializer.exportCSV(pathName, false);
    }

    private static void writeHeaders(MiniCSVWriter writer) {
        writer.newLine();
        writer.addColumn(CELLINSTANCENAME);
        writer.addColumn(NETNAME);
        writer.addColumn(SIDE);
        writer.addColumn("Personality");
        writer.addColumn(TEMPLATENAME);
        writer.addColumn(WIDTH);
        writer.addColumn(HEIGHT);
        writer.addColumn(PINNAME);
        writer.addColumn("PinType");
        writer.addColumn("PinPersonality");
        writer.addColumn("Attribute");
        writer.addColumn("Gap");
        writer.addColumn("Inset");
        writer.addColumn("PersonalityGap");
        writer.addColumn("PersonalityInset");
        writer.addColumn("Decoration");
        writer.addColumn("DecorationName");
        writer.addColumn("Mode");
        writer.addColumn("DiffPair");
        writer.addColumn("NetLocked");
        writer.addColumn("XLoc");
        writer.addColumn("YLoc");
        writer.addColumn("XForm");
        writer.addColumn("Grid");
        writer.addColumn("Ignore");
        writer.addColumn("Bump");
        writer.addColumn("PlacementGroup");
        writer.write();
    }

    private static void writeCorePersonality(MiniCSVWriter writer, IOViewBlock block, Device d, Unit unit) {
        writer.newLine();
        writer.addColumn(d.getName());
        writer.addColumn("");
        writer.addColumn(block.getSideName());
        writer.addColumn("CORE");
        for (int i = 0; i < 15; ++i) {
            writer.addColumn("");
        }
        APoint2D loc = d.getLoc();
        writer.addColumn(unit.toUserStr(loc.getX()));
        writer.addColumn(unit.toUserStr(loc.getY()));
        String xform = AGeomUtil.getStringOrient((float)d.getRotate(), (boolean)d.getMirror());
        writer.addColumn(xform);
        writer.write();
    }

    private static void writeInstName(MiniCSVWriter writer, String name) {
        writer.newLine();
        writer.addColumn(name);
    }

    private static void writePersonality(MiniCSVWriter writer, IOViewBlock block) {
        Personality p = block.devicePath.getLast().getPersonality();
        if (p == null) {
            writer.addColumn(block.devicePath.getParent().getLast().getName());
        } else {
            DevicePath intrface = block.devicePath.getParent();
            DevicePath group = intrface.getParent();
            if (group == null || group.isEmpty() || group.getLast().getTemplate().getType().equals((Object)DeviceTemplate.Type.DIE)) {
                writer.addColumn(p.getName());
            } else {
                writer.addColumn(group.getLast().getName() + "/" + p.getName());
            }
        }
    }

    private static void writeHierarchy(MiniCSVWriter writer, DevicePath dp) {
        DevicePath subdp = dp.pathToParent(exportRootDevicePath);
        subdp = subdp.getSubPath(1, subdp.size() - 1);
        writer.addColumn(subdp.toString());
    }

    private static void writeTemplateName(MiniCSVWriter writer, IOViewBlock block, DeviceTemplate t, boolean isBump) {
        if (block.byTemplate || isBump || mSaveSynthesizedTemplate) {
            writer.addColumn(t.getName());
        } else {
            writer.addColumn("");
        }
    }

    private static void writePinType(MiniCSVWriter writer, DeviceTemplate t, String pinName) {
        PinTemplate dtp = t.getPinByName(pinName);
        writer.addColumn(dtp != null ? dtp.getType().name() : "");
    }

    private static void writePinPersonality(MiniCSVWriter writer, DevicePath devicePath, String pinName) {
        PinInstance dport = devicePath.getLast().getPinByName(pinName);
        if (dport != null) {
            Optional<Personality> pp = PersonalityMap.getPersonalities((Personality.Type)Personality.Type.PORT, (DbObject)dport, (DevicePath)devicePath).map(PersonalityMap::getPersonality).findFirst();
            writer.addColumn(pp.isPresent() ? pp.get().getName() : "");
        } else {
            writer.addColumn("");
        }
    }

    private static void writeDecoration(MiniCSVWriter writer, IOViewBlock block) {
        if (block.devicePath.getLast().getSourceType() == Device.SourceType.DECORATOR) {
            writer.addColumn("true");
        } else {
            writer.addColumn("");
        }
    }

    private static void writeDecorationName(MiniCSVWriter writer, IOViewBlock block) {
        if (block.devicePath != null) {
            String decorationName = IOView.getDecorationName(block.getParent());
            if (decorationName == null) {
                decorationName = "";
            }
            writer.addColumn(decorationName);
        }
    }

    private static void writeDeviceMode(MiniCSVWriter writer, DevicePath devicePath) {
        String mode = (String)devicePath.getLast().getValue("IOView.Mode");
        if (mode == null) {
            writer.addColumn("");
        } else {
            writer.addColumn(mode);
        }
    }

    private static void writeSomeEmptyStrings(MiniCSVWriter writer, int num) {
        for (int i = 0; i < num; ++i) {
            writer.addColumn("");
        }
    }

    private static List<IOViewBlock.PinAttribute> getSortedPinList(DeviceTemplate t, DevicePath devicePath, boolean justMain) {
        Device d = devicePath.getDevice();
        ArrayList<IOViewBlock.PinAttribute> sortedList = new ArrayList<IOViewBlock.PinAttribute>();
        for (PinTemplate pt : justMain ? t.getIOPorts() : t.getPins()) {
            IOViewBlock.PinAttribute pa = new IOViewBlock.PinAttribute();
            pa.pinName = pt.getName();
            Net parentNet = NetMap.getParentNet((Device)d, (Net)pt.getNet());
            pa.parentNetName = parentNet == null ? "" : parentNet.getName();
            Net top = NetMap.getTopmostNet((Net)pt.getNet(), (DevicePath)devicePath);
            pa.netName = top.getName();
            PinInstance dp = d.getPin(pt);
            PinInstance.NetSetterType nst = dp.getNetSetterType();
            pa.locked = nst != null && nst == PinInstance.NetSetterType.INTERACTIVE_USER;
            sortedList.add(pa);
        }
        Collections.sort(sortedList, new IOViewEditBlockDlg.IOViewPinAttrSorter(t));
        return sortedList;
    }

    public static void setSaveSynthesizedTemplateForExportCSV(boolean saveSynthesizedTemplate) {
        mSaveSynthesizedTemplate = saveSynthesizedTemplate;
    }

    public static void exportCSV(String pathName, boolean justMain) {
        MiniCSVWriter writer = new MiniCSVWriter();
        if (!writer.open(pathName)) {
            return;
        }
        List<IOViewBlock> flatten = IOView.theIOView.flattenAll();
        exportRootDevicePath = IOView.theIOView.getRootDevicePath();
        Unit unit = Design.getUnit((Db)OrbitApp.getCurDb());
        IOViewSerializer.writeHeaders(writer);
        for (IOViewBlock block : flatten) {
            IOViewSerializer.writeBlock(writer, unit, block, justMain);
        }
        writer.close();
    }

    private static void writeBlock(MiniCSVWriter writer, Unit unit, IOViewBlock block, boolean justMain) {
        DeviceTemplate t = block.devicePath.getLast().getTemplate();
        Device d = block.devicePath.getLast();
        if (t.getType() == DeviceTemplate.Type.PERSONALITY && block.side == IOViewDlg.Side.Core.getOrdinal()) {
            IOViewSerializer.writeCorePersonality(writer, block, d, unit);
            return;
        }
        if (t.getType() == DeviceTemplate.Type.PERSONALITY || t.getType() == DeviceTemplate.Type.MACRO && t.getIsSynthesized()) {
            return;
        }
        if (t.getType() == DeviceTemplate.Type.COVER) {
            DevicePath cover = block.getDevicePath();
            List bumps = cover.getDescendants().stream().filter(dp -> dp.getDevice().getType() == DeviceTemplate.Type.BUMP).sorted((dp1, dp2) -> dp1.getDevice().getName().compareTo(dp2.getDevice().getName())).collect(Collectors.toList());
            bumps.stream().forEach(bump -> IOViewSerializer.writeCommonColumnsForBothBumpsAndPads(writer, unit, block, bump, justMain, true));
        } else {
            IOViewSerializer.writeCommonColumnsForBothBumpsAndPads(writer, unit, block, block.getDevicePath(), justMain, false);
        }
    }

    private static void writeCommonColumnsForBothBumpsAndPads(MiniCSVWriter writer, Unit unit, IOViewBlock block, DevicePath bumpOrPad, boolean justMain, boolean isBump) {
        Device d = bumpOrPad.getLast();
        DeviceTemplate t = d.getTemplate();
        List<IOViewBlock.PinAttribute> sortedList = IOViewSerializer.getSortedPinList(t, bumpOrPad, justMain);
        List pnls = sortedList.stream().map(pattr -> new PinNetLockedInfo(pattr.pinName, pattr.netName, pattr.locked)).collect(Collectors.toList());
        if (pnls.isEmpty()) {
            pnls.add(new PinNetLockedInfo("", "", false));
        }
        boolean first = true;
        for (PinNetLockedInfo pnl : pnls) {
            IOViewSerializer.writeInstName(writer, (String)(pnls.size() > 1 && !first ? "$" + d.getName() : d.getName()));
            String pinName = pnl.getPinName();
            writer.addColumn(pnl.getNetName());
            writer.addColumn(block.getSideName());
            IOViewSerializer.writeHierarchy(writer, bumpOrPad);
            IOViewSerializer.writeTemplateName(writer, block, t, isBump);
            writer.addColumn(unit.toUserStr(t.getBB().width()));
            writer.addColumn(unit.toUserStr(t.getBB().height()));
            writer.addColumn(pinName);
            IOViewSerializer.writePinType(writer, t, pinName);
            IOViewSerializer.writePinPersonality(writer, bumpOrPad, pinName);
            if (first) {
                first = false;
                writer.addColumn(block.hard ? "hard" : "");
                writer.addColumn(unit.toUserStr(block.gap));
                writer.addColumn(unit.toUserStr(block.inset));
                IOViewBlock parent = block.parent;
                if (parent != null && parent.isInterface()) {
                    writer.addColumn(unit.toUserStr(parent.gap));
                    writer.addColumn(unit.toUserStr(parent.inset));
                } else {
                    IOViewSerializer.writeSomeEmptyStrings(writer, 2);
                }
                IOViewSerializer.writeDecoration(writer, block);
                IOViewSerializer.writeDecorationName(writer, block);
                IOViewSerializer.writeDeviceMode(writer, bumpOrPad);
            } else {
                IOViewSerializer.writeSomeEmptyStrings(writer, 8);
            }
            writer.addColumn("");
            writer.addColumn(pnl.getNetLocked() ? "true" : "");
            APoint2D loc = d.getLoc();
            writer.addColumn(unit.toUserStr(loc.getX()));
            writer.addColumn(unit.toUserStr(loc.getY()));
            String xform = block.defaultXform.name();
            writer.addColumn(xform);
            writer.addColumn(block.parent.ignoreGrid ? "None" : "STD");
            writer.addColumn("");
            writer.addColumn(isBump ? "true" : "");
            long group = IOViewSerializer.getPlacementGroup(d);
            writer.addColumn(group == 0L ? "" : String.format("%d", group));
            writer.write();
        }
    }

    private static long getPlacementGroup(Device d) {
        try {
            return d.getPlacementGroup();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static class PinNetLockedInfo {
        private String pinName;
        private String netName;
        private Boolean netLocked;

        public PinNetLockedInfo(String pinName, String netName, Boolean netLocked) {
            this.pinName = pinName;
            this.netName = netName;
            this.netLocked = netLocked;
        }

        public String getPinName() {
            return this.pinName;
        }

        public String getNetName() {
            return this.netName;
        }

        public boolean getNetLocked() {
            return this.netLocked;
        }
    }

    private static class MiniCSVWriter {
        List<String> columns = new ArrayList<String>();
        File mFile;
        FileWriter mFileWriter;

        private MiniCSVWriter() {
        }

        public boolean open(String pathName) {
            if (pathName == null) {
                return false;
            }
            try {
                this.mFile = new File(pathName);
                this.mFileWriter = new FileWriter(this.mFile);
            }
            catch (IOException e) {
                ALog.logError((String)"Can not open %s for writing", (Object[])new Object[]{pathName});
                return false;
            }
            return true;
        }

        public void write() {
            try {
                boolean first = true;
                for (String c : this.columns) {
                    if (!first) {
                        this.mFileWriter.write(",");
                    }
                    first = false;
                    this.mFileWriter.write(c.replace(",", ""));
                }
                this.mFileWriter.write("\n");
            }
            catch (IOException e) {
                return;
            }
        }

        public void newLine() {
            this.columns = new ArrayList<String>();
        }

        public void addColumn(String column) {
            this.columns.add(column);
        }

        public void close() {
            try {
                this.mFileWriter.close();
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
        }
    }

    class Position {
        String x;
        String y;
        String xform;

        public Position(String x, String y, String xform) {
            this.x = x;
            this.y = y;
            this.xform = xform;
        }
    }
}

