/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDlg;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;

interface LayoutManager {
    public static final Deque<Placement> stack = new ArrayDeque<Placement>();

    public void reset(IOView var1);

    public boolean layout(boolean var1);

    public static Placement deriveIOViewPlacement(List<IOViewBlock> blocks) {
        Placement sidePlacementCoverDevice = new Placement();
        for (IOViewBlock b : blocks) {
            LayoutManager.deriveIOViewPlacementByPlacementGroup(sidePlacementCoverDevice, null, b, 1L);
        }
        Placement sidePlacement = new Placement();
        for (IOViewBlock b : blocks) {
            LayoutManager.deriveIOViewPlacementByPlacementGroup(sidePlacement, null, b, 0L);
        }
        return sidePlacement;
    }

    public static Layout deriveInterfaceLayout(IOViewBlock iovb, APoint2D origin) {
        Layout intfPl = new Layout(origin);
        List<IOViewBlock> group0Children = iovb.getChildren().stream().filter(b -> b.getPlacementGroup() == 0L).collect(Collectors.toList());
        List<IOViewBlock> group1Children = iovb.getChildren().stream().filter(b -> b.getPlacementGroup() == 0L).collect(Collectors.toList());
        APoint2D nextChildOrigin = new APoint2D(origin.getX() + iovb.getGap() + iovb.marginLead, origin.getY() + iovb.getInset());
        ARect childrenArea = LayoutManager.deriveArea(group0Children, nextChildOrigin);
        ARect overlapArea = LayoutManager.deriveArea(group1Children, nextChildOrigin);
        childrenArea.expand(overlapArea);
        long marginTrail = 0L;
        childrenArea = childrenArea.expandBy(0L, marginTrail);
        intfPl.addArea(childrenArea);
        return intfPl;
    }

    public static ARect deriveArea(List<IOViewBlock> devices, APoint2D origin) {
        ARect area = null;
        for (IOViewBlock child : devices) {
            Layout childPl = Layout.newDeviceLayout(origin, child);
            origin = childPl.getNextOrigin();
            if (area == null) {
                area = childPl.getArea();
                continue;
            }
            area.expand(childPl.getArea());
        }
        return area;
    }

    public static void deriveIOViewPlacementByPlacementGroup(Placement parent, DevicePath dpParent, IOViewBlock iovb, long group) {
        parent.addGapInset(iovb.gap, iovb.inset);
        Placement working = new Placement(parent.getCurrentLL());
        iovb.ll = new APoint2D(working.getOrigin());
        working.addMargin(iovb.marginLead);
        if (iovb.isInterface()) {
            DevicePath dpIntf = iovb.getDevicePath();
            stack.push(parent);
            for (IOViewBlock child : iovb.children) {
                if (child.getPlacementGroup() != group) continue;
                LayoutManager.deriveIOViewPlacementByPlacementGroup(working, dpIntf, child, group);
            }
            parent = stack.pop();
        } else {
            DevicePath rel2Intf = dpParent.getRelativePath(iovb.getDevicePath());
            if (rel2Intf == null) {
                ALog.logError((String)"Failed to get local to interface coordinates for: %s", (Object[])new Object[]{iovb.getDevicePath()});
                ALog.logError((String)" for interface %s", (Object[])new Object[]{dpParent});
                throw new IllegalArgumentException();
            }
            ARect deviceBB = rel2Intf.getBB();
            working.addWidthHeight(deviceBB.width(), deviceBB.height());
        }
        working.addMargin(iovb.marginTrail);
        iovb.placementRect = working.getPlacementToPoint(APoint2D.Zero());
        parent.addChildPlacement(working);
        parent.unaddInset(iovb.inset);
    }

    public static void deriveIOViewPlacement(Placement parent, DevicePath dpParent, IOViewBlock iovb) {
        parent.addGapInset(iovb.gap, iovb.inset);
        Placement working = new Placement(parent.getCurrentLL());
        iovb.ll = new APoint2D(working.getOrigin());
        working.addMargin(iovb.marginLead);
        if (iovb.isInterface()) {
            DevicePath dpIntf = iovb.getDevicePath();
            stack.push(parent);
            for (IOViewBlock child : iovb.children) {
                if (child.isInPlacementGroup1()) continue;
                LayoutManager.deriveIOViewPlacement(working, dpIntf, child);
            }
            parent = stack.pop();
        } else {
            DevicePath rel2Intf = dpParent.getRelativePath(iovb.getDevicePath());
            if (rel2Intf == null) {
                ALog.logError((String)"Failed to get local to interface coordinates for: %s", (Object[])new Object[]{iovb.getDevicePath()});
                ALog.logError((String)" for interface %s", (Object[])new Object[]{dpParent});
                throw new IllegalArgumentException();
            }
            ARect deviceBB = rel2Intf.getBB();
            working.addWidthHeight(deviceBB.width(), deviceBB.height());
        }
        working.addMargin(iovb.marginTrail);
        iovb.placementRect = working.getPlacementToPoint(APoint2D.Zero());
        parent.addChildPlacement(working);
        parent.unaddInset(iovb.inset);
    }

    public static void deriveIOViewPlacementCoverDevice(Placement parent, DevicePath dpParent, IOViewBlock iovb) {
        parent.addGapInset(iovb.gap, iovb.inset);
        Placement working = new Placement(parent.getCurrentLL());
        iovb.ll = new APoint2D(working.getOrigin());
        if (iovb.isInterface()) {
            DevicePath dpIntf = iovb.getDevicePath();
            stack.push(parent);
            for (IOViewBlock child : iovb.children) {
                if (!child.isInPlacementGroup1()) continue;
                LayoutManager.deriveIOViewPlacementCoverDevice(working, dpIntf, child);
            }
            parent = stack.pop();
        } else {
            DevicePath rel2Intf = dpParent.getRelativePath(iovb.getDevicePath());
            if (rel2Intf == null) {
                ALog.logError((String)"Failed to get local to interface coordinates for: %s", (Object[])new Object[]{iovb.getDevicePath()});
                ALog.logError((String)" for interface %s", (Object[])new Object[]{dpParent});
                throw new IllegalArgumentException();
            }
            ARect deviceBB = rel2Intf.getBB();
            working.addWidthHeight(deviceBB.width(), deviceBB.height());
        }
        iovb.placementRect = working.getPlacementToPoint(APoint2D.Zero());
        parent.addChildPlacement(working);
        parent.unaddInset(iovb.inset);
    }

    public static void placement(APoint2D startingPoint, int side, List<IOViewBlock> blocks) {
        for (IOViewBlock b : blocks) {
            if (!b.isInterface()) continue;
            b.placementStart = startingPoint;
        }
        LayoutManager.placement(true, side, blocks);
    }

    public static void buildGapInset(APoint2D startingPoint, int side, List<IOViewBlock> blocks) {
        for (IOViewBlock b : blocks) {
            if (!b.isInterface()) continue;
            b.placementStart = startingPoint;
        }
        LayoutManager.buildGapInset(true, side, blocks);
    }

    public static APoint2D getIOVLL(boolean isFirstLevel, int side, IOViewBlock b) {
        APoint2D iovLL;
        block7: {
            block6: {
                if (!isFirstLevel) break block6;
                switch (side) {
                    case 0: {
                        iovLL = new APoint2D(-b.ll.getY(), b.ll.getX());
                        break block7;
                    }
                    case 1: {
                        iovLL = new APoint2D(-b.ll.getX(), -b.ll.getY());
                        break block7;
                    }
                    case 2: {
                        iovLL = new APoint2D(b.ll.getY(), -b.ll.getX());
                        break block7;
                    }
                    case 3: {
                        iovLL = b.ll;
                        break block7;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            iovLL = b.ll;
        }
        iovLL = iovLL.add(b.placementStart);
        return iovLL;
    }

    public static long buildGapInset(boolean isFirstLevel, int side, IOViewBlock b, APoint2D offset, long totalGap) {
        block7: {
            long ydiff;
            long xdiff;
            block6: {
                xdiff = -offset.getX();
                ydiff = -offset.getY();
                if (!isFirstLevel) break block6;
                switch (side) {
                    case 0: {
                        b.gap = ydiff - totalGap;
                        b.inset = -xdiff;
                        totalGap = ydiff;
                        break block7;
                    }
                    case 1: {
                        b.gap = -xdiff - totalGap;
                        b.inset = -ydiff;
                        totalGap = -xdiff;
                        break block7;
                    }
                    case 2: {
                        b.gap = -ydiff - totalGap;
                        b.inset = xdiff;
                        totalGap = -ydiff;
                        break block7;
                    }
                    case 3: {
                        b.gap = xdiff - totalGap;
                        b.inset = ydiff;
                        totalGap = xdiff;
                        break block7;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            b.gap = xdiff - totalGap;
            b.inset = ydiff;
            totalGap = xdiff;
        }
        return totalGap;
    }

    public static APoint2D getDeviceLL(boolean isFirstLevel, int side, IOViewBlock b) {
        APoint2D ll = null;
        ARect bounds = b.getDevicePath().getLocalBB();
        if (!isFirstLevel) {
            ll = bounds.getLL();
        } else {
            switch (side) {
                case 0: {
                    ll = bounds.getLR();
                    break;
                }
                case 1: {
                    ll = bounds.getUR();
                    break;
                }
                case 2: {
                    ll = bounds.getUL();
                    break;
                }
                case 3: {
                    ll = bounds.getLL();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported side range!");
                }
            }
        }
        return ll;
    }

    public static long buildGapInset(boolean isFirstLevel, int side, List<IOViewBlock> blocks) {
        long totalGap = 0L;
        for (IOViewBlock b : blocks) {
            APoint2D dLL = LayoutManager.getDeviceLL(isFirstLevel, side, b);
            APoint2D iovLL = LayoutManager.getIOVLL(isFirstLevel, side, b);
            APoint2D offset = iovLL.sub(dLL);
            if (offset.getX() != 0L || offset.getY() != 0L) {
                totalGap = LayoutManager.buildGapInset(isFirstLevel, side, b, offset, totalGap);
            }
            if (!b.isInterface()) continue;
            totalGap += LayoutManager.buildGapInset(false, side, b.getChildren());
        }
        return totalGap;
    }

    public static long placement(boolean isFirstLevel, int side, List<IOViewBlock> blocks) {
        long totalGap = 0L;
        for (IOViewBlock b : blocks) {
            APoint2D dLL = LayoutManager.getDeviceLL(isFirstLevel, side, b);
            APoint2D iovLL = LayoutManager.getIOVLL(isFirstLevel, side, b);
            APoint2D offset = iovLL.sub(dLL);
            if (offset.getX() != 0L || offset.getY() != 0L) {
                b.getDevicePath().getDevice().moveBy(offset);
            }
            if (!b.isInterface()) continue;
            LayoutManager.updateInterfaceBounds(b);
            totalGap += LayoutManager.placement(false, side, b.getChildren());
        }
        return totalGap;
    }

    public static void updateInterfaceBounds(IOViewBlock intf) {
        Device d = intf.getDevicePath().getDevice();
        ARect bounds = d.getTemplate().getBB();
        if (bounds.width() != intf.placementRect.width() || bounds.height() != intf.placementRect.height()) {
            d.getTemplate().setBounds((AGeom)new ARect(0L, 0L, intf.placementRect.width(), intf.placementRect.height()));
        }
    }

    public static void debugOutputPlacementInfo(IOViewBlock dblock, Placement placementInfo, Placement childPlacementInfo) {
        if (!IOView.debugPlacementDetails) {
            return;
        }
        ALog.logInfo((String)"FULL PLACEMENT O:%s, LL:%s, RECT:%s", (Object[])new Object[]{placementInfo.getOrigin(), placementInfo.getCurrentLL(), placementInfo.getArea()});
        ALog.logInfo((String)"INTERFACE PLACEMENT O:%s, LL:%s, RECT:%s", (Object[])new Object[]{childPlacementInfo.getOrigin(), childPlacementInfo.getCurrentLL(), childPlacementInfo.getArea()});
        ALog.logInfo((String)"Interface %s", (Object[])new Object[]{dblock.getName()});
        ALog.logInfo((String)" LL:%s, RECT:%s, marginLeft:%d, gap:%d, inset:%d, marginRight:%d", (Object[])new Object[]{dblock.ll, dblock.placementRect, dblock.marginLead, dblock.gap, dblock.inset, dblock.marginTrail});
        for (IOViewBlock child : dblock.getChildren()) {
            ALog.logInfo((String)"IOVB %s -> LL:%s, RECT:%s, marginLeft:%d, gap:%d, inset:%d, marginRight:%d", (Object[])new Object[]{child.getName(), child.ll, child.placementRect, child.marginLead, child.gap, child.inset, child.marginTrail});
        }
    }

    public static ARect setInterfaceBySide(Device theInterface, ARect rc, int side) {
        ARect newBounds;
        APair<String, APoint2D> loc = IOViewDlg.Side.getSideInterfaceNameLoc(side, rc);
        theInterface.setLoc((APoint2D)loc.second);
        theInterface.setRotate(IOViewDlg.Side.getAngle(side));
        theInterface.setMirror(false);
        if (side == 0 || side == 2) {
            newBounds = new ARect(0L, 0L, rc.height(), rc.width());
        } else if (side == 1 || side == 3) {
            newBounds = new ARect(0L, 0L, rc.width(), rc.height());
        } else {
            ALog.logError((String)"Unexpected side:%d. Side should be between 0 and 3!", (Object[])new Object[]{side});
            throw new IllegalArgumentException();
        }
        return newBounds;
    }

    public static class Layout {
        private ARect area;
        private final APoint2D origin;
        private APoint2D nextOrigin;

        private Layout() {
            throw new UnsupportedOperationException("Must have an origin");
        }

        static Layout newDeviceLayout(APoint2D origin, IOViewBlock iovb) {
            Layout layout = new Layout(origin);
            layout.addDevice(iovb.gap, iovb.inset, iovb.getDevicePath().getDevice());
            return layout;
        }

        public Layout(APoint2D starting) {
            this.origin = starting;
            this.area = ARect.create((APoint2D)starting, (APoint2D)starting);
        }

        public APoint2D getNextOrigin() {
            return this.nextOrigin;
        }

        private void addDevice(long gap, long inset, Device device) {
            ARect dRect = device.getTemplate().getBB();
            dRect.moveBy(gap, inset);
            this.nextOrigin = new APoint2D(dRect.getUR().getX(), this.origin.getY());
            this.area.expand(dRect);
        }

        public ARect getArea() {
            return this.area;
        }

        public void addArea(ARect area) {
            this.area.expand(area);
            this.nextOrigin = new APoint2D(this.area.getUR().getX(), this.origin.getY());
        }
    }

    public static class Placement {
        private APoint2D origin;
        private APoint2D currentLL;
        private ARect area;

        public Placement() {
            this.origin = APoint2D.Zero();
            this.currentLL = APoint2D.Zero();
            this.area = ARect.zero();
        }

        public Placement(APoint2D starting) {
            this.origin = new APoint2D(starting);
            this.currentLL = APoint2D.Zero();
            this.area = ARect.zero();
        }

        public APoint2D getOrigin() {
            return this.origin;
        }

        public APoint2D getCurrentLL() {
            return this.currentLL;
        }

        public ARect getArea() {
            return this.area;
        }

        public void addGapInset(long gap, long inset) {
            this.currentLL = this.currentLL.add(gap, inset);
            this.area.expand(this.currentLL);
        }

        public void addMargin(long margin) {
            this.currentLL = this.currentLL.add(margin, 0L);
            this.area.expand(this.currentLL);
        }

        public void addWidthHeight(long width, long height) {
            APoint2D upperRight = new APoint2D(this.currentLL.getX() + width, this.currentLL.getY() + height);
            this.area.expand(upperRight);
            this.currentLL = this.currentLL.add(width, 0L);
        }

        public void unaddInset(long adjust) {
            this.currentLL = this.currentLL.add(0L, -adjust);
        }

        public void addChildPlacement(Placement childPlacement) {
            long x = childPlacement.getCurrentLL().getX() + childPlacement.getOrigin().getX();
            this.currentLL.setX(x);
            ARect childPlacementArea = childPlacement.getArea();
            childPlacementArea.moveBy(childPlacement.getOrigin());
            this.area.expand(childPlacementArea);
        }

        public ARect getPlacementToPoint(APoint2D start) {
            APoint2D ur = this.area.getUR();
            return ARect.create((APoint2D)start, (APoint2D)ur);
        }
    }
}

