/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Attachment;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.ExternalAttachment;
import com.sigrity.orbit.iov.IOView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PinDefinition {
    public static final String USER_PREFIX = "user.";
    static final String XTAG_PINDEFN = "PinDefintion";
    static final String XTAG_TEMPLATE = "template";
    static final String XATR_NAME = "name";
    static final String XTAG_PIN = "pin";
    static final String XATR_FUNCTION = "function";
    static final String XATR_TYPE = "type";
    static final String XATR_MODE = "mode";
    static final String XATR_DRIVER = "driver";
    static final String XTAG_ATTACHMENT = "attachment";
    static final String XTAG_USE_0 = "rot_0_template";
    static final String XTAG_USE_90 = "rot_90_template";
    static final String XTAG_USE_180 = "rot_180_template";
    static final String XTAG_USE_270 = "rot_270_template";
    public static final String Rot_0_template = "tech.rot_0_template";
    public static final String Rot_90_template = "tech.rot_90_template";
    public static final String Rot_180_template = "tech.rot_180_template";
    public static final String Rot_270_template = "tech.rot_270_template";
    public static final String Display_Order = "tech.display_order";
    public static final String IsDriver = "tech.driver";
    static final String XTAG_DEFAULT_TRANSFORM = "default_transform";
    static final String DefaultTransform = "tech.default_transform";
    static final String XATR_FILE = "file";
    static final String XTAG_MODE = "mode";
    static final String XATR_NETNAME = "net";
    static Substrate mSubstrate = null;

    public static void setSubstrateName(String name) {
        mSubstrate = Substrate.getSubstrate((Db)OrbitIO.getCurDb(), (String)name);
        if (mSubstrate == null) {
            ALog.logWarn((String)(name + " is not a valid substrate name"));
        }
    }

    public static void writeXML(String filePath) {
        Db db = OrbitIO.getCurDb();
        Element root = AXDomUtil.createXmlDoc((String)XTAG_PINDEFN);
        Document doc = root.getOwnerDocument();
        LinkedList lefDefTemplates = new LinkedList();
        lefDefTemplates = mSubstrate == null ? AUtil.linkedList((Iterator)db.getObjects(DeviceTemplate.class, "sourceType", (Object)DeviceTemplate.SourceType.LEFDEF)) : AUtil.linkedList((Iterator)mSubstrate.getDeviceTemplates());
        Collections.sort(lefDefTemplates);
        for (DeviceTemplate dt : lefDefTemplates) {
            String r270;
            String r180;
            String r90;
            String r0;
            Element xeTemplate = AXDomUtil.addElement((Element)root, (String)XTAG_TEMPLATE);
            xeTemplate.setAttribute(XATR_NAME, dt.getName());
            for (Attachment attachment : Attachment.getAttachments((DbObject)dt)) {
                Element xeAttachment = AXDomUtil.addElement((Element)xeTemplate, (String)XTAG_ATTACHMENT);
                xeAttachment.setAttribute(XATR_NAME, attachment.getType());
                URI uri = attachment.getURI();
                String strUri = uri == null ? "" : uri.toASCIIString();
                xeAttachment.setAttribute(XATR_FILE, strUri);
            }
            DeviceTemplate.DefTransform defaultTransform = (DeviceTemplate.DefTransform)dt.getValue(DefaultTransform);
            if (defaultTransform != null) {
                xeTemplate.setAttribute(XTAG_DEFAULT_TRANSFORM, defaultTransform.name());
            }
            if ((r0 = (String)dt.getValue(Rot_0_template)) != null && !r0.isEmpty()) {
                Element e = AXDomUtil.addElement((Element)xeTemplate, (String)XTAG_USE_0);
                e.setAttribute(XTAG_USE_0, r0);
            }
            if ((r90 = (String)dt.getValue(Rot_90_template)) != null && !r90.isEmpty()) {
                Element e = AXDomUtil.addElement((Element)xeTemplate, (String)XTAG_USE_90);
                e.setAttribute(XTAG_USE_90, r90);
            }
            if ((r180 = (String)dt.getValue(Rot_180_template)) != null && !r180.isEmpty()) {
                Element e = AXDomUtil.addElement((Element)xeTemplate, (String)XTAG_USE_180);
                e.setAttribute(XTAG_USE_180, r180);
            }
            if ((r270 = (String)dt.getValue(Rot_270_template)) != null && !r270.isEmpty()) {
                Element e = AXDomUtil.addElement((Element)xeTemplate, (String)XTAG_USE_270);
                e.setAttribute(XTAG_USE_270, r270);
            }
            LinkedList ports = AUtil.linkedList((Iterator)dt.getPins());
            Collections.sort(ports, new DisplayOrderSorter());
            for (PinTemplate dtp : ports) {
                HashMap map;
                Boolean isDriver;
                Element xePin = AXDomUtil.addElement((Element)xeTemplate, (String)XTAG_PIN);
                xePin.setAttribute(XATR_NAME, dtp.getName());
                xePin.setAttribute(XATR_FUNCTION, dtp.getUserFunction());
                if (dtp.getType() != PinTemplate.Type.UNKNOWN) {
                    String typeString = dtp.getType().toString();
                    xePin.setAttribute(XATR_TYPE, typeString);
                }
                if ((isDriver = (Boolean)dtp.getValue(IsDriver)) != null && isDriver.booleanValue()) {
                    xePin.setAttribute(XATR_DRIVER, "true");
                }
                if ((map = (HashMap)dtp.getValue("IOView.Modes")) != null) {
                    for (String mode : map.keySet()) {
                        Element xeMode = AXDomUtil.addElement((Element)xePin, (String)"mode");
                        xeMode.setAttribute(XATR_NAME, mode);
                        String netName = (String)map.get(mode);
                        if (netName == null || netName.length() <= 0) continue;
                        xeMode.setAttribute(XATR_NETNAME, netName);
                    }
                }
                DbClass dbclass = dtp.getDbClass();
                for (DbFieldDef dbf : dbclass.getFields()) {
                    String pValue;
                    String name;
                    if (!dbf.getIsSoft() || !(name = dbf.getName()).startsWith(USER_PREFIX) || (pValue = dbf.getStringValue((DbObject)dtp)) == null) continue;
                    xePin.setAttribute(name, pValue);
                }
            }
        }
        try (FileOutputStream os = new FileOutputStream(filePath);){
            AXDomUtil.serialize((Node)doc, (OutputStream)os);
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"Error writing to '%s'.", (Object[])new Object[]{filePath});
        }
    }

    public static boolean readXML(String pathName) {
        File f = new File(pathName);
        if (!f.canRead()) {
            ALog.logError((String)("Can not open " + f.getAbsolutePath() + " for reading"));
            return false;
        }
        Element xeRoot = AXDomUtil.getDocumentElement((File)f);
        if (xeRoot == null) {
            return false;
        }
        for (Element xeTemplate : AXDomUtil.getChildElems((Node)xeRoot, (String)XTAG_TEMPLATE)) {
            String name = xeTemplate.getAttribute(XATR_NAME);
            if (name == null || name.isEmpty()) continue;
            DeviceTemplate dt = null;
            if (mSubstrate != null) {
                dt = DeviceTemplate.getDeviceTemplate((Substrate)mSubstrate, (String)name);
            } else if (IOView.theIOView != null) {
                mSubstrate = IOView.theIOView.getSubstrate();
                dt = DeviceTemplate.getDeviceTemplate((Substrate)mSubstrate, (String)name);
            } else {
                ALog.logInfo((String)"There is no substrate defined");
                return false;
            }
            if (dt == null) {
                ALog.logWarn((String)"There is no DeviceTemplate named '%s' in the design, the element is being ignored.", (Object[])new Object[]{name});
                continue;
            }
            String defaultXform = xeTemplate.getAttribute(XTAG_DEFAULT_TRANSFORM);
            if (defaultXform != null && !defaultXform.isEmpty()) {
                try {
                    dt.setValue(DefaultTransform, (Object)DeviceTemplate.DefTransform.valueOf((String)defaultXform));
                }
                catch (IllegalArgumentException ioe) {
                    ALog.logWarn((String)("A default transform of " + defaultXform + " was trying to be used and is not valid"));
                }
            }
            String r0 = xeTemplate.getAttribute(XTAG_USE_0);
            PinDefinition.updateTemplateWithRotTemplate(dt, Rot_0_template, r0);
            String r90 = xeTemplate.getAttribute(XTAG_USE_90);
            PinDefinition.updateTemplateWithRotTemplate(dt, Rot_90_template, r90);
            String r180 = xeTemplate.getAttribute(XTAG_USE_180);
            PinDefinition.updateTemplateWithRotTemplate(dt, Rot_180_template, r180);
            String r270 = xeTemplate.getAttribute(XTAG_USE_270);
            PinDefinition.updateTemplateWithRotTemplate(dt, Rot_270_template, r270);
            PinDefinition.addExternalAttachment(dt, xeTemplate);
            int order = 0;
            for (Element xePin : AXDomUtil.getChildElems((Node)xeTemplate, (String)XTAG_PIN)) {
                PinDefinition.updatePinWithXML(dt, name, xePin, order++);
            }
        }
        return true;
    }

    private static void addExternalAttachment(DeviceTemplate dt, Element xeTemplate) {
        for (Element xeAttachment : AXDomUtil.getChildElems((Node)xeTemplate, (String)XTAG_ATTACHMENT)) {
            String type = xeAttachment.getAttribute(XATR_NAME);
            String uri = xeAttachment.getAttribute(XATR_FILE);
            ExternalAttachment.add((String)"DeviceTemplate", (String)dt.getKeyStr(), (String)type, (String)uri);
        }
    }

    private static void updateTemplateWithRotTemplate(DeviceTemplate dt, String rotTemplate, String r) {
        if (r != null && !r.isEmpty()) {
            if (DeviceTemplate.getDeviceTemplate((Substrate)mSubstrate, (String)r) != null) {
                dt.setValue(rotTemplate, (Object)r);
            } else {
                ALog.logWarn((String)("The DeviceTemplate " + r + " Does not exist"));
            }
        }
    }

    private static void updatePinWithXML(DeviceTemplate dt, String dtName, Element xePin, int order) {
        String pinName = xePin.getAttribute(XATR_NAME);
        String functionName = xePin.getAttribute(XATR_FUNCTION);
        String padType = xePin.getAttribute(XATR_TYPE);
        String isDriver = xePin.getAttribute(XATR_DRIVER);
        PinTemplate dtp = dt.getPinByName(pinName);
        if (dtp == null) {
            ALog.logWarn((String)"There is no pin named '%s' on DeviceTemplate '%s'.", (Object[])new Object[]{pinName, dtName});
            return;
        }
        NamedNodeMap nnm = xePin.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node node = nnm.item(i);
            String propName = node.getNodeName();
            if (!propName.startsWith(USER_PREFIX)) continue;
            String propValue = node.getNodeValue();
            dtp.setValue(propName, (Object)propValue);
        }
        if (isDriver.equalsIgnoreCase("true")) {
            dtp.setValue(IsDriver, (Object)true);
        }
        dtp.setValue(Display_Order, (Object)order);
        if (functionName.length() > 0) {
            dtp.setUserFunction(functionName);
        }
        if (padType.length() > 0) {
            try {
                PinTemplate.Type type = PinTemplate.Type.valueOf((String)padType);
                dtp.setType(type);
            }
            catch (IllegalArgumentException ioe) {
                ALog.logWarn((String)("On Template " + dt.getName() + " pin " + dtp.getName() + ": No Such Pad Type as " + padType));
            }
        }
        for (Element xeMode : AXDomUtil.getChildElems((Node)xePin, (String)"mode")) {
            HashMap<String, String> map;
            HashSet<String> set;
            String mode = xeMode.getAttribute(XATR_NAME);
            String net = xeMode.getAttribute(XATR_NETNAME);
            if (mode.length() == 0) {
                ALog.logWarn((String)"A mode specified for template '%s' pin '%s' has no name, it is being ignored.", (Object[])new Object[]{dtName, pinName});
                continue;
            }
            if (dtp.getDbClass().getField("IOView.Modes") == null) {
                dtp.getDbClass().addSoftField("IOView.Modes", HashMap.class);
            }
            if (dt.getDbClass().getField("IOView.Modes") == null) {
                dt.getDbClass().addSoftField("IOView.Modes", HashSet.class);
            }
            if ((set = (HashSet<String>)dt.getValue("IOView.Modes")) == null) {
                set = new HashSet<String>();
                dt.setValue("IOView.Modes", set);
            }
            if (!set.contains(mode)) {
                set.add(mode);
            }
            if ((map = (HashMap<String, String>)dtp.getValue("IOView.Modes")) == null) {
                map = new HashMap<String, String>();
                dtp.setValue("IOView.Modes", map);
            }
            map.put(mode, net);
        }
    }

    static int compareByTechnologyFileOrder(PinTemplate pt0, PinTemplate pt1) {
        Integer order0 = (Integer)pt0.getValue(Display_Order);
        Integer order1 = (Integer)pt1.getValue(Display_Order);
        if (order0 == null || order1 == null) {
            return pt0.compareTo((DbObject)pt1);
        }
        return order0.compareTo(order1);
    }

    public static class DisplayOrderSorter
    implements Comparator<PinTemplate> {
        @Override
        public int compare(PinTemplate pt0, PinTemplate pt1) {
            return PinDefinition.compareByTechnologyFileOrder(pt0, pt1);
        }
    }
}

