/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.BinPacking;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.TemplateTransform;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProgramableTilePlacer {
    protected Element mRootElement = null;
    int nextSpare = 0;
    IOViewBlock parentBlock = null;
    Optional<Personality> parentPersonality;
    Interpreter interpreter;

    public ProgramableTilePlacer(Device d) {
        String xml;
        Substrate s = d.getSubstrate();
        if (s == null) {
            ALog.logError((String)"Device '%s' has no substrate.", (Object[])new Object[]{d.toString()});
            d.zDumpToLog("  ");
            DeviceTemplate dt = d.getTemplate();
            if (dt == null) {
                ALog.logError((String)"The device has a null template.");
            } else {
                dt.zDumpToLog("  ");
            }
        }
        String string = xml = s == null ? null : (String)s.getValue("IOView.PTilesXML", String.class);
        if (xml == null) {
            this.mRootElement = null;
            return;
        }
        ALog.logInfo((String)"Programable tile definitions loaded");
        byte[] currentXMLBytes = xml.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentXMLBytes);
        this.mRootElement = AXDomUtil.getDocumentElement((InputStream)byteArrayInputStream);
    }

    public String getDescriptionOfProgramableTile(String programableTileName) {
        if (this.mRootElement != null) {
            return AXDomUtil.getChildElems((Node)this.mRootElement).stream().filter(e -> e.getNodeName().equals("ProgramableTiles")).flatMap(e -> AXDomUtil.getChildElems((Node)e).stream()).filter(e1 -> e1.getAttribute("name").equals(programableTileName)).findAny().map(e1 -> e1.getAttribute("description")).orElse(null);
        }
        return null;
    }

    public List<String> getProgramableTileNames() {
        if (this.mRootElement != null) {
            return AXDomUtil.getChildElems((Node)this.mRootElement).stream().filter(e -> e.getNodeName().equals("ProgramableTiles")).flatMap(e -> AXDomUtil.getChildElems((Node)e).stream()).map(e1 -> e1.getAttribute("name")).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected Element getTileRule(String ofName) {
        if (this.mRootElement != null) {
            return AXDomUtil.getChildElems((Node)this.mRootElement).stream().filter(e -> e.getNodeName().equals("ProgramableTiles")).flatMap(e -> AXDomUtil.getChildElems((Node)e).stream()).filter(e1 -> e1.getAttribute("name").equals(ofName)).findAny().orElse(null);
        }
        return null;
    }

    String getComputedAttributField(Element e, String fieldName) {
        String attribute = e.getAttribute(fieldName);
        if (!attribute.isEmpty()) {
            if (attribute.startsWith("=")) {
                attribute = attribute.substring(1);
                try {
                    Object o = this.interpreter.eval(attribute);
                    if (o == null) {
                        return attribute;
                    }
                    return o.toString();
                }
                catch (EvalError e1) {
                    ALog.logError((Throwable)e1);
                    return null;
                }
            }
            try {
                Object o = this.interpreter.eval(attribute);
                if (o == null) {
                    return attribute;
                }
                return o.toString();
            }
            catch (EvalError e1) {
                return attribute;
            }
        }
        return null;
    }

    protected long toManufacturingGrid(long u) {
        return this.toManufacturingGrid(new APoint2D(u, u)).getX();
    }

    protected APoint2D toManufacturingGrid(APoint2D u) {
        Substrate substrate = IOView.theIOView.getSubstrate();
        NamedGrid ng = NamedGrid.get((Substrate)substrate, (String)"Manufacturing Grid");
        AGrid grid = null;
        if (ng != null) {
            grid = ng.getGrid();
        }
        if (grid == null) {
            return u;
        }
        return grid.snapToGrid(u);
    }

    protected void updateBlockWithAdjusts(IOViewBlock bp, Element e, boolean ignoreGap, int pass) {
        Db db = OrbitIO.getCurDb();
        if (e != null) {
            String orient;
            String insetS;
            Double result;
            Design currentDesign = Design.getDesign((Db)db);
            Unit.Distance unit = currentDesign.getUnit();
            if (!ignoreGap) {
                String restartGap;
                String gapS = this.getComputedAttributField(e, "gap");
                if (gapS != null) {
                    result = Double.parseDouble(gapS);
                    bp.gap = unit.fromUser(result.doubleValue());
                    long snappedGap = this.toManufacturingGrid(bp.gap);
                    if (bp.gap != snappedGap) {
                        ALog.logInfo((String)("Snapping gap from" + unit.toUser(bp.gap) + " to " + unit.toUser(snappedGap)));
                        bp.gap = snappedGap;
                    }
                }
                if (pass > 0 && (restartGap = this.getComputedAttributField(e, "restartGap")) != null) {
                    Double result2 = Double.parseDouble(restartGap);
                    bp.gap += unit.fromUser(result2.doubleValue());
                }
            }
            if ((insetS = this.getComputedAttributField(e, "inset")) != null) {
                result = Double.parseDouble(insetS);
                bp.inset = unit.fromUser(result.doubleValue());
                long snappedInset = this.toManufacturingGrid(bp.inset);
                if (bp.inset != snappedInset) {
                    ALog.logInfo((String)("Snapping inset from" + unit.toUser(bp.inset) + " to " + unit.toUser(snappedInset)));
                    bp.inset = snappedInset;
                }
            }
            if ((orient = this.getComputedAttributField(e, "orient")) != null) {
                bp.defaultXform = DeviceTemplate.DefTransform.valueOf((String)orient);
            }
        }
    }

    protected IOViewBlock addDecoration(String templateName, String suffix, Element e, int passOfRule) {
        Object name = templateName + "_" + suffix;
        if (e != null && (name = this.getComputedAttributField(e, "name")) == null) {
            name = templateName + "_" + suffix;
        }
        IOViewBlock bp = new IOViewBlock((String)name);
        bp.byTemplate = true;
        bp.template = DeviceTemplate.getDeviceTemplate((Substrate)IOView.theIOView.getSubstrate(), (String)templateName);
        if (bp.template == null) {
            ALog.logError((String)("Can not find a template named " + templateName));
            return null;
        }
        bp.side = this.parentBlock.side;
        bp.parent = this.parentBlock;
        bp.setParentElement(e);
        bp.iAmACover = true;
        DeviceTemplate.DefTransform defaultTransform = (DeviceTemplate.DefTransform)bp.template.getValue("tech.default_transform");
        if (defaultTransform != null) {
            bp.setDefaultXForm(defaultTransform);
        }
        this.updateBlockWithAdjusts(bp, e, false, passOfRule);
        bp.makeDbDevice();
        if (e != null) {
            String netName;
            String doNets = this.getComputedAttributField(e, "generateNets");
            if (doNets != null && doNets.toLowerCase().contains("true")) {
                List ioPorts = bp.devicePath.getLast().getTemplate().getIOPorts();
                String interfaceName = bp.getParent().getName();
                for (PinInstance pi : bp.devicePath.getLast().getPins()) {
                    PinTemplate dtp = pi.getPinTemplate();
                    String netName2 = IOView.createDefaultNetNameForIOPAD(interfaceName, bp.devicePath.getLast().getName(), dtp, ioPorts);
                    if (netName2 == null) continue;
                    NetMap.mapThroughPath((DevicePath)bp.devicePath, (PinInstance)pi, (String)netName2);
                }
            }
            if ((netName = this.getComputedAttributField(e, "net")) != null) {
                DeviceTemplate template = bp.devicePath.getLast().getTemplate();
                PinTemplate pin = null;
                String pinName = this.getComputedAttributField(e, "pin");
                if (pinName != null) {
                    pin = template.getPins().stream().filter(p -> p.getName().equals(pinName)).findAny().orElse(null);
                }
                if (pin == null) {
                    pin = template.getPins().stream().filter(p -> p.getType() == PinTemplate.Type.IOPAD).findAny().orElse(null);
                }
                if (pin != null) {
                    Net net;
                    if (pin.getNet().isUnused()) {
                        net = Net.create((DeviceTemplate)template, (String)pinName);
                        pin.setNet(net);
                    }
                    net = pin.getNet();
                    NetMap.mapThroughPath((DevicePath)bp.devicePath, (Net)net, (String)netName);
                } else {
                    ALog.logWarn((String)"For net:%s, could not find pin of name:%s or IOPAD type", (Object[])new Object[]{netName, name});
                }
            }
        }
        if (this.parentPersonality.isPresent()) {
            bp.devicePath.getLast().assignToPersonality(this.parentPersonality.get());
        }
        bp.devicePath.getLast().setSourceType(Device.SourceType.DECORATOR);
        return bp;
    }

    public List<IOViewBlock> untransform(List<IOViewBlock> input, String transformName) {
        ArrayList<IOViewBlock> output = new ArrayList<IOViewBlock>();
        for (IOViewBlock b : input) {
            Device d = b.getDevicePath().getLast();
            if (d.getSourceType() != Device.SourceType.DECORATOR) {
                b.setGap(0L);
                b.setInset(0L);
                b.setDecorationPass(-1);
                output.add(b);
                continue;
            }
            d.deleteFromDb(false, false);
        }
        Collections.sort(output, new DeviceOrderSorter());
        return output;
    }

    public List<IOViewBlock> markAsUndecorated(List<IOViewBlock> input, String transformName) {
        ArrayList<IOViewBlock> output = new ArrayList<IOViewBlock>();
        for (IOViewBlock b : input) {
            Device d = b.getDevicePath().getLast();
            if (d.getSourceType() == Device.SourceType.DECORATOR) {
                b.setDecorationPass(-1);
                d.setSourceType(Device.SourceType.UNKNOWN);
            }
            output.add(b);
        }
        return output;
    }

    protected boolean fillWithSpares(long wLeft, List<Element> spares, List<IOViewBlock> output, List<IOViewBlock> addedBlocks, List<Element> addedElements, Element e, int passOfRule) {
        if (wLeft <= 0L || spares.isEmpty()) {
            return true;
        }
        BinPacking bp = new BinPacking();
        bp.set1DSpace(wLeft);
        for (Element s : spares) {
            String spareName = this.getComputedAttributField(s, "template");
            if (spareName == null) {
                ALog.logWarn((String)"No Spare Template specified ");
                return false;
            }
            DeviceTemplate spareT = DeviceTemplate.getDeviceTemplate((Substrate)IOView.theIOView.getSubstrate(), (String)spareName);
            if (spareT != null) {
                long thisW = this.getWidthOfThisSpare(spareT);
                bp.add1DBlock(s, thisW);
                continue;
            }
            ALog.logWarn((String)("can not find a template named " + spareName));
            return false;
        }
        ArrayList<Object> spareList = bp.solve1D();
        if (spareList != null) {
            for (Object o : spareList) {
                Element s = (Element)o;
                String spareName = this.getComputedAttributField(s, "template");
                if (spareName == null) {
                    ALog.logWarn((String)"No Spare Template specified ");
                    return false;
                }
                String suffix = "dummy_" + this.nextSpare++;
                IOViewBlock b = this.addDecoration(spareName, suffix, null, passOfRule);
                output.add(b);
                String name = b.getTemplateName() + "_" + suffix;
                b.setDesiredName(name);
                b.devicePath.getLast().setName(name);
                b.setDecorationPass(passOfRule);
                addedBlocks.add(b);
                addedElements.add(e);
            }
            return true;
        }
        ALog.logInfo((String)("Can not fill a gap of width " + wLeft + " with the defined spares"));
        return false;
    }

    protected static boolean alreadyDecorated(List<IOViewBlock> input) {
        return input.stream().anyMatch(b -> b.devicePath.getDevice().getSourceType() == Device.SourceType.DECORATOR);
    }

    protected static ArrayList<PinInstance> getExternalPins(IOViewBlock block) {
        Device d = block.devicePath.getLast();
        ArrayList<PinInstance> ports = new ArrayList<PinInstance>();
        DeviceTemplate dt = d.getTemplate();
        HashSet templateIOPorts = new HashSet(dt.getIOPorts());
        for (PinInstance ioPort : d.getPins()) {
            PinTemplate dtp = ioPort.getPinTemplate();
            if (!templateIOPorts.contains(dtp)) continue;
            ports.add(ioPort);
        }
        float rot = d.getRotate();
        boolean m = d.getMirror();
        d.setRotate(block.defaultXform.getRot());
        d.setMirror(block.defaultXform.getMirror());
        Collections.sort(ports, PinInstance.CompareLocation);
        d.setRotate(rot);
        d.setMirror(m);
        return ports;
    }

    protected static HierPin getExternalPort(List<IOViewBlock> blocks, int startElement, int nth, Element contextElement) {
        boolean seenMyContext = false;
        ArrayList<HierPin> pathports = new ArrayList<HierPin>();
        int blockIndex = startElement;
        while (true) {
            if (blockIndex >= blocks.size()) {
                return null;
            }
            IOViewBlock block = blocks.get(blockIndex);
            if (block.getParentElement() != null && block.getParentElement() == contextElement) {
                seenMyContext = true;
            }
            if (block.getParentElement() != null && block.getParentElement() != contextElement && seenMyContext) {
                return null;
            }
            ArrayList<PinInstance> externalPins = ProgramableTilePlacer.getExternalPins(block);
            for (int pIndex = 0; pIndex < externalPins.size(); ++pIndex) {
                HierPin dpp = new HierPin(block.devicePath, externalPins.get(pIndex));
                pathports.add(dpp);
            }
            if (pathports.size() > nth) break;
            ++blockIndex;
        }
        return (HierPin)pathports.get(nth);
    }

    protected String developInterfaceNetName(List<IOViewBlock> blocks, Element thisConnection, String netName) {
        String interfaceName;
        Object prePendName = "";
        String prePendInterfaceName = this.getComputedAttributField(thisConnection, "prependInterfaceName");
        if (prePendInterfaceName != null && !prePendInterfaceName.isEmpty() && (prePendInterfaceName.contains("yes") || prePendInterfaceName.contains("true")) && !netName.startsWith(interfaceName = blocks.get(0).getParent().getName())) {
            prePendName = interfaceName + "_";
        }
        return (String)prePendName + netName;
    }

    protected void connectUp(List<IOViewBlock> blocks, List<Element> elements) {
        int ithElement = 0;
        while (ithElement < elements.size()) {
            Element e = elements.get(ithElement);
            ArrayList<SlotConnection> slotConnections = new ArrayList<SlotConnection>();
            class SlotConnection {
                ArrayList<Element> connections = new ArrayList();

                SlotConnection() {
                }
            }
            SlotConnection sc = new SlotConnection();
            boolean foundSingle = false;
            for (Element e1 : AXDomUtil.getChildElems((Node)e)) {
                if (!e1.getNodeName().equals("Connection")) continue;
                sc.connections.add(e1);
                foundSingle = true;
            }
            if (foundSingle) {
                slotConnections.add(sc);
            } else {
                for (Element e1 : AXDomUtil.getChildElems((Node)e)) {
                    if (!e1.getNodeName().equals("SlotConnection")) continue;
                    sc = new SlotConnection();
                    slotConnections.add(sc);
                    for (Element e2 : AXDomUtil.getChildElems((Node)e1)) {
                        sc.connections.add(e2);
                    }
                }
            }
            int numberUniqueBlocks = 0;
            Device lastDevice = null;
            for (int slot = 0; slot < slotConnections.size(); ++slot) {
                HierPin fromDevicePathPort = ProgramableTilePlacer.getExternalPort(blocks, ithElement, slot, e);
                ArrayList<Element> thisSlotConnections = ((SlotConnection)slotConnections.get((int)slot)).connections;
                boolean lookingForASpecificFromPin = thisSlotConnections.get(0).hasAttribute("fromPin");
                if (fromDevicePathPort == null && !lookingForASpecificFromPin) continue;
                PinInstance fromPort = null;
                DevicePath fromDevicePath = null;
                if (fromDevicePathPort == null) {
                    fromDevicePath = blocks.get((int)ithElement).devicePath;
                } else {
                    fromPort = fromDevicePathPort.getPin();
                    fromDevicePath = fromDevicePathPort.getPath();
                }
                if (lastDevice != fromDevicePath.getLast()) {
                    ++numberUniqueBlocks;
                }
                lastDevice = fromDevicePath.getLast();
                for (int c = 0; c < thisSlotConnections.size(); ++c) {
                    Element thisConnection = thisSlotConnections.get(c);
                    String specifiedPinName = this.getComputedAttributField(thisConnection, "fromPin");
                    if (specifiedPinName != null && !specifiedPinName.isEmpty()) {
                        fromPort = fromDevicePath.getLast().getPinByName(specifiedPinName);
                        if (fromPort == null) {
                            ALog.logError((String)("A pin " + specifiedPinName + " was explicitly specifed on " + fromDevicePath.getLast().getTemplate().getName() + " and can not be found"));
                            continue;
                        }
                    } else if (fromPort == null) {
                        ALog.logError((String)("Can not find an external pin on " + fromDevicePath.toString()));
                        continue;
                    }
                    Personality pPers = fromPort.getPersonality();
                    String toDeviceName = this.getComputedAttributField(thisConnection, "device");
                    String toPinName = this.getComputedAttributField(thisConnection, "pin");
                    DevicePath toDevicePath = null;
                    PinInstance toPinInstance = null;
                    for (int j = 0; j < elements.size(); ++j) {
                        PinTemplate dtp;
                        Element ej = elements.get(j);
                        String thisName = this.getComputedAttributField(ej, "name");
                        if (thisName == null || toDeviceName == null || !thisName.equals(toDeviceName) || toPinName == null || (dtp = (toDevicePath = blocks.get(j).getDevicePath()).getLast().getTemplate().getPinByName(toPinName)) == null) continue;
                        toPinInstance = toDevicePath.getLast().getPinByName(toPinName);
                        break;
                    }
                    if (toDevicePath != null) {
                        if (toPinInstance != null && fromPort != null) {
                            String netName = this.getComputedAttributField(thisConnection, "net");
                            if (netName == null) {
                                Net n = NetMap.getTopmostNet((Net)fromPort.getNet(), (DevicePath)fromDevicePath);
                                if (n.getDeviceTemplate() != IOView.theIOView.getRootDevicePath().getDeviceTemplate()) {
                                    netName = this.developInterfaceNetName(blocks, thisConnection, n.getName());
                                } else {
                                    netName = n.getName();
                                    NetMap.mapThroughPath((DevicePath)toDevicePath, toPinInstance, (String)netName);
                                }
                            } else {
                                netName = this.developInterfaceNetName(blocks, thisConnection, netName);
                                NetMap.mapThroughPath((DevicePath)fromDevicePath, (PinInstance)fromPort, (String)netName);
                                NetMap.mapThroughPath((DevicePath)toDevicePath, toPinInstance, (String)netName);
                            }
                            if (pPers == null) continue;
                            toPinInstance.assignToPersonality(pPers);
                            continue;
                        }
                        ALog.logError((String)("Looking for a pin  named " + toPinName + " but can't find it on " + toDevicePath.toString()));
                        continue;
                    }
                    ALog.logError((String)("Looking for a block named " + toDeviceName + " but can't find it"));
                }
            }
            if (numberUniqueBlocks == 0) {
                ++ithElement;
                continue;
            }
            ithElement += numberUniqueBlocks;
        }
    }

    protected ArrayList<IOViewBlock> userTransform(IOViewBlock parent, String transformName) {
        ArrayList output = null;
        int i = 0;
        for (IOViewBlock c : parent.children) {
            IOView.setOrder(c.devicePath.getLast(), i++);
        }
        try {
            Cp.getCp().getInterpreter().set("parent", (Object)parent);
            Cp.exec((String)"com.sigrity.orbit.iov.IOViewDecorator iovd = %s()", (Object[])new Object[]{transformName});
            Cp.exec((String)"iovd.setParent(parent)", (Object[])new Object[0]);
            Cp.exec((String)"iovd.decorate();", (Object[])new Object[0]);
            output = (ArrayList)Cp.exec((String)"iovd.getOutput()", (Object[])new Object[0]);
        }
        catch (EvalError e1) {
            ALog.logError((Throwable)e1);
        }
        return output;
    }

    public boolean alreadyDecorated(IOViewBlock parent) {
        List<IOViewBlock> input = parent.children;
        return ProgramableTilePlacer.alreadyDecorated(input);
    }

    protected long getWidthOfThisBlock(IOViewBlock b) {
        long w = b.getGap();
        long horizontalExtent = b.defaultXform.getHorizontalExtent(b.getWidth(), b.getHeight());
        return w + horizontalExtent;
    }

    protected long getWidthOfThisDevice(IOViewBlock b) {
        long w = b.getGap();
        Device d = b.getDevicePath().getLast();
        ARect tbb = d.getTemplate().getBB();
        long horizontalExtent = b.defaultXform.getHorizontalExtent(tbb.width(), tbb.height());
        return w + horizontalExtent;
    }

    protected long getWidthOfThisSpare(DeviceTemplate dt) {
        long w = 0L;
        DeviceTemplate.DefTransform defaultTransform = (DeviceTemplate.DefTransform)dt.getValue("tech.default_transform");
        if (defaultTransform == null) {
            defaultTransform = DeviceTemplate.DefTransform.N;
        }
        ARect tbb = dt.getBB();
        long horizontalExtent = defaultTransform.getHorizontalExtent(tbb.width(), tbb.height());
        return w + horizontalExtent;
    }

    public List<IOViewBlock> transform(IOViewBlock parent, String transformName) {
        List<IOViewBlock> input = parent.children;
        if (ProgramableTilePlacer.alreadyDecorated(input)) {
            return null;
        }
        this.parentBlock = parent;
        String persName = IOView.getPersonalityNameForInterface(parent.getDevicePath());
        this.parentPersonality = Personality.getPersonality((DeviceTemplate)parent.getDie().getTemplate(), (Personality.Type)Personality.Type.DEVICE, (String)persName);
        Element e = this.getTileRule(transformName);
        if (e != null) {
            String type;
            this.interpreter = Cp.getCp().createChildInterpreter();
            try {
                this.interpreter.set("parent", (Object)parent);
                this.interpreter.set("transformname", (Object)transformName);
            }
            catch (EvalError e3) {
                ALog.logError((Throwable)e3);
            }
            String initScript = e.getAttribute("initFunction");
            if (initScript != null) {
                try {
                    this.interpreter.eval(initScript);
                }
                catch (EvalError e2) {
                    ALog.logError((Throwable)e2);
                }
            }
            if ((type = e.getAttribute("type")).equals("script")) {
                return this.userTransform(parent, e.getAttribute("instantiate"));
            }
            if (type.contains("Template")) {
                Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
                TemplateTransform tt = TemplateTransform.newInstance(this, e, unit, this.parentPersonality.get());
                return tt.apply(parent, input);
            }
        }
        return null;
    }

    protected Boolean getBooleanFieldValue(Element e, String field) {
        String bfield = this.getComputedAttributField(e, field);
        if (bfield == null) {
            return null;
        }
        if (bfield.toLowerCase().contains("yes") || bfield.toLowerCase().contains("true")) {
            return true;
        }
        if (bfield.toLowerCase().contains("no") || bfield.toLowerCase().contains("false")) {
            return false;
        }
        return null;
    }

    public static class DeviceOrderSorter
    implements Comparator<IOViewBlock> {
        @Override
        public int compare(IOViewBlock i0, IOViewBlock i1) {
            int o0 = IOView.getOrder(i0.getDevicePath().getLast());
            int o1 = IOView.getOrder(i1.getDevicePath().getLast());
            return o0 - o1;
        }
    }
}

