/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.OrbitIO;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class PtilesMgmt {
    public static void replacePTilesXML(String filePath, String substrateName) {
        Substrate s;
        Object fileString;
        block11: {
            fileString = "";
            s = Substrate.getSubstrate((Db)OrbitIO.getCurDb(), (String)substrateName);
            if (s != null) {
                try (BufferedReader in = new BufferedReader(new FileReader(filePath));){
                    String str = in.readLine();
                    while (str != null) {
                        fileString = (String)fileString + str + "\n";
                        str = in.readLine();
                    }
                    break block11;
                }
                catch (IOException e) {
                    ALog.logError((String)("Can not read " + filePath));
                    return;
                }
            }
            ALog.logError((String)("Substrate " + substrateName + " not found"));
            return;
        }
        DbClass clazz = OrbitIO.getCurDb().getDbClass("Substrate");
        DbFieldDef c = clazz.getField("IOView.PTilesXML");
        if (c == null) {
            c = clazz.addSoftField("IOView.PTilesXML", String.class);
        }
        c.setCData(true);
        int carrotPos = ((String)fileString).indexOf(60);
        fileString = ((String)fileString).substring(carrotPos);
        s.setValue("IOView.PTilesXML", fileString);
        c = clazz.getField("IOView.PTilesFileName");
        if (c == null) {
            c = clazz.addSoftField("IOView.PTilesFileName", String.class);
        }
        c.setCData(false);
        s.setValue("IOView.PTilesFileName", (Object)filePath);
    }

    public static void reImportPTilesXML(String substrateName) {
        Substrate s = Substrate.getSubstrate((Db)OrbitIO.getCurDb(), (String)substrateName);
        if (s != null) {
            DbClass clazz = OrbitIO.getCurDb().getDbClass("Substrate");
            DbFieldDef c = clazz.getField("IOView.PTilesFileName");
            if (c == null) {
                ALog.logWarn((String)"No Ptiles file imported");
                return;
            }
            String filePath = PtilesMgmt.getPTilesFileName(substrateName);
            if (filePath != null) {
                ALog.logInfo((String)("Re Reading " + filePath));
                PtilesMgmt.replacePTilesXML(filePath, substrateName);
            }
        } else {
            ALog.logError((String)("Substrate " + substrateName + " not found"));
            return;
        }
    }

    public static String getPTilesFileName(String substrateName) {
        Substrate s = Substrate.getSubstrate((Db)OrbitIO.getCurDb(), (String)substrateName);
        if (s != null) {
            DbClass clazz = OrbitIO.getCurDb().getDbClass(Substrate.class);
            DbFieldDef c = clazz.getField("IOView.PTilesFileName");
            if (c == null) {
                return null;
            }
            return (String)s.getValue("IOView.PTilesFileName");
        }
        ALog.logError((String)("Substrate " + substrateName + " not found"));
        return null;
    }

    public static String getPTilesXML(String substrateName) {
        return null;
    }
}

