/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

class Range {
    long min;
    long max;

    public static Range newInstance() {
        Range range = new Range(Long.MAX_VALUE, Long.MIN_VALUE);
        return range;
    }

    public Range(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public void add(long value) {
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
    }

    public void add(Range other) {
        if (other.min < this.min) {
            this.min = other.min;
        }
        if (other.max > this.max) {
            this.max = other.max;
        }
    }

    public boolean isValid() {
        return this.min <= this.max;
    }

    public long getLength() {
        return this.isValid() ? this.max - this.min : 0L;
    }

    public String toString() {
        return String.format("[%d,%d]", this.min, this.max);
    }
}

