/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.orbit.iov.Range;

class Range2D {
    Range horizontal;
    Range vertical;

    public static Range2D newInstance() {
        Range2D r2d = new Range2D(Long.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE);
        return r2d;
    }

    public Range2D(long hmin, long hmax, long vmin, long vmax) {
        this.horizontal = new Range(hmin, hmax);
        this.vertical = new Range(vmin, vmax);
    }

    public void add(Range2D other) {
        this.horizontal.add(other.horizontal);
        this.vertical.add(other.vertical);
    }

    public boolean isValid() {
        return this.horizontal.isValid() && this.vertical.isValid();
    }

    public String toString() {
        return String.format("h:%s,v:%s", this.horizontal.toString(), this.vertical.toString());
    }

    public static Range2D max(Range2D a, Range2D b) {
        if (!a.isValid()) {
            a = b;
        }
        if (!b.isValid()) {
            b = a;
        }
        if (!a.isValid()) {
            return new Range2D(0L, 0L, 0L, 0L);
        }
        long hmin = Math.min(a.horizontal.min, b.horizontal.min);
        long hmax = Math.max(a.horizontal.max, b.horizontal.max);
        long vmin = Math.min(a.vertical.min, b.vertical.min);
        long vmax = Math.max(a.vertical.max, b.vertical.max);
        return new Range2D(hmin, hmax, vmin, vmax);
    }
}

