/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.iov;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.ProgramableTilePlacer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class TemplateTransform {
    private ProgramableTilePlacer mPlacer;
    private Unit mUnit;
    private Personality mInterfacePersonality;
    List<Element> tiles;
    List<Element> spares;
    List<IOViewBlock> output;
    List<IOViewBlock> addedBlocks;
    List<Element> addedElements;
    int nextInputIndex;
    int lastInputIndex;
    int passOfRule;
    Element thisRuleElement;
    List<IOViewBlock> input;

    public static TemplateTransform newInstance(ProgramableTilePlacer placer, Element e, Unit unit, Personality interfacePersonality) {
        return new TemplateTransform(placer, e, unit, interfacePersonality);
    }

    private TemplateTransform(ProgramableTilePlacer placer, Element e, Unit unit, Personality interfacePersonality) {
        this.mPlacer = placer;
        this.mUnit = unit;
        this.mInterfacePersonality = interfacePersonality;
        this.tiles = AXDomUtil.getChildElems((Node)e).stream().filter(e1 -> e1.getNodeName().equals("TileDefinition")).flatMap(e1 -> AXDomUtil.getChildElems((Node)e1).stream()).filter(e2 -> e2.getNodeName().equals("Tile")).collect(Collectors.toList());
        this.spares = AXDomUtil.getChildElems((Node)e).stream().filter(e1 -> e1.getNodeName().equals("Spares")).flatMap(e1 -> AXDomUtil.getChildElems((Node)e1).stream()).collect(Collectors.toList());
    }

    List<IOViewBlock> apply(IOViewBlock parent, List<IOViewBlock> input) {
        this.input = input;
        this.output = new LinkedList<IOViewBlock>();
        this.addedBlocks = new LinkedList<IOViewBlock>();
        this.addedElements = new LinkedList<Element>();
        this.nextInputIndex = 0;
        this.lastInputIndex = input.size() - 1;
        this.passOfRule = 0;
        do {
            int prevInputIndex = this.nextInputIndex;
            Iterator<Element> iterator = this.tiles.iterator();
            while (iterator.hasNext()) {
                Element tileElement;
                this.thisRuleElement = tileElement = iterator.next();
                String nextType = this.mPlacer.getComputedAttributField(this.thisRuleElement, "type");
                try {
                    if (!(nextType.equals("decorate") ? !this.applyTypeDecorate() : (nextType.equals("open") ? !this.applyTypeOpen() : (nextType.equals("sequence") ? !this.applyTypeSequence() : (nextType.equals("filler") ? !this.applyTypeFiller() : nextType.equals("margins") && !this.applyTypeMargins()))))) continue;
                    return null;
                }
                catch (Exception e) {
                    break;
                }
            }
            this.mPlacer.connectUp(this.addedBlocks, this.addedElements);
            this.addedBlocks.clear();
            this.addedElements.clear();
            ++this.passOfRule;
            if (this.nextInputIndex == prevInputIndex && !input.isEmpty()) {
                ALog.logWarn((String)("Decorating " + parent.getName() + " Could not find an acceptable io cell to instantiate, and exhausted all the rules"));
                return null;
            }
            if (!input.isEmpty()) continue;
            return this.output;
        } while (!this.hasConsumedAll(input, this.nextInputIndex));
        return this.output;
    }

    private boolean applyTypeDecorate() {
        if (this.hasUsedAllInput() && this.thisRuleElement.getAttribute("require").equals("no")) {
            this.nextInputIndex = this.lastInputIndex + 1;
            throw new IllegalArgumentException();
        }
        String suffix = Integer.toString(this.passOfRule);
        IOViewBlock decorationblock = this.mPlacer.addDecoration(this.mPlacer.getComputedAttributField(this.thisRuleElement, "template"), suffix, this.thisRuleElement, this.passOfRule);
        if (decorationblock == null) {
            return false;
        }
        decorationblock.setDecorationPass(this.passOfRule);
        this.output.add(decorationblock);
        this.addedBlocks.add(decorationblock);
        this.addedElements.add(this.thisRuleElement);
        return true;
    }

    private boolean applyTypeOpen() {
        String width = this.mPlacer.getComputedAttributField(this.thisRuleElement, "size");
        double w = Double.parseDouble(width);
        long wLeft = this.mUnit.fromUser(w);
        if (!this.hasUsedAllInput()) {
            IOViewBlock b = this.input.get(this.nextInputIndex);
            b.devicePath.getLast().setRotate(b.devicePath.getLast().getRotate());
            long thisW = this.mPlacer.getWidthOfThisDevice(b);
            Element openTransformElement = this.thisRuleElement;
            this.mPlacer.updateBlockWithAdjusts(b, openTransformElement, false, this.passOfRule);
            while (thisW <= wLeft) {
                b.setDecorationPass(this.passOfRule);
                b.setParentElement(this.thisRuleElement);
                this.output.add(b);
                this.addedBlocks.add(b);
                this.addedElements.add(this.thisRuleElement);
                wLeft -= thisW;
                ++this.nextInputIndex;
                if (this.nextInputIndex > this.lastInputIndex) break;
                b = this.input.get(this.nextInputIndex);
                thisW = this.mPlacer.getWidthOfThisDevice(b);
                this.mPlacer.updateBlockWithAdjusts(b, openTransformElement, true, this.passOfRule);
            }
        }
        return this.mPlacer.fillWithSpares(wLeft, this.spares, this.output, this.addedBlocks, this.addedElements, this.thisRuleElement, this.passOfRule);
    }

    private boolean applyTypeSequence() {
        String sequence = this.mPlacer.getComputedAttributField(this.thisRuleElement, "number");
        int index = Integer.parseInt(sequence);
        if (index >= 0 && index < this.input.size()) {
            IOViewBlock b = this.input.get(index);
            this.mPlacer.updateBlockWithAdjusts(b, this.thisRuleElement, false, this.passOfRule);
            this.addedBlocks.add(b);
            this.addedElements.add(this.thisRuleElement);
            this.output.add(b);
            return true;
        }
        ALog.logWarn((String)"A sequence number is requesting a block not present in the interface");
        return false;
    }

    private boolean applyTypeFiller() {
        String width = this.mPlacer.getComputedAttributField(this.thisRuleElement, "size");
        double w = Double.parseDouble(width);
        long wLeft = this.mUnit.fromUser(w);
        return this.mPlacer.fillWithSpares(wLeft, this.spares, this.output, this.addedBlocks, this.addedElements, this.thisRuleElement, this.passOfRule);
    }

    private boolean applyTypeMargins() {
        String leadStr = this.mPlacer.getComputedAttributField(this.thisRuleElement, "lead");
        double lead = leadStr == null ? 0.0 : Double.parseDouble(leadStr);
        long marginLead = this.mUnit.fromUser(lead);
        String trailStr = this.mPlacer.getComputedAttributField(this.thisRuleElement, "trail");
        double trail = trailStr == null ? 0.0 : Double.parseDouble(trailStr);
        long marginTrail = this.mUnit.fromUser(trail);
        String gapStr = this.mPlacer.getComputedAttributField(this.thisRuleElement, "gap");
        double gapD = gapStr == null ? 0.0 : Double.parseDouble(gapStr);
        long gap = this.mUnit.fromUser(gapD);
        String insetStr = this.mPlacer.getComputedAttributField(this.thisRuleElement, "inset");
        double insetD = insetStr == null ? 0.0 : Double.parseDouble(insetStr);
        long inset = this.mUnit.fromUser(insetD);
        if (this.mInterfacePersonality != null) {
            this.mInterfacePersonality.setValue("marginLead", (Object)marginLead);
            this.mInterfacePersonality.setValue("marginTrail", (Object)marginTrail);
            this.mInterfacePersonality.setValue("gap", (Object)gap);
            this.mInterfacePersonality.setValue("inset", (Object)inset);
            return true;
        }
        ALog.logError((String)"Interface personality is null");
        return false;
    }

    private boolean hasConsumedAll(List<?> list, int index) {
        return index >= list.size();
    }

    private boolean hasUsedAllInput() {
        return this.hasConsumedAll(this.input, this.nextInputIndex);
    }
}

