/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.jfxui;

import com.sigrity.acl.db.std.Device;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class DevicePathCheckBoxTreeChooser
extends VBox {
    private DevicePathCheckBoxTreeView mDevPathTreeView;

    public DevicePathCheckBoxTreeChooser(DevicePath rootDevicePath) {
        this(rootDevicePath, null);
    }

    public DevicePathCheckBoxTreeChooser(DevicePath rootDevicePath, DeviceFilters.DeviceFilter deviceFilter) {
        super(5.0);
        this.mDevPathTreeView = new DevicePathCheckBoxTreeView(rootDevicePath, deviceFilter);
        VBox.setVgrow((Node)this.mDevPathTreeView, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.mDevPathTreeView);
    }

    public void setExpanded(boolean b) {
        this.mDevPathTreeView.setExpanded(b);
    }

    public boolean isRootSelected() {
        return this.mDevPathTreeView.isRootSelected();
    }

    public Set<Device> getSelectedDevices() {
        return this.mDevPathTreeView.getSelectedDevices();
    }

    public Set<DevicePath> getSelectedDevicePaths() {
        return this.mDevPathTreeView.getSelectedDevicePaths();
    }

    private static class DevicePathCheckBoxTreeView
    extends TreeView<DevicePath> {
        private DevicePath mRootDevPath;
        private DeviceFilters.DeviceFilter mDeviceFilter;
        private Map<DevicePath, CheckBoxTreeItem<DevicePath>> mDevPath2TreeItems = new HashMap<DevicePath, CheckBoxTreeItem<DevicePath>>();
        private static final Callback<TreeItem<DevicePath>, ObservableValue<Boolean>> CHECKBOXTREEITEM_SELECTED_PROPERTY = item -> {
            if (item instanceof CheckBoxTreeItem) {
                return ((CheckBoxTreeItem)item).selectedProperty();
            }
            return null;
        };
        private static final StringConverter<TreeItem<DevicePath>> DEVICEPATH_STRING_CONVERTER = new StringConverter<TreeItem<DevicePath>>(){

            public String toString(TreeItem<DevicePath> object) {
                DevicePath item = (DevicePath)object.getValue();
                Device device = item.getDevice();
                return device == null ? item.getDeviceTemplate().getName() : device.getName();
            }

            public TreeItem<DevicePath> fromString(String string) {
                throw new UnsupportedOperationException();
            }
        };

        public DevicePathCheckBoxTreeView(DevicePath rootDevPath, DeviceFilters.DeviceFilter deviceFilter) {
            this.mRootDevPath = rootDevPath;
            this.mDeviceFilter = deviceFilter;
            this.init();
        }

        public void setExpanded(boolean b) {
            this.getRoot().setExpanded(b);
        }

        public boolean isRootSelected() {
            return ((CheckBoxTreeItem)this.getRoot()).isSelected();
        }

        public Set<Device> getSelectedDevices() {
            return this.mDevPath2TreeItems.values().stream().filter(CheckBoxTreeItem::isSelected).map(TreeItem::getValue).map(DevicePath::getDevice).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        public Set<DevicePath> getSelectedDevicePaths() {
            return this.mDevPath2TreeItems.values().stream().filter(CheckBoxTreeItem::isSelected).map(TreeItem::getValue).collect(Collectors.toSet());
        }

        private void init() {
            TreeItem<DevicePath> rootTreeItem = this.initTreeItem(this.mRootDevPath);
            assert (rootTreeItem != null);
            rootTreeItem.setExpanded(true);
            this.setRoot(rootTreeItem);
            this.setShowRoot(true);
            this.setCellFactory(p -> new CheckBoxTreeCell<DevicePath>(CHECKBOXTREEITEM_SELECTED_PROPERTY, DEVICEPATH_STRING_CONVERTER){

                public void updateItem(DevicePath item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (!empty) {
                        ContextMenu menu = new ContextMenu();
                        MenuItem selectAllMenuItem = new MenuItem("Select all children");
                        selectAllMenuItem.setOnAction(e -> this.selectAllChildern((TreeItem<DevicePath>)this.getTreeItem()));
                        menu.getItems().add((Object)selectAllMenuItem);
                        MenuItem clearAllMenuItem = new MenuItem("Clear all children");
                        clearAllMenuItem.setOnAction(e -> this.clearAllChildern((TreeItem<DevicePath>)this.getTreeItem()));
                        menu.getItems().add((Object)clearAllMenuItem);
                        this.setContextMenu(menu);
                    }
                }
            });
        }

        private TreeItem<DevicePath> initTreeItem(DevicePath devPath) {
            if (devPath.isEmpty() || this.mDeviceFilter == null || this.mDeviceFilter.includeDevice(devPath.getDevice())) {
                CheckBoxTreeItem treeItem = new CheckBoxTreeItem((Object)devPath);
                treeItem.setIndependent(true);
                treeItem.selectedProperty().addListener((obs, oldVal, newVal) -> {
                    if (!treeItem.isExpanded()) {
                        this.selectClearAllChildern((TreeItem<DevicePath>)treeItem, (boolean)newVal);
                    }
                });
                for (DevicePath childDevPath : devPath.getChildren()) {
                    TreeItem<DevicePath> childTreeItem = this.initTreeItem(childDevPath);
                    if (childTreeItem == null) continue;
                    treeItem.getChildren().add(childTreeItem);
                }
                this.mDevPath2TreeItems.put(devPath, (CheckBoxTreeItem<DevicePath>)treeItem);
                return treeItem;
            }
            return null;
        }

        private void selectAllChildern(TreeItem<DevicePath> treeItem) {
            this.selectClearAllChildern(treeItem, true);
        }

        private void clearAllChildern(TreeItem<DevicePath> treeItem) {
            this.selectClearAllChildern(treeItem, false);
        }

        private void selectClearAllChildern(TreeItem<DevicePath> treeItem, boolean isSelect) {
            DevicePath item = (DevicePath)treeItem.getValue();
            item.getDescendants(true).forEach(devPath -> {
                CheckBoxTreeItem<DevicePath> checkBoxTreeItem = this.mDevPath2TreeItems.get(devPath);
                if (checkBoxTreeItem != null) {
                    checkBoxTreeItem.setSelected(isSelect);
                }
                if (treeItem instanceof CheckBoxTreeItem) {
                    ((CheckBoxTreeItem)treeItem).setSelected(isSelect);
                }
            });
        }
    }
}

