/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.jfxui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import java.awt.Window;
import java.util.Deque;
import java.util.LinkedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public abstract class DevicePathTextBox
extends HBox {
    private final Window mOwner;
    private DevicePath mDevPath;
    private TextField mDevPathTxtField;
    private AJFXButton mBackToBtn;
    private AJFXButton mUpToBtn;
    private Deque<DevicePath> mPreDevPaths = new LinkedList<DevicePath>();
    private EventHandler<ActionEvent> mRefreshHandler = event -> this.refresh();
    private EventHandler<ActionEvent> mUpToHandler = event -> this.setDevicePath(this.mDevPath.getParent());
    private EventHandler<ActionEvent> mBackToHandler = event -> this.updateDevicePath(this.mPreDevPaths.pop());
    private EventHandler<KeyEvent> mDevPathTxtFieldHandler = keyEvent -> {
        if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
            DevicePath newDevPath = DevicePath.fromString((Db)this.mDevPath.getDb(), (String)this.mDevPathTxtField.getText());
            if (newDevPath == null || !newDevPath.isValid()) {
                this.showInvalidDevPathAlert();
                this.mDevPathTxtField.setText(this.mDevPath.toString());
            } else {
                this.setDevicePath(newDevPath);
            }
        }
    };

    public DevicePathTextBox(Window owner, DevicePath initDevPath) {
        this.mOwner = owner;
        this.mDevPath = initDevPath;
        this.init();
    }

    public DevicePath getDevicePath() {
        return this.mDevPath;
    }

    public void setDevicePath(DevicePath newDevPath) {
        this.mPreDevPaths.push(this.mDevPath);
        this.updateDevicePath(newDevPath);
    }

    protected abstract void refreshAssociateNodes();

    private void init() {
        this.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        this.mBackToBtn = new AJFXButton(OrbitJFXImages.BACK_TO, this.getBackToStr());
        this.mBackToBtn.transparentBorder();
        this.mBackToBtn.setDisable(this.mPreDevPaths.isEmpty());
        this.mBackToBtn.setOnAction(this.mBackToHandler);
        this.getChildren().add((Object)this.mBackToBtn);
        this.mUpToBtn = new AJFXButton(OrbitJFXImages.UP_TO, this.getUpToStr());
        this.mUpToBtn.transparentBorder();
        this.mUpToBtn.setDisable(this.mDevPath.isEmpty());
        this.mUpToBtn.setOnAction(this.mUpToHandler);
        this.getChildren().add((Object)this.mUpToBtn);
        AJFXButton refreshBtn = new AJFXButton(OrbitJFXImages.REFRESH, "Refresh");
        refreshBtn.transparentBorder();
        refreshBtn.setOnAction(this.mRefreshHandler);
        this.getChildren().add((Object)refreshBtn);
        this.mDevPathTxtField = new TextField(this.mDevPath.toString());
        this.mDevPathTxtField.setOnKeyPressed(this.mDevPathTxtFieldHandler);
        HBox.setHgrow((Node)this.mDevPathTxtField, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.mDevPathTxtField);
        this.setAlignment(Pos.CENTER_LEFT);
    }

    private void updateDevicePath(DevicePath newDevPath) {
        this.mDevPath = newDevPath;
        if (this.mDevPath == null || !this.mDevPath.isValid()) {
            this.mDevPath = Design.getDesignPath((Db)OrbitApp.getCurDb());
        }
        this.refresh();
    }

    private void refresh() {
        this.mDevPathTxtField.setText(this.mDevPath.toString());
        this.mUpToBtn.setDisable(this.mDevPath.isEmpty());
        this.mUpToBtn.setTooltip(this.getUpToStr());
        this.mBackToBtn.setDisable(this.mPreDevPaths.isEmpty());
        this.mBackToBtn.setTooltip(this.getBackToStr());
        this.refreshAssociateNodes();
    }

    private void showInvalidDevPathAlert() {
        String title = "Invalid devicePath";
        String headerTxt = String.format("Invalid devicePath %s.", this.mDevPathTxtField.getText());
        AJFXAlerts.showErrorAlert((Window)this.mOwner, (String)title, (String)headerTxt, null);
    }

    private String getUpToStr() {
        return String.format("Up to '%s'", this.mDevPath.getParent());
    }

    private String getBackToStr() {
        if (this.mPreDevPaths.isEmpty()) {
            return null;
        }
        return String.format("Back to '%s'", this.mPreDevPaths.peek());
    }
}

