/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.jfxui;

import com.google.common.base.Stopwatch;
import com.sigrity.acl.ALog;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXMenuButton;
import com.sigrity.orbit.jfxui.AJFXGetters;
import com.sigrity.orbit.jfxui.ItemSelectMenuItem;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.util.Callback;

public abstract class EditorTableView<T>
extends TableView<T> {
    private ObservableList<T> mItems;
    private FilteredList<T> mFilteredList;
    private SortedList<T> mSortedList;
    private List<EditorTableColumn<?>> mEditorTableColumns = new ArrayList();
    private final EditorTableFilterButton mEditorTableFilterButton = new EditorTableFilterButton();

    public EditorTableView() {
        this.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.initHeader();
        this.iniItemList();
        this.reloadItems();
        this.refreshPredicate();
        this.bindKeys();
    }

    public T getSelectedItem() {
        return (T)this.getSelectionModel().getSelectedItem();
    }

    public ObservableList<T> getSelectedItems() {
        return this.getSelectionModel().getSelectedItems();
    }

    public ObservableList<Integer> getSelectedIndices() {
        return this.getSelectionModel().getSelectedIndices();
    }

    public int getSelectedIndex() {
        return this.getSelectionModel().getSelectedIndex();
    }

    public ObservableList<TablePosition> getSelectedCells() {
        return this.getSelectionModel().getSelectedCells();
    }

    public void addItemListChangeListener(ListChangeListener<T> changeListener) {
        this.mSortedList.addListener(changeListener);
    }

    public EditorTableFilterButton getTableFilterButton() {
        return this.mEditorTableFilterButton;
    }

    public void reloadItems() {
        this.mItems.setAll(this.getItemList());
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void select(int row) {
        int size = this.getItems().size();
        if (row < size) {
            this.getSelectionModel().select(row);
        } else {
            this.getSelectionModel().select(size - 1);
        }
    }

    protected abstract List<T> getItemList();

    protected abstract void initHeader();

    protected abstract void bindKeys();

    protected <F> EditorTableColumn<F> addNewEditorTableColumn(String title, AJFXGetters.TextGetter<F> textGetter, AJFXGetters.ValueGetter<T, F> valueGetter) {
        return this.addNewEditorTableColumn(title, textGetter, valueGetter, null);
    }

    protected <F> EditorTableColumn<F> addNewEditorTableColumn(String title, AJFXGetters.TextGetter<F> textGetter, AJFXGetters.ValueGetter<T, F> valueGetter, TableColumn<T, ?> parentColumn) {
        EditorTableColumn<F> tableColumn = new EditorTableColumn<F>(title, textGetter, valueGetter);
        this.mEditorTableColumns.add(tableColumn);
        if (parentColumn == null) {
            this.getColumns().add(tableColumn);
        } else {
            parentColumn.getColumns().add(tableColumn);
        }
        return tableColumn;
    }

    protected void removeTableColumn(TableColumn tableColumn) {
        if (tableColumn.getTableView() != this) {
            assert (false);
            return;
        }
        TableColumnBase parentColumn = tableColumn.getParentColumn();
        if (parentColumn == null) {
            this.getColumns().remove((Object)tableColumn);
        } else {
            parentColumn.getColumns().remove((Object)tableColumn);
        }
        if (tableColumn instanceof EditorTableColumn) {
            this.mEditorTableColumns.remove(tableColumn);
        }
    }

    protected void setSortedComparator(Comparator<? super T> comparator) {
        this.mSortedList.setComparator(comparator);
        this.getColumns().forEach(col -> col.setSortable(false));
    }

    protected TableColumn<T, String> addNewRowNumCol(AJFXGetters.TextGetter<T> txtGetter) {
        TableColumn<T, String> col = this.newRowNumCol();
        col.setCellValueFactory(param -> new SimpleStringProperty(txtGetter.get(param.getValue())));
        this.getColumns().add(col);
        return col;
    }

    protected TableColumn<T, String> addNewRowNumCol() {
        TableColumn<T, String> col = this.newRowNumCol();
        col.setCellFactory(column -> this.getRowNumCellFactory());
        this.getColumns().add(col);
        return col;
    }

    private TableColumn<T, String> newRowNumCol() {
        TableColumn col = new TableColumn("#");
        col.setPrefWidth(25.0);
        col.setMinWidth(25.0);
        col.getStyleClass().add((Object)"row-number-column");
        col.setSortable(false);
        return col;
    }

    private TableCell<T, String> getRowNumCellFactory() {
        return new TableCell<T, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                TableRow tableRow = this.getTableRow();
                if (empty || tableRow == null) {
                    this.setText(null);
                } else {
                    int rowNum = tableRow.getIndex() + 1;
                    this.setText(Integer.toString(rowNum));
                    this.setAlignment(Pos.CENTER_LEFT);
                }
            }
        };
    }

    public void refreshFocusLater() {
        Platform.runLater(this::refreshFocus);
    }

    public void refreshFocus() {
        this.refresh();
        this.requestFocus();
    }

    protected void refreshPredicate() {
        Predicate columsPredicate = this.mEditorTableColumns.stream().map(EditorTableColumn::getPredicate).reduce(i -> true, (p1, p2) -> p1.and(p2));
        this.mFilteredList.setPredicate(columsPredicate);
    }

    private void iniItemList() {
        this.mItems = FXCollections.observableArrayList();
        this.mFilteredList = new FilteredList(this.mItems, i -> true);
        this.mSortedList = new SortedList(this.mFilteredList);
        this.setItems((ObservableList)this.mSortedList);
    }

    private static double computeMinWidth(String text, int offset) {
        Text jfxText = new Text(text);
        return jfxText.getBoundsInLocal().getWidth() + (double)offset;
    }

    public static interface MouseClickHandler<I, V> {
        public void handle(TableCell<I, V> var1);
    }

    private static class ATableCell<T, C>
    extends TableCell<T, C> {
        private final AJFXGetters.TextGetter<C> mTextGetter;
        private final AJFXGetters.GraphicGetter<C> mGraphicGetter;
        private final AJFXGetters.ContextMenuGetter<C> mContextMenuGetter;
        private final MouseClickHandler<T, C> mMouseClickHandler;

        private ATableCell(AJFXGetters.TextGetter<C> textGetter, AJFXGetters.GraphicGetter<C> graphicGetter, AJFXGetters.ContextMenuGetter<C> contextMenuGetter, MouseClickHandler<T, C> mouseClickHandler) {
            this.mTextGetter = textGetter;
            this.mGraphicGetter = graphicGetter;
            this.mContextMenuGetter = contextMenuGetter;
            this.mMouseClickHandler = mouseClickHandler;
            if (mouseClickHandler != null) {
                this.addEventFilter(MouseEvent.MOUSE_CLICKED, this.newMouseClickEventHandler());
            }
            if (this.mTextGetter != null) {
                this.addWidthListener();
            }
        }

        public void updateItem(C item, boolean empty) {
            super.updateItem(item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                if (this.mTextGetter == null) {
                    this.setAlignment(Pos.CENTER);
                } else {
                    this.setAlignment(Pos.CENTER_LEFT);
                    String origText = this.mTextGetter.get(this.getItem());
                    double currentWidth = this.getWidth();
                    String cutText = this.getCutText(origText, currentWidth);
                    this.setText(cutText);
                }
                if (this.mGraphicGetter != null) {
                    this.setGraphic(this.mGraphicGetter.get(item));
                }
                if (this.mContextMenuGetter != null) {
                    this.setContextMenu(this.mContextMenuGetter.get(item));
                }
            }
        }

        private void addWidthListener() {
            ChangeListener sizeListener = (observable, oldValue, newValue) -> {
                Object item = this.getItem();
                if (item == null) {
                    return;
                }
                String origText = this.mTextGetter.get(item);
                double currentWidth = newValue.doubleValue();
                String cutText = this.getCutText(origText, currentWidth);
                this.setText(cutText);
            };
            this.widthProperty().addListener(sizeListener);
        }

        private String getCutText(String origText, double currentWidth) {
            int endIndex;
            double textMinWidth = EditorTableView.computeMinWidth(origText, 18);
            if (currentWidth > textMinWidth) {
                return origText;
            }
            int textLength = origText.length();
            double widthPreChar = textMinWidth / (double)textLength;
            int removeNum = (int)((textMinWidth - currentWidth) / widthPreChar);
            StringBuilder strBuilder = new StringBuilder(origText);
            int startIndex = textLength / 2 - removeNum / 2 - 2;
            if (startIndex < 0) {
                startIndex = 0;
            }
            if ((endIndex = textLength / 2 + removeNum / 2 + 1) > textLength - 1) {
                endIndex = textLength - 1;
            }
            strBuilder.delete(startIndex, endIndex);
            strBuilder.insert(startIndex, "...");
            return strBuilder.toString();
        }

        private EventHandler<MouseEvent> newMouseClickEventHandler() {
            return new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (this.isEmpty()) {
                        return;
                    }
                    if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2) {
                        mMouseClickHandler.handle(this);
                    }
                }
            };
        }
    }

    public class EditorTableFilterButton
    extends AJFXMenuButton {
        Map<CheckMenuItem, TableColumn<T, ?>> menuItem2TableColumn;

        private EditorTableFilterButton() {
            super(OrbitJFXImages.FILTER_TABLE, "Show...");
            this.menuItem2TableColumn = new HashMap();
            this.transparentBorder();
        }

        public void addFilterCheckBox(String name, TableColumn<T, ?> tableColumn) {
            CheckMenuItem menuItem = new CheckMenuItem(name);
            menuItem.setOnAction(e -> tableColumn.setVisible(menuItem.isSelected()));
            this.getItems().add((Object)menuItem);
        }
    }

    public class EditorTableColumn<C>
    extends TableColumn<T, C> {
        private final String mTitle;
        private final AJFXGetters.TextGetter<C> mTextGetter;
        private final AJFXGetters.ValueGetter<T, C> mValueGetter;
        private AJFXButton mTitleBtn;
        private AJFXMenuButton mTitleMenuBtn;
        private ItemSelectMenuItem<C> mSearchMenuItem;

        protected EditorTableColumn(String title, AJFXGetters.TextGetter<C> textGetter, AJFXGetters.ValueGetter<T, C> valueGetter) {
            this.mTitle = title;
            this.mTextGetter = textGetter;
            this.mValueGetter = valueGetter;
            HBox titleBox = new HBox();
            this.mTitleBtn = this.newTitleButton();
            titleBox.getChildren().add((Object)this.mTitleBtn);
            this.mTitleMenuBtn = this.newHeaderMenuBtn();
            titleBox.getChildren().add((Object)this.mTitleMenuBtn);
            titleBox.setAlignment(Pos.CENTER);
            this.mTitleMenuBtn.setOnShowing(e -> this.mSearchMenuItem.refreshItems(this.getItemValues()));
            this.setMinWidth(this.computeMinWidth());
            this.setGraphic((Node)titleBox);
        }

        public void setTooltip(String toolTipStr) {
            this.mTitleBtn.setTooltip(toolTipStr);
        }

        public Callback<TableColumn.CellDataFeatures<T, String>, ObservableValue<String>> newReadOnlyStringFactory() {
            return param -> new ReadOnlyStringWrapper(this.getItemTxt(param.getValue()));
        }

        public Callback<TableColumn.CellDataFeatures<T, Number>, ObservableValue<Number>> newSimpleDoubleFactory() {
            return param -> new SimpleDoubleProperty(((Number)this.mValueGetter.get(param.getValue())).doubleValue());
        }

        public Callback<TableColumn.CellDataFeatures<T, Number>, ObservableValue<Number>> newSimpleFloatFactory() {
            return param -> new SimpleFloatProperty(((Number)this.mValueGetter.get(param.getValue())).floatValue());
        }

        public Callback<TableColumn.CellDataFeatures<T, Boolean>, ObservableValue<Boolean>> newSimpleBooleanFactory() {
            return param -> new SimpleBooleanProperty(((Boolean)this.mValueGetter.get(param.getValue())).booleanValue());
        }

        public Callback<TableColumn.CellDataFeatures<T, C>, ObservableValue<C>> newSimpleObjectFactory() {
            return param -> new SimpleObjectProperty(this.mValueGetter.get(param.getValue()));
        }

        public Callback<TableColumn<T, C>, TableCell<T, C>> newValueTextCellFactory() {
            return this.newValueTextCellFactory(null, null);
        }

        public Callback<TableColumn<T, C>, TableCell<T, C>> newValueTextCellFactory(MouseClickHandler<T, C> mouseClickHandler) {
            return this.newValueTextCellFactory(null, null, mouseClickHandler);
        }

        public Callback<TableColumn<T, C>, TableCell<T, C>> newValueTextCellFactory(AJFXGetters.ContextMenuGetter<C> contextMenuGetter) {
            return this.newValueTextCellFactory(null, contextMenuGetter, null);
        }

        public Callback<TableColumn<T, C>, TableCell<T, C>> newValueTextCellFactory(AJFXGetters.GraphicGetter<C> graphicGetter, AJFXGetters.ContextMenuGetter<C> contextMenuGetter) {
            return this.newValueTextCellFactory(graphicGetter, contextMenuGetter, null);
        }

        public Callback<TableColumn<T, C>, TableCell<T, C>> newValueTextCellFactory(AJFXGetters.GraphicGetter<C> graphicGetter, AJFXGetters.ContextMenuGetter<C> contextMenuGetter, MouseClickHandler<T, C> mouseClickHandler) {
            return column -> new ATableCell(this.mTextGetter, graphicGetter, contextMenuGetter, mouseClickHandler);
        }

        public Callback<TableColumn<T, C>, TableCell<T, C>> newGraphicCellFactory(AJFXGetters.GraphicGetter<C> graphicGetter, AJFXGetters.ContextMenuGetter<C> contextMenuGetter, MouseClickHandler<T, C> mouseClickHandler) {
            return column -> new ATableCell(null, graphicGetter, contextMenuGetter, mouseClickHandler);
        }

        public void setAllShow(boolean b) {
            this.mSearchMenuItem.setAllShow(b);
        }

        public void setItemShow(C item, boolean b) {
            this.mSearchMenuItem.setItemShow(item, b);
        }

        public Predicate<T> getPredicate() {
            return item -> this.mSearchMenuItem.getPredicate().test(this.mValueGetter.get(item));
        }

        public String getTitle() {
            return this.mTitle;
        }

        private AJFXButton newTitleButton() {
            AJFXButton btn = new AJFXButton(this.mTitle);
            btn.transparentBorder();
            btn.transparentBackground();
            btn.setPadding(new Insets(0.0));
            btn.setOnAction(e -> this.selectColumn());
            return btn;
        }

        private void selectColumn() {
            EditorTableView.this.clearSelection();
            Stopwatch timer = Stopwatch.createStarted();
            int size = EditorTableView.this.getItems().size();
            EditorTableView.this.getSelectionModel().selectRange(0, (TableColumnBase)this, size - 1, (TableColumnBase)this);
            timer.stop();
            ALog.logDebug((String)"Select %d cells on %s column: %s", (Object[])new Object[]{size, this.mTitle, timer});
            EditorTableView.this.requestFocus();
            EditorTableView.this.getFocusModel().focus(0, (TableColumn)this);
        }

        private AJFXMenuButton newHeaderMenuBtn() {
            AJFXMenuButton menuBtn = new AJFXMenuButton();
            menuBtn.transparentBorder();
            menuBtn.transparentBackground();
            menuBtn.setPadding(new Insets(0.0));
            this.mSearchMenuItem = new ItemSelectMenuItem<Object>(this.mTextGetter::get);
            this.mSearchMenuItem.setOnAction(e -> EditorTableView.this.refreshPredicate());
            this.mSearchMenuItem.addKeyPressedListener(key -> {
                if (key == KeyCode.ENTER) {
                    this.mTitleMenuBtn.hide();
                }
            });
            menuBtn.getItems().add(this.mSearchMenuItem);
            return menuBtn;
        }

        private String getItemTxt(T item) {
            C value = this.mValueGetter.get(item);
            return this.mTextGetter.get(value);
        }

        private ObservableList<C> getItemValues() {
            Set values = EditorTableView.this.mItems.stream().map(this.mValueGetter::get).collect(Collectors.toSet());
            return FXCollections.observableArrayList(values);
        }

        private double computeMinWidth() {
            return EditorTableView.computeMinWidth(this.mTitle, 45);
        }
    }
}

