/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.jfxui;

import com.sigrity.orbit.jfxui.AJFXGetters;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javafx.animation.PauseTransition;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;

public class ItemSelectMenuItem<T>
extends CustomMenuItem {
    private FilteredList<T> mFilteredList;
    private ListView<T> mListView;
    private TextField mTxtField;
    private Map<T, CheckBox> mValue2CheckBox = new HashMap<T, CheckBox>();
    private Predicate<T> mCheckBoxPredicate;
    private boolean mDefaultEnable = true;
    private AJFXGetters.TextGetter<T> mTextGetter;
    private ArrayList<KeyPressedListener> mKeyPressedListeners = new ArrayList();

    public ItemSelectMenuItem(AJFXGetters.TextGetter<T> textGetter) {
        this.mTextGetter = textGetter;
        this.init();
    }

    public void setAllShow(boolean b) {
        this.mDefaultEnable = b;
        this.mValue2CheckBox.forEach((i, cb) -> cb.setSelected(b));
    }

    public void setItemShow(T item, boolean b) {
        CheckBox cb = this.mValue2CheckBox.computeIfAbsent(item, i -> new CheckBox(this.mTextGetter.get(item)));
        cb.setSelected(b);
    }

    public Predicate<T> getPredicate() {
        return this.getCheckBoxPredicate().and(item -> {
            if (this.mFilteredList == null) {
                return true;
            }
            return this.mFilteredList.getPredicate().test(item);
        });
    }

    private void init() {
        this.getStyleClass().add((Object)"transparent-focus");
        this.initMainBox();
        this.setHideOnClick(false);
    }

    private Predicate<T> getCheckBoxPredicate() {
        if (this.mCheckBoxPredicate == null) {
            this.mCheckBoxPredicate = item -> {
                CheckBox checkBox = this.mValue2CheckBox.get(item);
                return checkBox == null && this.mDefaultEnable || checkBox != null && checkBox.isSelected();
            };
        }
        return this.mCheckBoxPredicate;
    }

    private void initMainBox() {
        VBox mainBox = new VBox(2.0);
        mainBox.getChildren().add((Object)this.initSearchBox());
        mainBox.getChildren().add((Object)this.initListToolbar());
        mainBox.getChildren().add(this.initListView());
        mainBox.setOnKeyPressed(e -> this.fireKeyPressed(e.getCode()));
        this.setContent((Node)mainBox);
    }

    protected HBox initListToolbar() {
        HBox listToolbar = new HBox(5.0);
        listToolbar.getChildren().add((Object)this.newSelectAllBtn());
        Button clearAllBtn = this.newClearAllBtn();
        listToolbar.getChildren().add((Object)clearAllBtn);
        return listToolbar;
    }

    protected Button newClearAllBtn() {
        Button clearAllBtn = new Button("Clear All");
        clearAllBtn.setOnAction(e -> this.setAllShow(false));
        return clearAllBtn;
    }

    protected Button newSelectAllBtn() {
        Button selectAllBtn = new Button("Select All");
        selectAllBtn.setOnAction(e -> this.setAllShow(true));
        return selectAllBtn;
    }

    private HBox initSearchBox() {
        HBox searchBox = new HBox(2.0);
        this.mTxtField = new TextField();
        this.mTxtField.textProperty().addListener(this.getSearchTxtChangeListener());
        this.mTxtField.setPromptText("Search");
        HBox.setHgrow((Node)this.mTxtField, (Priority)Priority.ALWAYS);
        searchBox.getChildren().add((Object)this.mTxtField);
        searchBox.getChildren().add((Object)new ImageView(OrbitJFXImages.SRCH));
        searchBox.setAlignment(Pos.CENTER);
        return searchBox;
    }

    private ChangeListener<String> getSearchTxtChangeListener() {
        PauseTransition pause = new PauseTransition(Duration.seconds((double)1.0));
        return (observable, oldValue, newValue) -> {
            pause.setOnFinished(event -> this.refreshPredicate());
            pause.playFromStart();
        };
    }

    private ListView<T> initListView() {
        this.mListView = new ListView();
        this.mListView.setCellFactory(this.newCellFactory());
        return this.mListView;
    }

    public void refreshItems(ObservableList<T> items) {
        this.mFilteredList = new FilteredList(items);
        this.mListView.setItems(this.mFilteredList);
        this.refreshPredicate();
    }

    private void refreshPredicate() {
        Predicate<T> newPredicate = this.newPredicate();
        this.mFilteredList.setPredicate(newPredicate);
        this.fire();
    }

    private Predicate<T> newPredicate() {
        return item -> {
            String searchedTxt = this.mTxtField.getText();
            if (searchedTxt == null || searchedTxt.isEmpty()) {
                return true;
            }
            String text = item == null ? "(null)" : this.mTextGetter.get(item);
            return text.contains(searchedTxt);
        };
    }

    private Callback<ListView<T>, ListCell<T>> newCellFactory() {
        return new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> termList) {
                return new ListCell<T>(){

                    protected void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                            return;
                        }
                        CheckBox itemCheckBox = ItemSelectMenuItem.this.mValue2CheckBox.computeIfAbsent(item, x -> {
                            String text = item == null ? "(null)" : ItemSelectMenuItem.this.mTextGetter.get(item);
                            CheckBox cb = new CheckBox(text);
                            cb.setSelected(ItemSelectMenuItem.this.mDefaultEnable);
                            return cb;
                        });
                        this.setGraphic((Node)itemCheckBox);
                    }
                };
            }
        };
    }

    public void addKeyPressedListener(KeyPressedListener l) {
        this.mKeyPressedListeners.add(l);
    }

    public void removeKeyPressedListener(KeyPressedListener l) {
        this.mKeyPressedListeners.remove(l);
    }

    private void fireKeyPressed(KeyCode key) {
        for (KeyPressedListener l : this.mKeyPressedListeners) {
            l.keyPressed(key);
        }
    }

    public static interface KeyPressedListener {
        public void keyPressed(KeyCode var1);
    }
}

