/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.jfxui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.jfxui.render.SubstrateCellFactory;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class SubstrateChooser
extends HBox {
    private Db mDb;
    private Substrate mInitSubstrate;
    private ComboBox<Substrate> mComboBox;

    public SubstrateChooser(Db db, Substrate initSubstrate) {
        super(5.0);
        this.mDb = db;
        this.mInitSubstrate = initSubstrate;
        this.init();
    }

    public void refreshSubstrates() {
        Substrate.getSubstrates((Db)this.mDb).forEach(substrate -> {
            if (!this.mComboBox.getItems().contains(substrate)) {
                this.mComboBox.getItems().add(substrate);
                this.mComboBox.getSelectionModel().select(substrate);
            }
        });
    }

    public void removeSubstrate(Substrate substrate) {
        this.mComboBox.getItems().remove((Object)substrate);
    }

    private void init() {
        Label label = new Label("Substrate:");
        label.setMinWidth(65.0);
        HBox.setHgrow((Node)label, (Priority)Priority.NEVER);
        this.getChildren().add((Object)label);
        this.initComboBox();
        this.setAlignment(Pos.CENTER);
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.refreshSubstrates();
        this.initSelectedSubstrate();
    }

    private void initComboBox() {
        this.mComboBox = new ComboBox();
        this.mComboBox.setCellFactory((Callback)new SubstrateCellFactory());
        this.mComboBox.setButtonCell((ListCell)new SubstrateCellFactory.SubstrateCell());
        this.mComboBox.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(this.mComboBox, (Priority)Priority.ALWAYS);
        this.getChildren().add(this.mComboBox);
    }

    private void initSelectedSubstrate() {
        if (this.mInitSubstrate != null) {
            this.mComboBox.getSelectionModel().select((Object)this.mInitSubstrate);
        }
    }

    public Substrate getSelectedSubstrate() {
        return (Substrate)this.mComboBox.getSelectionModel().getSelectedItem();
    }

    public void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.mComboBox.setOnAction(eventHandler);
    }
}

