/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.oio3d;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AggregateIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableDouble;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.ui.AContextMenu;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class A3DViewPanel
extends JPanel {
    protected ActionMap mActions = new ActionMap();
    protected Canvas3D mCanvas3d = null;
    protected SimpleUniverse mUniverse;
    protected BranchGroup mContentRoot;
    protected TransformGroup mXFormContent;
    protected BranchGroup mContent;
    protected boolean mContentInitialized = false;
    protected ViewingPlatform mViewingPlatform;
    protected View mView;
    protected XForm3D mXform = new XForm3D();
    protected SpotLight mHeadlight;
    protected AmbientLight mAmbientLight;
    protected LinkedHashMap<String, XForm3D> mDefinedViews = new LinkedHashMap();
    protected FocusListener mPanelFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (A3DViewPanel.this.mCanvas3d != null) {
                        A3DViewPanel.this.mCanvas3d.requestFocusInWindow();
                    }
                }
            });
        }
    };

    public A3DViewPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
        this.createUniverse();
        this.setMinimumSize(new Dimension(50, 50));
        this.handleMouseEvents();
        this.handleKeyEvents();
    }

    protected void pan(int xDir, int yDir) {
        this.mXform.pan(xDir, yDir);
    }

    protected void zoom(double zDir) {
        this.mXform.zoom(zDir);
    }

    protected void rotate(double rx, double ry, double rz) {
        this.mXform.rotate(rx, ry, rz);
    }

    protected void handleKeyEvents() {
        this.mCanvas3d.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    A3DViewPanel.this.pan(0, -1);
                } else if (e.getKeyCode() == 40) {
                    A3DViewPanel.this.pan(0, 1);
                } else if (e.getKeyCode() == 37) {
                    A3DViewPanel.this.pan(1, 0);
                } else if (e.getKeyCode() == 39) {
                    A3DViewPanel.this.pan(-1, 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    protected void handleMouseEvents() {
        final MutableDouble mousePosX = new MutableDouble();
        final MutableDouble mousePosY = new MutableDouble();
        this.mCanvas3d.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                mousePosX.setValue((double)e.getX());
                mousePosY.setValue((double)e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.mCanvas3d.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    double dy = (mousePosX.getValue() - (double)e.getX()) / 10.0 * (Math.PI / 180);
                    double dx = (mousePosY.getValue() - (double)e.getY()) / 10.0 * (Math.PI / 180);
                    A3DViewPanel.this.rotate(-dx, -dy, 0.0);
                }
                mousePosX.setValue((double)e.getX());
                mousePosY.setValue((double)e.getY());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.mCanvas3d.addMouseWheelListener(e -> {
            if (e.getUnitsToScroll() < 0) {
                this.zoom(0.9);
            } else {
                this.zoom(1.1111111111111112);
            }
        });
    }

    public void setContent(BranchGroup content) {
        if (this.mContent != null) {
            this.mXFormContent.removeChild((Node)this.mContent);
        }
        this.mContent = content;
        if (this.mContent == null || this.mUniverse == null) {
            return;
        }
        if (!this.mContentInitialized) {
            assert (this.mXFormContent != null);
            BoundingSphere contentBounds = new BoundingSphere(this.mContent.getBounds());
            double r = contentBounds.getRadius();
            double frontClip = r * 0.001;
            double backClip = frontClip * 3000.0;
            this.mView.setFrontClipDistance(frontClip);
            this.mView.setBackClipDistance(backClip);
            this.createInitialViews();
            this.setView("Top");
            this.mContent.setCapability(17);
            this.mXFormContent.addChild((Node)this.mContent);
            this.mUniverse.addBranchGraph(this.mContentRoot);
            this.mContentInitialized = true;
        } else {
            this.mContent.setCapability(17);
            this.mXFormContent.addChild((Node)this.mContent);
        }
    }

    public void createInitialViews() {
        BoundingSphere contentBounds = new BoundingSphere(this.mContent.getBounds());
        Point3d contentCenter = new Point3d();
        contentBounds.getCenter(contentCenter);
        double vz = contentCenter.z + contentBounds.getRadius() * 2.5;
        Transform3D viewerXform = new Transform3D();
        viewerXform.setTranslation(new Vector3d(0.0, 0.0, vz));
        this.mDefinedViews.put("Top", new XForm3D(0.0, 0.0, vz, 0.0, 0.0, 0.0));
        this.mDefinedViews.put("Bottom", new XForm3D(0.0, 0.0, vz, 0.0, Math.PI, 0.0));
        this.mDefinedViews.put("Front", new XForm3D(0.0, 0.0, vz, 1.5707963267948966, 0.0, 0.0));
        this.mDefinedViews.put("Back", new XForm3D(0.0, 0.0, vz, -1.5707963267948966, 0.0, Math.PI));
        this.mDefinedViews.put("Left", new XForm3D(0.0, 0.0, vz, 1.5707963267948966, 1.5707963267948966, 0.0));
        this.mDefinedViews.put("Right", new XForm3D(0.0, 0.0, vz, 1.5707963267948966, -1.5707963267948966, 0.0));
    }

    public IterableIterator<String> getDefinedViews() {
        return AIterableItr.itr(this.mDefinedViews.keySet());
    }

    public void setView(String name) {
        XForm3D xform = this.mDefinedViews.get(name);
        if (xform == null) {
            ALog.logWarn((String)"'%s' is not a valid view name, the view is not being changed.", (Object[])new Object[]{name});
            return;
        }
        this.mXform.setView(xform);
    }

    public IterableIterator<Action> getViewContextActions(int x, int y) {
        ProcessingIterator<String, Action> setViewActions = new ProcessingIterator<String, Action>(this.mDefinedViews.keySet().iterator()){

            protected Action process(final String viewName) {
                return new AbstractAction(viewName + " view"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        A3DViewPanel.this.setView(viewName);
                    }
                };
            }
        };
        AIterableItr otherActions = new AIterableItr((Object[])new Action[]{null, new ToggleHeadlightAction(), new ToggleAmbientLightAction()});
        return new AggregateIterator((Iterator)setViewActions, (Iterator)otherActions);
    }

    public void displayContextMenu(int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        for (Action a : this.getViewContextActions(x, y)) {
            if (a == null) {
                menu.add(new JSeparator());
                continue;
            }
            if (a instanceof GetMenuItem) {
                menu.add(((GetMenuItem)((Object)a)).getMenuItem());
                continue;
            }
            menu.add(a);
        }
        if (menu.getComponentCount() > 0) {
            menu.show((Component)this.mCanvas3d, x, y);
        }
    }

    protected void createUniverse() {
        if (this.mCanvas3d != null) {
            this.remove((Component)this.mCanvas3d);
            this.mCanvas3d = null;
        }
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.mCanvas3d = new Canvas3D(config);
        this.add((Component)this.mCanvas3d, "Center");
        this.addFocusListener(this.mPanelFocusListener);
        AContextMenu.install((Component)this.mCanvas3d, (AContextMenu.MenuProvider)new AContextMenu.MenuProvider(){

            public void showMenu(Component c, int x, int y) {
                A3DViewPanel.this.displayContextMenu(x, y);
            }
        });
        this.mUniverse = new SimpleUniverse(this.mCanvas3d);
        this.mViewingPlatform = this.mUniverse.getViewingPlatform();
        this.mView = this.mUniverse.getViewer().getView();
        this.mContentRoot = new BranchGroup();
        this.mXFormContent = new TransformGroup();
        this.mXFormContent.setCapability(17);
        this.mXFormContent.setCapability(18);
        this.mXFormContent.setCapability(13);
        this.mXFormContent.setCapability(14);
        this.mContentRoot.addChild((Node)this.mXFormContent);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 3000.0);
        Color3f headlightColor = new Color3f(1.0f, 1.0f, 1.0f);
        Point3f lightPosition = new Point3f(0.0f, 0.0f, 20.0f);
        Point3f lightAttenuation = new Point3f(1.0f, 0.02f, 0.0f);
        Vector3f lightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        float spreadAngle = 0.10471976f;
        float concentration = 92.0f;
        this.mHeadlight = new SpotLight(headlightColor, lightPosition, lightAttenuation, lightDirection, spreadAngle, concentration);
        this.mHeadlight.setCapability(12);
        this.mHeadlight.setCapability(13);
        this.mHeadlight.setInfluencingBounds((Bounds)bounds);
        BranchGroup headlightGroup = new BranchGroup();
        headlightGroup.addChild((Node)this.mHeadlight);
        this.mViewingPlatform.getViewPlatformTransform().addChild((Node)headlightGroup);
        Color3f ambientLightColor = new Color3f(0.8f, 0.8f, 0.8f);
        this.mAmbientLight = new AmbientLight(ambientLightColor);
        this.mAmbientLight.setCapability(12);
        this.mAmbientLight.setCapability(13);
        this.mAmbientLight.setInfluencingBounds((Bounds)bounds);
        this.mContentRoot.addChild((Node)this.mAmbientLight);
    }

    public static void rotZ(Transform3D x, double a) {
        Transform3D x2 = new Transform3D();
        x2.rotZ(a);
        x.mul(x2);
    }

    protected class ToggleAmbientLightAction
    extends AbstractAction
    implements GetMenuItem {
        public ToggleAmbientLightAction() {
            super("Ambient light");
            this.putValue("SwingSelectedKey", A3DViewPanel.this.mAmbientLight.getEnable());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            A3DViewPanel.this.mAmbientLight.setEnable(!A3DViewPanel.this.mAmbientLight.getEnable());
            this.putValue("SwingSelectedKey", A3DViewPanel.this.mAmbientLight.getEnable());
        }

        @Override
        public JMenuItem getMenuItem() {
            return new JCheckBoxMenuItem(this);
        }
    }

    protected class ToggleHeadlightAction
    extends AbstractAction
    implements GetMenuItem {
        public ToggleHeadlightAction() {
            super("Headlight");
            this.putValue("SwingSelectedKey", A3DViewPanel.this.mHeadlight.getEnable());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            A3DViewPanel.this.mHeadlight.setEnable(!A3DViewPanel.this.mHeadlight.getEnable());
            this.putValue("SwingSelectedKey", A3DViewPanel.this.mHeadlight.getEnable());
        }

        @Override
        public JMenuItem getMenuItem() {
            return new JCheckBoxMenuItem(this);
        }
    }

    public static interface GetMenuItem {
        public JMenuItem getMenuItem();
    }

    protected class XForm3D {
        double vx;
        double vy;
        double vz;
        double rx;
        double ry;
        double rz;

        public XForm3D() {
        }

        public XForm3D(double vx, double vy, double vz, double rx, double ry, double rz) {
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
            this.rx = rx;
            this.ry = ry;
            this.rz = rz;
        }

        void setView(XForm3D view) {
            this.rx = view.rx;
            this.ry = view.ry;
            this.rz = view.rz;
            this.vz = view.vz;
            this.update();
        }

        public void update(XForm3D form) {
            this.vx = form.vx;
            this.vy = form.vy;
            this.vz = form.vz;
            this.rx = form.rx;
            this.ry = form.ry;
            this.rz = form.rz;
            this.update();
        }

        void update() {
            Transform3D viewerXform = new Transform3D();
            Transform3D contentXform = new Transform3D();
            Transform3D r = new Transform3D();
            r.rotX(this.rx);
            contentXform.mul(r);
            r.rotX(0.0);
            r.rotY(this.ry);
            contentXform.mul(r);
            r.rotY(0.0);
            r.rotZ(this.rz);
            contentXform.mul(r);
            r.rotZ(0.0);
            Transform3D t = new Transform3D();
            t.setTranslation(new Vector3d(this.vx, this.vy, 0.0));
            contentXform.mul(t);
            t = new Transform3D();
            t.setTranslation(new Vector3d(0.0, 0.0, this.vz));
            viewerXform.mul(t);
            A3DViewPanel.this.mXFormContent.setTransform(contentXform);
            A3DViewPanel.this.mViewingPlatform.getViewPlatformTransform().setTransform(viewerXform);
        }

        public void pan(int xDir, int yDir) {
            this.vx += (double)Math.signum(xDir) * this.vz / 10.0;
            this.vy += (double)Math.signum(yDir) * this.vz / 10.0;
            this.update();
        }

        public void zoom(double zDir) {
            this.vz *= zDir;
            this.update();
        }

        public void rotate(double rx, double ry, double rz) {
            this.rx += rx;
            this.ry += ry;
            this.rz += rz;
            this.update();
        }
    }
}

