/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.oio3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;

public class ExtrudedPolygon
extends Shape3D {
    public ExtrudedPolygon(Appearance a, double[] xys, double dz) {
        double[] pts;
        int i;
        this.setPickable(false);
        this.setCollidable(false);
        int ptCount = xys.length / 2;
        double z0 = 0.0;
        double z1 = z0 + dz;
        boolean fill = true;
        if (fill) {
            GeometryInfo bottom = new GeometryInfo(5);
            double[] bpts = new double[ptCount * 3];
            for (i = 0; i < ptCount; ++i) {
                bpts[(ptCount - 1) * 3 - i * 3 + 0] = xys[i * 2 + 0];
                bpts[(ptCount - 1) * 3 - i * 3 + 1] = xys[i * 2 + 1];
                bpts[(ptCount - 1) * 3 - i * 3 + 2] = z0;
            }
            bottom.setCoordinates(bpts);
            bottom.setStripCounts(new int[]{ptCount});
            bottom.setContourCounts(new int[]{1});
            new NormalGenerator().generateNormals(bottom);
            this.addGeometry((Geometry)bottom.getGeometryArray());
        } else if (dz == 0.0) {
            LineStripArray lines = new LineStripArray(ptCount + 1, 129, new int[]{ptCount + 1});
            pts = new double[(ptCount + 1) * 3];
            for (i = 0; i < ptCount; ++i) {
                pts[i * 3 + 0] = xys[i * 2 + 0];
                pts[i * 3 + 1] = xys[i * 2 + 1];
                pts[i * 3 + 2] = z0;
            }
            pts[ptCount * 3 + 0] = pts[0];
            pts[ptCount * 3 + 1] = pts[1];
            pts[ptCount * 3 + 2] = pts[2];
            lines.setCoordRefDouble(pts);
            this.addGeometry((Geometry)lines);
        }
        if (dz != 0.0) {
            QuadArray sides = new QuadArray(ptCount * 4, 129);
            pts = new double[ptCount * 12];
            for (i = 0; i < ptCount; ++i) {
                double x0 = xys[i * 2 + 0];
                double y0 = xys[i * 2 + 1];
                double x1 = i == ptCount - 1 ? xys[0] : xys[(i + 1) * 2 + 0];
                double y1 = i == ptCount - 1 ? xys[1] : xys[(i + 1) * 2 + 1];
                pts[i * 12 + 0] = x0;
                pts[i * 12 + 1] = y0;
                pts[i * 12 + 2] = z0;
                pts[i * 12 + 3] = x1;
                pts[i * 12 + 4] = y1;
                pts[i * 12 + 5] = z0;
                pts[i * 12 + 6] = x1;
                pts[i * 12 + 7] = y1;
                pts[i * 12 + 8] = z1;
                pts[i * 12 + 9] = x0;
                pts[i * 12 + 10] = y0;
                pts[i * 12 + 11] = z1;
            }
            sides.setCoordRefDouble(pts);
            this.addGeometry((Geometry)sides);
        }
        if (fill) {
            GeometryInfo top = new GeometryInfo(5);
            double[] tpts = new double[ptCount * 3];
            for (i = 0; i < ptCount; ++i) {
                tpts[i * 3 + 0] = xys[i * 2 + 0];
                tpts[i * 3 + 1] = xys[i * 2 + 1];
                tpts[i * 3 + 2] = z1;
            }
            top.setCoordinates(tpts);
            top.setStripCounts(new int[]{ptCount});
            top.setContourCounts(new int[]{1});
            new NormalGenerator().generateNormals(top);
            this.addGeometry((Geometry)top.getGeometryArray());
        }
        this.setAppearance(a);
    }
}

