/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.peripheralIOMgmt;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import java.util.ArrayList;

public class IOMgmt {
    protected Node root;

    public void dbToNodes(DevicePath parentPath) {
        this.root = new Node(parentPath.getLast());
        Device d = parentPath.getLast();
        for (Device child : d.getTemplate().getChildren()) {
            if (child.getTemplate().getType() != DeviceTemplate.Type.PAD && child.getTemplate().getType() != DeviceTemplate.Type.BLOCK) continue;
            this.addNode(this.root, child);
        }
    }

    protected void addNode(Node parent, Device child) {
        Node n = new Node(child);
        parent.children.add(n);
        for (Device grandChild : child.getTemplate().getChildren()) {
            this.addNode(n, grandChild);
        }
    }

    public void nodesToSS() {
    }

    public void nodesToDb() {
    }

    public void ssToNodes() {
    }

    public class Node {
        ArrayList<Node> children = new ArrayList();
        protected Device device;
        protected int side;
        protected int row;
        protected long gap;
        protected long inset;
        protected PinTemplate connectPin;

        public Node(Device d) {
            this.device = d;
        }
    }

    public static enum SequenceType {
        Relative,
        Absolute;

    }
}

