/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.peripheralIOMgmt;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.peripheralIOMgmt.IOMgmt;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class IOMgmtUI {

    public class IOTreeNode
    extends ALazyTreeNode {
        protected IOMgmt.Node node;
        protected NodeType type;
        protected ArrayList<IOTreeNode> mChildNodes;

        public IOTreeNode(ATreeNode parent, IOMgmt.Node n) {
            super(parent);
            this.node = n;
        }

        public IOMgmt.Node getNode() {
            return this.node;
        }

        public IterableIterator<IOTreeNode> getChildNodes() {
            if (this.mChildNodes == null) {
                return AEmptyItr.create();
            }
            return new AIterableItr(this.mChildNodes.iterator());
        }

        public IOTreeNode getNode(int idx) {
            if (this.mChildNodes == null) {
                return null;
            }
            return this.mChildNodes.get(idx);
        }

        public void remove(int idx) {
            if (this.mChildNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mChildNodes.get(idx)};
            this.mChildNodes.remove(idx);
            this.mTreeModel.treeNodesRemoved((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public void update(int idx) {
            if (this.mChildNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mChildNodes.get(idx)};
            this.mTreeModel.treeNodesChanged((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public ArrayList<IOTreeNode> populateChildren() {
            return this.mChildNodes;
        }

        public String getText() {
            return "";
        }
    }

    public static enum NodeType {
        Quadrant,
        IONode;

    }

    protected static class IONodeTree
    extends JTree
    implements Autoscroll {
        protected ATreeModel mDbTreeModel;
        protected IOTreeNode mOldDropTarget = null;
        protected IOTreeNode mDropTaget = null;
        protected PopupMenuHandler mPopupMenuHandler = null;
        protected MouseListener mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }
        };
        protected Insets m_autoscrollInsets = new Insets(20, 20, 20, 20);

        public IONodeTree(ATreeModel tm) {
            super((TreeModel)tm);
            this.mDbTreeModel = tm;
            this.addMouseListener(this.mMouseListener);
        }

        public void setPopupMenuHandler(PopupMenuHandler h) {
            this.mPopupMenuHandler = h;
        }

        public ATreeNode getNodeAtPoint(Point pt) {
            TreePath path = this.getPathForLocation(pt.x, pt.y);
            if (path == null) {
                return null;
            }
            Object obj = path.getLastPathComponent();
            if (obj instanceof ATreeNode) {
                return (ATreeNode)obj;
            }
            return null;
        }

        protected void popupMenu(MouseEvent e) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            this.setSelectionRow(row);
            if (this.mPopupMenuHandler != null) {
                this.mPopupMenuHandler.handlePopup(e.getX(), e.getY());
            }
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.m_autoscrollInsets;
        }

        @Override
        public void autoscroll(Point cursorLocation) {
            Insets insets = this.getAutoscrollInsets();
            Rectangle outer = this.getVisibleRect();
            Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
            if (!inner.contains(cursorLocation)) {
                Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
                this.scrollRectToVisible(scrollRect);
            }
        }

        static interface PopupMenuHandler {
            public void handlePopup(int var1, int var2);
        }
    }
}

