/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.pin_label;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.pin_label.PinLabelCsv;
import java.util.Date;

public class PinLabelExport {
    private Db mDb;
    private DeviceTemplate mDevT;
    private PinLabelCsv mPinLabelCsv;
    private String[] mCsvHeader;

    public PinLabelExport(DeviceTemplate devT) {
        this.mDb = devT.getDb();
        this.mDevT = devT;
        this.mPinLabelCsv = new PinLabelCsv(this.mDb);
    }

    public void exportCsv(String filePath) {
        assert (this.mDb != null && this.mDevT != null);
        try (ACsvWriter out = ACsvWriter.open((String)filePath);){
            this.writeTermMapCsv(out);
            ALog.logInfo((String)"Export pinLabel to %s complete.", (Object[])new Object[]{filePath});
        }
        catch (Exception excep) {
            ALog.logError((Throwable)excep, (String)"There was an unexpected exception while writing file.", (Object[])new Object[0]);
        }
    }

    private void writeTermMapCsv(ACsvWriter csvWriter) {
        this.writeDesignInfo(csvWriter);
        this.writeDevTInfo(csvWriter);
        this.writeHeader(csvWriter);
        this.writePinlabels(csvWriter);
    }

    protected void writeDesignInfo(ACsvWriter csvWriter) {
        assert (this.mDb != null && csvWriter != null);
        csvWriter.row(new String[]{String.format("#. %s version %s", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion())});
        csvWriter.row(new String[]{String.format("#. Build: %s (%s)", ABuildInfo.getVersion(), ABuildInfo.getTimestamp())});
        csvWriter.row(new String[]{String.format("#. User: %s", System.getProperty("user.name"))});
        csvWriter.row(new String[]{String.format("#. Time: %s", new Date())});
        String file = this.mDb.getCanonicalPath();
        csvWriter.row(new String[]{String.format("#. Source design: %s", file != null ? file : "<Unsaved Design>")});
        csvWriter.row(new String[]{"#."});
    }

    private void writeDevTInfo(ACsvWriter csvWriter) {
        csvWriter.row(new String[]{String.format("#. Substrate: %s", this.mDevT.getSubstrate().getName())});
        csvWriter.row(new String[]{String.format("#. Device template: %s", this.mDevT.getName())});
    }

    private void writeHeader(ACsvWriter csvWriter) {
        this.mCsvHeader = this.mPinLabelCsv.getHeader();
        csvWriter.header(this.mCsvHeader);
    }

    private void writePinlabels(ACsvWriter csvWriter) {
        IterableIterator pinLabelItr = PinLabel.get((DeviceTemplate)this.mDevT);
        if (pinLabelItr.hasNext()) {
            this.writeDbPinLabels(csvWriter, (IterableIterator<PinLabel>)pinLabelItr);
        } else {
            this.writeDefaultPinLabels(csvWriter);
        }
    }

    private void writeDbPinLabels(ACsvWriter csvWriter, IterableIterator<PinLabel> pinLabelItr) {
        for (PinLabel pinLabel : pinLabelItr) {
            this.writePinLabel(csvWriter, pinLabel);
        }
    }

    private void writePinLabel(ACsvWriter csvWriter, PinLabel pinLabel) {
        for (String attribute : this.mCsvHeader) {
            String fieldName = this.mPinLabelCsv.getFieldName(attribute);
            Object value = pinLabel.getValue(fieldName);
            String valueStr = "";
            if (value instanceof PinTemplate) {
                valueStr = ((PinTemplate)value).getName();
            } else if (value instanceof Term) {
                valueStr = ((Term)value).getName();
            } else if (value instanceof StoredPath) {
                valueStr = ((StoredPath)value).getDevicePath().toString();
            } else if (value != null) {
                valueStr = value.toString();
            }
            csvWriter.colData(valueStr);
        }
        csvWriter.endRow();
    }

    private void writeDefaultPinLabels(ACsvWriter csvWriter) {
        this.mDevT.getPinsAndDescendants(true).forEach(hierPin -> {
            PinTemplate pinT = (PinTemplate)hierPin.getDbObject();
            if (pinT.isVia()) {
                return;
            }
            DevicePath pinPath = hierPin.getPath();
            csvWriter.colData(pinPath.toString());
            csvWriter.colData(pinT.getName());
            csvWriter.endRow();
        });
    }
}

