/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.pin_label;

import com.sigrity.acl.ACsvReader;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.pin_label.PinLabelCsv;

public class PinLabelImport {
    private Db mDb;
    private DeviceTemplate mDevT;
    private PinLabelCsv mPinLabelCsv;
    private String[] mHeader;

    public PinLabelImport(DeviceTemplate devT) {
        this.mDb = devT.getDb();
        this.mDevT = devT;
        this.mPinLabelCsv = new PinLabelCsv(this.mDb);
    }

    public void importCsv(String filePath) {
        try (ACsvReader csvReader = ACsvReader.open((String)filePath);){
            csvReader.setSkipToHeader(true);
            if (!this.validateHeader(csvReader)) {
                ALog.logError((String)"Header should begin with 'Pin Path' and 'Pin'.");
                ALog.logError((String)"Unexpected header in input file %s.", (Object[])new Object[]{filePath});
                return;
            }
            this.importPinLabels(csvReader);
        }
    }

    private boolean validateHeader(ACsvReader csvReader) {
        this.mHeader = csvReader.nextRow();
        while (this.mHeader.length == 0 || this.isComment(this.mHeader) || this.mHeader[0].isEmpty()) {
            this.mHeader = csvReader.nextRow();
        }
        return this.mHeader[0].equals(PinLabelCsv.KeyHeader.PIN_PATH.getName()) && this.mHeader[1].equals(PinLabelCsv.KeyHeader.PIN.getName());
    }

    private void importPinLabels(ACsvReader csvReader) {
        for (String[] row : csvReader.getRows()) {
            if (this.isComment(row)) continue;
            this.importPinLabel(row);
        }
    }

    private boolean isComment(String[] row) {
        return row[0].startsWith("#");
    }

    private void importPinLabel(String[] row) {
        String pinPathStr = row[0];
        DevicePath pinPath = DevicePath.fromString((Db)this.mDb, (String)pinPathStr, (DeviceTemplate)this.mDevT);
        if (pinPath == null) {
            ALog.flogError((String)"Pin path '%s' not exist", (Object[])new Object[]{pinPathStr});
            return;
        }
        String pinName = row[1];
        PinTemplate pin = pinPath.getDeviceTemplate().getPinByName(pinName);
        if (pin == null) {
            ALog.flogError((String)"Pin '%s' not exist on '%s'", (Object[])new Object[]{pinName, pinPathStr});
            return;
        }
        PinLabel pinLabel = PinLabel.get((DevicePath)pinPath, (PinTemplate)pin);
        for (int i = 2; i != row.length; ++i) {
            String attributeValue = row[i];
            String attributeName = this.mHeader[i];
            String fieldName = this.mPinLabelCsv.getFieldName(attributeName);
            if (attributeValue == null || attributeValue.isEmpty()) {
                pinLabel.setValue(fieldName, null);
                continue;
            }
            if (fieldName.equals("term")) {
                Term term = this.mDevT.getTerm(attributeValue);
                if (term == null) {
                    ALog.flogError((String)"Term '%s' is not exist.", (Object[])new Object[]{attributeValue});
                    continue;
                }
                if (term.isConnect(pinPath, pin)) {
                    pinLabel.setTerm(term);
                    continue;
                }
                ALog.flogError((String)"Invalid term '%s' for pin '%s/%s'. Term must be connected to the pin in the netlist.", (Object[])new Object[]{attributeValue, pinPath, pin.getName()});
                continue;
            }
            pinLabel.setValue(fieldName, (Object)attributeValue);
        }
    }
}

