/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.pin_label.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.jfxui.AJFXAlerts;
import java.awt.Window;

public class PinLabelAttributeValidator {
    private static final String ATTRIBUTE_NAME_RULE_STR = "An attribute name should be:\n\t- Not empty.\n\t- First character is a letter, the underscore \"_\", or colon \":\".\n\t- Additional characters, if desired, can be: a letter,\n\t  a digit, underscore, colon, period, or dash.";
    private static final String DIALOG_TITLE = "Invalid Name";

    public static boolean validate(Window owner, Db db, String newName) {
        if (PinLabelAttributeValidator.hasAttribute(db, newName)) {
            PinLabelAttributeValidator.showNameExistAlert(owner, newName);
            return false;
        }
        if (!DbFieldDef.isValidFieldName((String)newName)) {
            PinLabelAttributeValidator.showInvalidFieldNameAlert(owner, newName);
            return false;
        }
        return true;
    }

    private static boolean hasAttribute(Db db, String newName) {
        DbClass pinLabelDbClass = db.getDbClass(PinLabel.class);
        if (pinLabelDbClass == null) {
            return false;
        }
        return pinLabelDbClass.getField(newName) != null;
    }

    public static void showNameExistAlert(Window owner, String newName) {
        String headerTxt = PinLabelAttributeValidator.getHeaderText(newName);
        String contactTxt = String.format("'%s' attribute name already exist", newName);
        AJFXAlerts.showErrorAlert((Window)owner, (String)DIALOG_TITLE, (String)headerTxt, (String)contactTxt);
    }

    public static void showInvalidFieldNameAlert(Window owner, String name) {
        String headerTxt = PinLabelAttributeValidator.getHeaderText(name);
        AJFXAlerts.showErrorAlert((Window)owner, (String)DIALOG_TITLE, (String)headerTxt, (String)ATTRIBUTE_NAME_RULE_STR);
    }

    private static String getHeaderText(String newName) {
        return String.format("Invalid attribute name '%s'", newName);
    }

    private PinLabelAttributeValidator() {
    }
}

