/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.public_source.canvas_info;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.canvas_modes.InspectMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.geom.Line2D;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CanvasInfoUtil {
    protected static final String XTAG_CONFIG = "CanvasInfoUtil";
    protected static final String XTAG_GETTEXT = "GetText";
    protected static ScriptedGetTextHelper sScriptedGetText = null;
    protected static Map<Class<? extends DbObject>, Integer> sObjTypePriority;

    private CanvasInfoUtil() {
    }

    public static void clearScriptedText() {
        sScriptedGetText = null;
    }

    public static void loadConfig() {
        File file = Settings.findConfigFile((String)"DesignCanvasInfoDisplay.xml");
        if (file != null) {
            Element elConfig;
            Element doc = AXDomUtil.getDocumentElement((File)file);
            Element element = elConfig = doc == null ? null : AXDomUtil.getNamedElement((Element)doc, (String)XTAG_CONFIG);
            if (elConfig != null) {
                Config config = new Config();
                config.load(elConfig);
                String scriptText = config.getGetTextScript();
                if (scriptText != null && scriptText.length() > 0) {
                    sScriptedGetText = new ScriptedGetTextHelper(scriptText);
                }
            }
        }
    }

    public static HierInst<DbObject> getItemAt(Design design, APoint2D pt) {
        return CanvasInfoUtil.getItemAt(design, pt, null);
    }

    public static HierInst<DbObject> getItemAt(Design design, APoint2D pt, ViewColorizer colorizer) {
        HierInst curBestItem = null;
        int curBestPriority = Integer.MIN_VALUE;
        int curBestDepth = -1;
        double curBestArea = Double.MAX_VALUE;
        for (HierInst hdbo : design.getObjectsAt(pt)) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            if (colorizer != null && !InspectMode.isVisible((HierInst<DbObject>)hdbo, colorizer)) continue;
            int depth = DevicePath.getDepth((DevicePath)hdbo.getPath());
            if (curBestItem != null && depth < curBestDepth) continue;
            DbObject dbo = hdbo.getDbObject();
            int priority = CanvasInfoUtil.getPriority(dbo);
            if (curBestItem != null && priority < curBestPriority) continue;
            double area = CanvasInfoUtil.getArea(hdbo.getDbObject());
            if (curBestItem != null && (area < 0.0 || area > curBestArea)) continue;
            curBestItem = hdbo;
            curBestPriority = priority;
            curBestDepth = depth;
            curBestArea = area;
        }
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        Db db = design.getDb();
        for (Connection connection : db.getObjects(Connection.class)) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            ALine line = connection.getLine();
            int priority = CanvasInfoUtil.getPriority((DbObject)connection);
            Line2D screenLine = v2.getCanvas().getXForm().getScreenLine(line.distanceToPoint(pt));
            double dist = Math.hypot(screenLine.getX1() - screenLine.getX2(), screenLine.getY1() - screenLine.getY2());
            if (!(dist <= 15.0) || curBestItem != null && priority < curBestPriority) continue;
            curBestItem = HierInst.create((DevicePath)Design.getDesignPath((Db)design.getDb()), (DbObject)connection);
            curBestPriority = priority;
            break;
        }
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        Interface intf = Interface.find((Db)design.getDb(), (APoint2D)pt, (boolean)false);
        if (intf != null && CanvasInfoUtil.getPriority((DbObject)intf) > curBestPriority) {
            curBestItem = new HierInst(new DevicePath((DeviceTemplate)design), (DbObject)intf);
        }
        return curBestItem;
    }

    public static String getText(DesignView2D _view, DevicePath _path, DbObject _dbo) {
        DbClass dbc;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (sScriptedGetText != null) {
            return sScriptedGetText.getTextForItem(_view, _path, _dbo);
        }
        if (_dbo instanceof PortTemplate) {
            Object parentNetInfo;
            PortTemplate portT = (PortTemplate)_dbo;
            PinTemplate pinT = portT.getPinTemplate();
            Net net = NetMap.getSubstrateNet((Net)pinT.getNet(), (DevicePath)_path);
            Net parentSubstNet = null;
            String parentSubstName = null;
            if (net != null && _path != null && !_path.isEmpty()) {
                DevicePath substPath = _path.pathTo(net.getDeviceTemplate());
                Net substParentNet = null;
                if (substPath != null && substPath.size() > 0) {
                    substParentNet = NetMap.getParentNet((Device)substPath.getLast(), (Net)net);
                }
                if (substParentNet != null) {
                    DevicePath substParentPath = substPath.getParent();
                    parentSubstNet = NetMap.getSubstrateNet((Net)substParentNet, (DevicePath)substParentPath);
                    DevicePath substParentSubstPath = null;
                    if (parentSubstNet != null && (substParentSubstPath = substParentPath.pathTo(parentSubstNet.getDeviceTemplate())) != null && !substParentSubstPath.isEmpty()) {
                        parentSubstName = substParentSubstPath.getDevice().getName();
                    }
                }
            }
            Object object = parentNetInfo = parentSubstNet == null ? null : String.format(" &rarr; Net <span class='object'>%s</span>", AUtil.escapeHtml((String)parentSubstNet.getName()));
            if (parentNetInfo != null && parentSubstName != null) {
                parentNetInfo = (String)parentNetInfo + String.format(" on <span class='object'>%s</span>", parentSubstName);
            }
            String netInfo = String.format("(<span class='object'>%s</span>) ", net == null ? "&lt;Unconnected&gt;" : AUtil.escapeHtml((String)net.getName()));
            return String.format("<div class='main'><span class='type'>Pin</span> <span class='object'>%s%s</span> %son <span class='object'>%s</span><div>%s</div></div>", AUtil.escapeHtml((String)pinT.getName()), pinT.hasMultiplePorts() ? String.format(" (port %d)", portT.getPortNum()) : "", netInfo, _path == null || _path.size() == 0 ? "" : AUtil.escapeHtml((String)_path.getLast().getName()), parentNetInfo == null ? "" : parentNetInfo);
        }
        if (_dbo instanceof Device) {
            return String.format("<div class='main'><span class='object'>%s</span></div>", _path == null || _path.size() == 0 ? "" : AUtil.escapeHtml((String)_path.getLast().getName()));
        }
        if (_dbo instanceof Bundle) {
            Bundle b = (Bundle)_dbo;
            return String.format("<div class='main'><span class='object'>%s</span></div>", AUtil.escapeHtml((String)b.getName()) + "(" + b.getDefinedArity() + ")");
        }
        if (_dbo instanceof Interface) {
            Interface intf = (Interface)_dbo;
            return String.format("<div class='main'><span class='object'>%s</span></div>", AUtil.escapeHtml((String)intf.toStringPath()));
        }
        if (_dbo instanceof Metal) {
            Metal metal = (Metal)_dbo;
            return String.format("<div class='main'><span class='object'>Metal of net %s</span></div>", metal.getNet() == null ? "&lt;Unconnected&gt;" : AUtil.escapeHtml((String)metal.getNet().getName()));
        }
        if (_dbo instanceof Wire) {
            Wire wire = (Wire)_dbo;
            Layer layer = wire.getLayer();
            Net net = NetMap.getSubstrateNet((Net)wire.getNet(), (DevicePath)_path);
            return String.format("<div class='main'><span class='type'>Wire</span> (<span class='object'>%s</span>) on layer <span class='object'>%s</span> of device <span class='object'>%s</span></div>", net == null ? "&lt;Unconnected&gt;" : AUtil.escapeHtml((String)net.getName()), layer == null ? "&lt;None&gt;" : AUtil.escapeHtml((String)layer.getName()), _path == null || _path.size() == 0 ? "&lt;None&gt;" : AUtil.escapeHtml((String)_path.getLast().getName()));
        }
        if (_dbo instanceof Connection) {
            Connection connection = (Connection)_dbo;
            return String.format("<div class='main'><span class='type'>Connection</span> on net <span class='object'>%s</span></div>", AUtil.escapeHtml((String)connection.getNet().getName()));
        }
        if (_dbo != null && (dbc = _dbo.getDbClass()) != null) {
            return AUtil.escapeHtml((String)dbc.getName());
        }
        return null;
    }

    public static int getPriority(DbObject dbo) {
        Class<?> cls = dbo.getClass();
        Integer priority = sObjTypePriority.get(cls);
        if (priority == null) {
            priority = 10;
        }
        return priority;
    }

    public static double getArea(DbObject dbo) {
        return Selectors.getArea((DbObject)dbo);
    }

    static {
        CanvasInfoUtil.loadConfig();
        sObjTypePriority = new HashMap<Class<? extends DbObject>, Integer>();
        sObjTypePriority.put(Connection.class, 110);
        sObjTypePriority.put(LayerShape.class, 100);
        sObjTypePriority.put(PinInstance.class, 90);
        sObjTypePriority.put(PortTemplate.class, 90);
        sObjTypePriority.put(Interface.class, 87);
        sObjTypePriority.put(Bundle.class, 82);
        sObjTypePriority.put(Wire.class, 80);
        sObjTypePriority.put(Metal.class, 70);
        sObjTypePriority.put(Obstacle.class, 60);
        sObjTypePriority.put(Device.class, 50);
    }

    public static class Config {
        protected String mGetTextScript = null;

        public String getGetTextScript() {
            return this.mGetTextScript;
        }

        public void setGetTextScript(String getTextScript) {
            this.mGetTextScript = getTextScript;
        }

        public void load(Element elCfg) {
            for (Element elGetText : AXDomUtil.getChildElems((Node)elCfg, (String)CanvasInfoUtil.XTAG_GETTEXT)) {
                if (this.mGetTextScript == null) {
                    this.mGetTextScript = elGetText.getTextContent();
                    continue;
                }
                this.mGetTextScript = this.mGetTextScript + elGetText.getTextContent();
            }
        }
    }

    public static class ScriptedGetTextHelper {
        protected String mGetTextScript = null;
        protected Interpreter mInterpreter = null;
        protected boolean mFuncDefnErrorDisplayed = false;
        protected long mFuncEvalErrorLastDisplayed = 0L;
        protected long mFuncEvalRedisplayDelay = 5000L;

        public ScriptedGetTextHelper(String getTextScript) {
            this.mGetTextScript = getTextScript;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getTextForItem(DesignView2D view, DevicePath path, DbObject dbo) {
            String func;
            if (this.mGetTextScript == null) {
                return "[No GetText Script]";
            }
            if (this.mInterpreter == null) {
                if (this.mFuncDefnErrorDisplayed) {
                    return "[Invalid GetText script]";
                }
                func = String.format("_getTextForItem(view, path, dbo) { %s }", this.mGetTextScript);
                this.mInterpreter = Cp.getCp().createChildInterpreter();
                try {
                    this.mInterpreter.eval(func);
                }
                catch (EvalError e) {
                    if (!this.mFuncDefnErrorDisplayed) {
                        ALog.logError((Throwable)e, (String)"Error evaluating GetText script for DesignCanvasDisplayInfo:\n%s", (Object[])new Object[]{this.mGetTextScript});
                        this.mFuncDefnErrorDisplayed = true;
                    }
                    this.mInterpreter = null;
                    return "[Invalid GetText script]";
                }
            }
            try {
                this.mInterpreter.set("_view", (Object)view);
                this.mInterpreter.set("_path", (Object)path);
                this.mInterpreter.set("_dbo", (Object)dbo);
                func = (String)this.mInterpreter.eval("_getTextForItem(_view, _path, _dbo);");
                return func;
            }
            catch (EvalError e) {
                if (System.currentTimeMillis() > this.mFuncEvalErrorLastDisplayed + this.mFuncEvalRedisplayDelay) {
                    ALog.logError((Throwable)e, (String)"Error evaluating GetText script for DesignCanvasDisplayInfo:\n%s", (Object[])new Object[]{this.mGetTextScript});
                    this.mFuncEvalErrorLastDisplayed = System.currentTimeMillis();
                }
                String string = null;
                return string;
            }
            finally {
                block18: {
                    try {
                        this.mInterpreter.unset("_view");
                        this.mInterpreter.unset("_path");
                        this.mInterpreter.unset("_dbo");
                    }
                    catch (Exception e) {
                        if ($assertionsDisabled) break block18;
                        throw new AssertionError();
                    }
                }
            }
        }
    }
}

