/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.public_source.canvas_info;

import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.public_source.canvas_info.CanvasInfoUtil;
import com.sigrity.orbit.ui.DesignCanvasInfoDisplay;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.w3c.dom.Element;

public class OverlayCanvasInfoDisplay
implements DesignCanvasInfoDisplay.Factory,
DesignCanvasInfoDisplay.XmlConfig {
    protected MyConfig mConfig = new MyConfig();

    @Override
    public DesignCanvasInfoDisplay.Implementation install(DesignView2D view) {
        return new CanvasOverlayImplmentation(view, this.mConfig);
    }

    @Override
    public String getName() {
        return "Canvas Overlay";
    }

    @Override
    public void loadConfig(Element elCfg) {
        this.mConfig.load(elCfg);
    }

    public class CanvasOverlayImplmentation
    extends DesignCanvasInfoDisplay.AbstractImplementation {
        protected MyConfig mConfig;
        protected JPanel mOverlay;
        protected JTextPane mTxtPane;
        protected String mText;
        protected Object mTextUpdateLock;

        public CanvasOverlayImplmentation(DesignView2D view, MyConfig config) {
            super(view);
            this.mConfig = new MyConfig();
            this.mTextUpdateLock = new Object();
            if (config != null) {
                this.mConfig = config;
            }
            this.mOverlay = new JPanel();
            this.mOverlay.setOpaque(false);
            this.mOverlay.setDoubleBuffered(true);
            this.mTxtPane = new JTextPane(){

                @Override
                protected void paintComponent(Graphics g) {
                    Color bg = this.getBackground();
                    if (bg != null) {
                        Rectangle bounds = this.getBounds();
                        Graphics2D g2d = (Graphics2D)g;
                        Color oldColor = g2d.getColor();
                        Object oldAntiAlias = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2d.setColor(bg);
                        g2d.fillRoundRect(0, 0, bounds.width, bounds.height, 8, 8);
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAlias);
                        g2d.setColor(oldColor);
                    }
                    super.paintComponent(g);
                }
            };
            HTMLEditorKit ek = new HTMLEditorKit();
            this.mTxtPane.setEditorKit(ek);
            this.mTxtPane.setEditable(false);
            Color bgColor = this.mConfig.getBackgroundColor();
            this.mTxtPane.setBackground(bgColor);
            this.mTxtPane.setOpaque(false);
            this.mTxtPane.setSelectedTextColor(Color.black);
            this.mTxtPane.setSelectionColor(Color.lightGray);
            this.mTxtPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        ABrowserControl.displayURL((String)e.getDescription());
                    }
                }
            });
            GridBagManager l = GridBagManager.layout((Container)this.mOverlay);
            l.addFillY();
            l.addFillX();
            l.add((Component)this.mTxtPane, (GridBagConstraints)GridBagManager.RIGHT);
            this.mTxtPane.setVisible(false);
            this.mView.addOverlay(this.mOverlay);
        }

        @Override
        public DesignCanvasInfoDisplay.Factory getFactory() {
            return OverlayCanvasInfoDisplay.this;
        }

        @Override
        public void displayItemInfo(String s) {
            if (AUtil.equals((Object)s, (Object)this.mText)) {
                return;
            }
            this.mText = s;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String css = CanvasOverlayImplmentation.this.mConfig.getCssStyle();
                    css = css == null ? "" : String.format("<style TYPE=\"text/css\">%s</style>", css);
                    String text = CanvasOverlayImplmentation.this.mText == null || CanvasOverlayImplmentation.this.mText.length() == 0 ? null : String.format("%s%s", css, CanvasOverlayImplmentation.this.mText);
                    CanvasOverlayImplmentation.this.mTxtPane.setText(text);
                    CanvasOverlayImplmentation.this.mTxtPane.setVisible(text != null);
                    CanvasOverlayImplmentation.this.mOverlay.validate();
                }
            });
        }

        @Override
        public void uninstall() {
            if (this.mView != null) {
                this.mView.removeOverlay(this.mOverlay);
                this.mView.repaint();
            }
            super.uninstall();
        }

        @Override
        protected HierInst<DbObject> getItemAt(Design design, APoint2D worldPt) {
            return CanvasInfoUtil.getItemAt(design, worldPt, this.mView.getColorizer());
        }

        @Override
        protected String getTextForItem(HierInst<DbObject> hdbo) {
            return CanvasInfoUtil.getText(this.mView, hdbo.getPath(), hdbo.getDbObject());
        }
    }

    public static class MyConfig
    extends CanvasInfoUtil.Config {
        protected Color mBackgroundColor = null;
        protected String mCssStyle = null;

        public Color getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public void setBackgroundColor(Color color) {
            this.mBackgroundColor = color;
        }

        public String getCssStyle() {
            return this.mCssStyle;
        }

        public void setCssStyle(String cssStyle) {
            this.mCssStyle = cssStyle;
        }

        @Override
        public void load(Element elCfg) {
            Element elBackground;
            super.load(elCfg);
            Element elStyle = AXDomUtil.getNamedElement((Element)elCfg, (String)"Style");
            if (elStyle != null) {
                this.setCssStyle(elStyle.getTextContent());
            }
            if ((elBackground = AXDomUtil.getNamedElement((Element)elCfg, (String)"Background")) != null) {
                String strColor = elBackground.getAttribute("color");
                String strOpacity = elBackground.getAttribute("opacity");
                if (strColor != null) {
                    Integer color = null;
                    try {
                        color = Integer.decode(strColor);
                    }
                    catch (NumberFormatException nfe) {
                        ALog.logWarn((String)"The string '%s' could not be parsed as an integer to set the background color for a CanvasOverlay while parsing the config file.", (Object[])new Object[]{strColor});
                    }
                    Float opacity = null;
                    if (color != Integer.MIN_VALUE && strOpacity != null) {
                        try {
                            opacity = Float.valueOf(Float.parseFloat(strOpacity));
                            if (opacity.floatValue() >= 0.0f && opacity.floatValue() <= 1.0f) {
                                color = color + ((int)(255.0 * (double)opacity.floatValue()) << 24);
                            } else {
                                ALog.logWarn((String)"The background opacity '%s' for a CanvasOverlay in the config file is invalid, it must be in the range 0.0 to 1.0.", (Object[])new Object[]{strOpacity});
                                opacity = null;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            ALog.logWarn((String)"The string '%s' could not be parsed as a floating point number to set the background opacity for a CanvasOverlay while parsing the config file.", (Object[])new Object[]{strOpacity});
                        }
                    }
                    if (color != null) {
                        this.setBackgroundColor(new Color(color, opacity != null));
                    }
                }
            }
        }
    }
}

