/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.public_source.canvas_info;

import bsh.Interpreter;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.public_source.canvas_info.CanvasInfoUtil;
import com.sigrity.orbit.ui.DesignCanvasInfoDisplay;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ToolTipManager;

public class ToolTipCanvasInfoDisplay
implements DesignCanvasInfoDisplay.Factory {
    @Override
    public DesignCanvasInfoDisplay.Implementation install(DesignView2D view) {
        return new TTImplementation(view);
    }

    @Override
    public String getName() {
        return "Tooltip View";
    }

    public class TTImplementation
    extends DesignCanvasInfoDisplay.AbstractImplementation {
        protected String mGetTextScript;
        protected String mDisplayedText;
        protected Interpreter mInterpreter;

        public TTImplementation(DesignView2D view) {
            super(view);
            this.mGetTextScript = null;
            this.mDisplayedText = null;
            this.mInterpreter = null;
        }

        @Override
        public DesignCanvasInfoDisplay.Factory getFactory() {
            return ToolTipCanvasInfoDisplay.this;
        }

        @Override
        public void uninstall() {
            if (this.mView != null && this.mView.getCanvas() != null) {
                this.mView.getCanvas().setToolTipText(null);
            }
            super.uninstall();
        }

        @Override
        public HierInst<DbObject> getItemAt(Design design, APoint2D pt) {
            return CanvasInfoUtil.getItemAt(design, pt, this.mView.getColorizer());
        }

        @Override
        public String getTextForItem(HierInst<DbObject> hdbo) {
            if (hdbo == null) {
                return null;
            }
            DbObject dbo = hdbo.getDbObject();
            if (dbo == null) {
                return null;
            }
            DevicePath path = hdbo.getPath();
            return CanvasInfoUtil.getText(this.mView, path, dbo);
        }

        @Override
        protected void displayItemInfo(String s) {
            if (AUtil.equals((Object)s, (Object)this.mDisplayedText)) {
                return;
            }
            this.mDisplayedText = s;
            Runnable r = () -> {
                DesignCanvas2D canvas;
                DesignCanvas2D designCanvas2D = canvas = this.mView == null ? null : this.mView.getCanvas();
                if (canvas == null) {
                    return;
                }
                String text = this.mDisplayedText == null || this.mDisplayedText.length() == 0 ? null : String.format("<html><body>%s</body></html>", this.mDisplayedText);
                canvas.setToolTipText(text);
                Point loc = canvas.getMouseLoc();
                if (loc == null) {
                    return;
                }
                MouseEvent me = new MouseEvent(canvas, 503, System.currentTimeMillis(), 0, loc.x, loc.y, 0, false);
                ToolTipManager.sharedInstance().mouseMoved(me);
            };
            if (EventQueue.isDispatchThread()) {
                r.run();
            } else {
                EventQueue.invokeLater(r);
            }
        }
    }
}

