/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.public_source.examples;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public class AddContextMenu {
    public static void install() {
        OrbitGuiWS ws = OrbitIO.getOrbitIO().getWorkspace();
        ObjectActionRegistry oar = ws.getObjectActionRegistry();
        oar.registerActionFactory(HierInst.class, new MyHierInstActionFactory());
        ALog.logInfo((String)"MyHierInstActionFactory registered.");
    }

    public static class MyDeviceAction
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public MyDeviceAction(DevicePath devicePath) {
            super("My Device Action", (Icon)new AColorIcon(16, 16, Color.ORANGE));
            this.mDevicePath = devicePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ALog.logInfo((String)"MyDeviceAction performed on: %s", (Object[])new Object[]{this.mDevicePath});
        }
    }

    public static class MyHierInstActionFactory
    implements ObjectActionRegistry.ActionFactory<HierInst<?>> {
        @Override
        public Iterator<Action> getActions(HierInst<?> hierInst, Set<ObjectActionRegistry.ActionConstraint> constraints) {
            LinkedList<MyDeviceAction> actions = new LinkedList<MyDeviceAction>();
            DbObject dbo = hierInst.getDbObject();
            if (dbo instanceof Device) {
                actions.add(new MyDeviceAction(hierInst.getPath()));
            }
            return actions.iterator();
        }
    }
}

