/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.public_source.examples;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class DatabaseAccessExamples {
    public static void logDevices(Db db) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            ALog.logError((String)"No database");
            return;
        }
        ALog.logInfo((String)"Devices:");
        for (Device device : db.getObjects(Device.class)) {
            ALog.logInfo((String)"  Device: %s", (Object[])new Object[]{device.getName()});
        }
    }

    public static void logDevicesSorted(Db db) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            ALog.logError((String)"No database");
            return;
        }
        Comparator<Device> deviceNameCompare = new Comparator<Device>(){

            @Override
            public int compare(Device a, Device b) {
                return a.getName().compareTo(b.getName());
            }
        };
        LinkedList devices = AUtil.linkedList((Iterator)db.getObjects(Device.class));
        Collections.sort(devices, deviceNameCompare);
        ALog.logInfo((String)"Sorted Devices:");
        for (Device device : devices) {
            ALog.logInfo((String)"  Device: %s", (Object[])new Object[]{device.getName()});
        }
    }

    public static long logAllDeviceBounds(Db db) {
        long result = 0L;
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            ALog.logError((String)"No database");
            return result;
        }
        Design design = Design.getDesign((Db)db);
        if (design == null) {
            ALog.logError((String)"No design found in the database.");
            return result;
        }
        for (DevicePath devicePath : design.getDescendantDevices()) {
            ARect designRelativeBounds = devicePath.getBB();
            Device device = devicePath.getLast();
            ARect parentRelativeBounds = device.getBB();
            ALog.logInfo((String)"DevicePath: %s", (Object[])new Object[]{devicePath.toString()});
            ALog.logInfo((String)"  Parent-relative bounds: %s", (Object[])new Object[]{parentRelativeBounds.toString()});
            ALog.logInfo((String)"  Design-relative bounds: %s", (Object[])new Object[]{designRelativeBounds.toString()});
        }
        return result;
    }

    public static void logSelectedObjects(Db db) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            ALog.logError((String)"No database");
            return;
        }
        Selection selection = Selection.getCurrentSelectionForDb((Db)db);
        if (selection == null) {
            ALog.logError((String)"Unable to get primary Selection for the database.");
            return;
        }
        long selObjCount = 0L;
        for (DbClass dbClass : selection.getClasses()) {
            ALog.logInfo((String)"Selected items of class '%s':", (Object[])new Object[]{dbClass.getName()});
            for (DbObject dbObject : selection.get(dbClass)) {
                ++selObjCount;
                ALog.logInfo((String)"  %s", (Object[])new Object[]{dbObject.toString()});
                for (DevicePath devicePath : selection.getSelectedPaths(dbObject)) {
                    ALog.logInfo((String)"    In path: %s", (Object[])new Object[]{devicePath.toString()});
                }
            }
        }
        if (selObjCount == 0L) {
            ALog.logInfo((String)"No objects selected.");
        }
    }

    public static long selectPinsByNameRegex(Db db, String regex) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            ALog.logError((String)"No database");
            return 0L;
        }
        Selection selection = Selection.getCurrentSelectionForDb((Db)db);
        if (selection == null) {
            ALog.logError((String)"Unable to get primary Selection for the database.");
            return 0L;
        }
        Pattern pattern = Pattern.compile(regex);
        long selPins = 0L;
        for (PinInstance pinInst : db.getObjects(PinInstance.class)) {
            String name = pinInst.getName();
            if (!pattern.matcher(name).matches()) continue;
            selection.add((DbObject)pinInst);
            ALog.logInfo((String)"Selected pin '%s' on device '%s'.", (Object[])new Object[]{name, pinInst.getDevice().getName()});
            ++selPins;
        }
        ALog.logInfo((String)"Selected %d pin instances.", (Object[])new Object[]{selPins});
        return selPins;
    }

    public static void selectedDevicesThatHaveLayer(String pathString, String layerName) {
        Db db = OrbitIO.getCurDb();
        Selection selection = Selection.getCurrentSelectionForDb((Db)db);
        if (selection == null) {
            ALog.logError((String)"Unable to get primary Selection for the database.");
            return;
        }
        HashSet<DeviceTemplate> processedTemplates = new HashSet<DeviceTemplate>();
        DevicePath path = DevicePath.fromString((Db)db, (String)pathString);
        for (DevicePath dp : path.getDescendants()) {
            DeviceTemplate dt = dp.getLast().getTemplate();
            if (processedTemplates.contains(dt)) continue;
            processedTemplates.add(dt);
            for (PinTemplate pinTemplate : dt.getPins()) {
                block2: for (PortTemplate portTemplate : pinTemplate.getPortTemplates()) {
                    PadTemplate padTemplate = portTemplate.getPadTemplate();
                    for (LayerShape layerShape : padTemplate.getLayerShapes()) {
                        String thisLayerName = layerShape.getLayer().getName();
                        if (!thisLayerName.equals(layerName)) continue;
                        selection.add(new HierInst(dp.getParent(), (DbObject)dp.getLast()));
                        continue block2;
                    }
                }
            }
        }
    }

    public static boolean setField(Db db, String devicePath, String fieldName, Object fieldValue) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            ALog.logError((String)"No database");
            return false;
        }
        DevicePath devPath = DevicePath.fromString((Db)db, (String)devicePath);
        if (devPath == null) {
            ALog.logError((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
            return false;
        }
        Device device = devPath.getLast();
        return device.setValue(fieldName, fieldValue);
    }

    public static void logFieldValue(Db db, String devicePath, String fieldName) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            ALog.logError((String)"No database");
            return;
        }
        DevicePath devPath = DevicePath.fromString((Db)db, (String)devicePath);
        if (devPath == null) {
            ALog.logError((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
            return;
        }
        Device device = devPath.getLast();
        Object val = device.getValue(fieldName);
        ALog.logInfo((String)"Value: %s", (Object[])new Object[]{val});
    }

    public static void logFieldInfo(DbObject dbObject, String fieldName) {
        DbClass dbClass = dbObject.getDbClass();
        DbFieldDef dbFieldDef = dbClass.getField(fieldName);
        ALog.logInfo((String)"DbClass: %s", (Object[])new Object[]{dbClass.getName()});
        if (dbFieldDef == null) {
            ALog.logInfo((String)"  No such Field '%s'.", (Object[])new Object[]{fieldName});
            return;
        }
        String fieldType = dbFieldDef.getFieldClass().getName();
        ALog.logInfo((String)"  DbField '%s' is of type '%s'", (Object[])new Object[]{dbFieldDef.getName(), fieldType});
        ALog.logInfo((String)"  It is a %s field", (Object[])new Object[]{dbFieldDef.getIsHard() ? "hard" : "soft"});
        ALog.logInfo((String)"  Persists to stored database? %b", (Object[])new Object[]{dbFieldDef.getPersist()});
        ALog.logInfo((String)"  Is a key field? %b", (Object[])new Object[]{dbFieldDef.getIsKey()});
        ALog.logInfo((String)"  Type is determined at runtime? %b", (Object[])new Object[]{dbFieldDef.getIsRuntimeType()});
        ALog.logInfo((String)"  Defines an DbRelation? %b", (Object[])new Object[]{dbFieldDef.getRelation()});
        Object value = dbFieldDef.getValue(dbObject);
        ALog.logInfo((String)"  The value of the field for the specified object is: %s", (Object[])new Object[]{value});
    }
}

