/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.public_source.examples;

import com.sigrity.acl.APair;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class DevicePairConnection {
    public static boolean areConnected(DevicePath a, DevicePath b) {
        LinkedList<PortPair> result = DevicePairConnection.getPortPairs(a, b, true);
        return !result.isEmpty();
    }

    public static LinkedList<PortPair> getPortPairs(DevicePath a, DevicePath b) {
        return DevicePairConnection.getPortPairs(a, b, false);
    }

    private static LinkedList<PortPair> getPortPairs(DevicePath a, DevicePath b, boolean justFirst) {
        Net topNet;
        LinkedList<PortPair> result = new LinkedList<PortPair>();
        HashMap<Net, HierPort> netToHierPort = new HashMap<Net, HierPort>();
        HashSet<Net> topNets = new HashSet<Net>();
        for (DevicePath from : a.getDescendants()) {
            for (PinTemplate pinTemplateA : from.getLast().getTemplate().getPins()) {
                topNet = NetMap.getTopmostNet((Net)pinTemplateA.getNet(), (DevicePath)a);
                if (topNets.contains(topNet)) continue;
                topNets.add(topNet);
                PortTemplate portTemplate = pinTemplateA.getFirstPortTemplate();
                netToHierPort.put(topNet, new HierPort(a, portTemplate));
            }
        }
        block2: for (DevicePath to : b.getDescendants()) {
            for (PinTemplate pinTemplateB : to.getLast().getTemplate().getPins()) {
                topNet = NetMap.getTopmostNet((Net)pinTemplateB.getNet(), (DevicePath)b);
                if (!topNets.contains(topNet)) continue;
                topNets.remove(topNet);
                HierPort hpa = (HierPort)netToHierPort.get(topNet);
                HierPort hpb = new HierPort(b, pinTemplateB.getFirstPortTemplate());
                PortPair portPair = new PortPair(hpa, hpb);
                result.add(portPair);
                if (!justFirst) continue;
                continue block2;
            }
        }
        return result;
    }

    public static int crossings(DevicePath a, DevicePath b) {
        int cross = 0;
        LinkedList<PortPair> result = DevicePairConnection.getPortPairs(a, b, false);
        ArrayList<PortPair> list = new ArrayList<PortPair>();
        list.addAll(result);
        for (int i = 0; i < list.size(); ++i) {
            ALine iLine = new ALine(((HierPort)((PortPair)((Object)list.get((int)i))).first).getWorldLoc(), ((HierPort)((PortPair)((Object)list.get((int)i))).second).getWorldLoc());
            for (int j = i + 1; j < list.size(); ++j) {
                ALine jLine = new ALine(((HierPort)((PortPair)((Object)list.get((int)j))).first).getWorldLoc(), ((HierPort)((PortPair)((Object)list.get((int)j))).second).getWorldLoc());
                if (!iLine.intersects((AGeom)jLine)) continue;
                ++cross;
            }
        }
        return cross;
    }

    static class PortPair
    extends APair<HierPort, HierPort> {
        public PortPair(HierPort first, HierPort second) {
            super((Object)first, (Object)second);
        }
    }
}

