/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.public_source.examples;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.WeightedGoalFunction;
import com.sigrity.orbit.automation.WeightedGoalRegistry;
import com.sigrity.orbit.automation.connOpt.AGeneticConnectionOptimizer;
import java.awt.Color;
import java.util.HashSet;

public class GroundNearDiffPairGoal
extends WeightedGoalFunction {
    private static final String groundNetName = "DiffPairGround";

    @Override
    public void init(AGeneticConnectionOptimizer.ConnectedChromosome c) {
        HashSet<Personality> personalitySet = new HashSet<Personality>();
        HashSet<APoint2D> groundPoints = new HashSet<APoint2D>();
        HashSet<APoint2D> diffPairPoints = new HashSet<APoint2D>();
        for (int i = 0; i < c.size(); ++i) {
            AGeneticConnectionOptimizer.Connected cI = (AGeneticConnectionOptimizer.Connected)((Object)c.get(i));
            if (cI.first != null && cI.second != null) {
                Boolean matchLength;
                DevicePath stopPathA = cI.getFrom().getDpp().getPath().pathToSubstrate();
                Net netA = NetMap.getTopmostNet((Net)cI.getFrom().getDpp().getNet(), (DevicePath)stopPathA);
                Personality p = netA.getPersonality();
                if (p == null || (matchLength = (Boolean)Constraint.getValue((Db)p.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH)) == null || !matchLength.booleanValue()) continue;
                personalitySet.add(p);
                diffPairPoints.add(((AGeneticConnectionOptimizer.DPPL)cI.second).getP());
                continue;
            }
            if (cI.first != null || cI.second == null) continue;
            groundPoints.add(((AGeneticConnectionOptimizer.DPPL)cI.second).getP());
        }
        ALog.logInfo((String)("There are " + personalitySet.size() + " diff pair sets and " + groundPoints.size() + " available pins for ground"));
    }

    @Override
    public String name() {
        return "GroundNearDiff";
    }

    @Override
    public String toolTip() {
        return "Allocates Grounds Near Diff Pairs";
    }

    @Override
    public Color color() {
        return Color.black;
    }

    @Override
    public double fitness(AGeneticConnectionOptimizer.ConnectedChromosome c) {
        HashSet<Personality> personalitySet = new HashSet<Personality>();
        HashSet<CostedPoint> groundPoints = new HashSet<CostedPoint>();
        HashSet<APoint2D> diffPairPoints = new HashSet<APoint2D>();
        for (int i = 0; i < c.size(); ++i) {
            AGeneticConnectionOptimizer.Connected cI = (AGeneticConnectionOptimizer.Connected)((Object)c.get(i));
            if (cI.first != null && cI.second != null) {
                Boolean matchLength;
                DevicePath stopPathA = cI.getFrom().getDpp().getPath().pathToSubstrate();
                Net netA = NetMap.getTopmostNet((Net)cI.getFrom().getDpp().getNet(), (DevicePath)stopPathA);
                Personality p = netA.getPersonality();
                if (p == null || (matchLength = (Boolean)Constraint.getValue((Db)p.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH)) == null || !matchLength.booleanValue()) continue;
                personalitySet.add(p);
                diffPairPoints.add(((AGeneticConnectionOptimizer.DPPL)cI.second).getP());
                continue;
            }
            if (cI.first != null || cI.second == null) continue;
            groundPoints.add(new CostedPoint(1.0, ((AGeneticConnectionOptimizer.DPPL)cI.second).getP()));
        }
        double fitness = 0.0;
        for (APoint2D dp : diffPairPoints) {
            CostedPoint cp = this.nearestPoint(dp, groundPoints);
            if (cp == null) continue;
            double ds = cp.distance(dp);
            cp.incrCost(2.0);
            fitness += ds;
        }
        return fitness;
    }

    protected CostedPoint nearestPoint(APoint2D p, HashSet<CostedPoint> list) {
        CostedPoint nearP = null;
        double d = 0.0;
        for (CostedPoint pCandidate : list) {
            double dist = pCandidate.distance(p);
            if (nearP != null && !(dist < d)) continue;
            nearP = pCandidate;
            d = dist;
        }
        return nearP;
    }

    public static void install() {
        WeightedGoalRegistry.addToRegistry(new GroundNearDiffPairGoal());
    }

    @Override
    public void finish(AGeneticConnectionOptimizer.ConnectedChromosome c) {
        for (int i = 0; i < c.size(); ++i) {
            AGeneticConnectionOptimizer.Connected cI = (AGeneticConnectionOptimizer.Connected)((Object)c.get(i));
            if (cI.first != null || cI.second == null) continue;
            HierPin hp = ((AGeneticConnectionOptimizer.DPPL)cI.second).getDpp();
            Net groundNet = hp.getPin().getDeviceTemplate().getNet(groundNetName);
            if (groundNet == null) {
                groundNet = hp.getPin().getDeviceTemplate().createNet(groundNetName);
            }
            ((PinInstance)hp.second).setNet(groundNet);
        }
    }

    static class CostedPoint {
        protected double cost;
        protected APoint2D p;

        public CostedPoint(double cost, APoint2D p) {
            this.cost = cost;
            this.p = p;
        }

        public double getCost() {
            return this.cost;
        }

        public void setCost(double cost) {
            this.cost = cost;
        }

        public APoint2D getP() {
            return this.p;
        }

        public void setP(APoint2D p) {
            this.p = p;
        }

        public void incrCost(double incr) {
            this.cost *= incr;
        }

        public double distance(APoint2D other) {
            return (double)Math.abs(other.yDistance(this.p)) * Math.pow(2.0, this.cost + 2.0);
        }
    }
}

