/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.public_source.examples;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.xml.AXDomUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLExport {
    public static boolean exportDeviceTemplate(DeviceTemplate dt, String filePath, boolean outputReferencedTemplates) {
        boolean bl;
        Db db = dt.getDb();
        Design design = db == null ? null : Design.getDesign((Db)db);
        Unit unit = design == null ? Unit.IDENTITY : design.getUnit();
        Element elemRoot = AXDomUtil.createXmlDoc((String)"XMLExport-DeviceTemplate");
        if (dt.getSubstrate() != null) {
            elemRoot.setAttribute("substrate", dt.getSubstrate().getName());
        }
        elemRoot.setAttribute("deviceTemplate", dt.getName());
        elemRoot.setAttribute("timestamp", new Date().toString());
        XMLExport.outputDeviceTemplate(elemRoot, unit, dt, outputReferencedTemplates);
        FileOutputStream os = new FileOutputStream(new File(filePath));
        try {
            bl = AXDomUtil.serialize((Node)elemRoot, (OutputStream)os);
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error writing XML output file '%s'.", (Object[])new Object[]{filePath});
                return false;
            }
        }
        os.close();
        return bl;
    }

    public static void outputDeviceTemplate(Element elemParent, Unit unit, DeviceTemplate dt, boolean outputReferencedDeviceTemplates) {
        long srcModifiedTime;
        LinkedHashSet<DeviceTemplate> referencedTemplates = new LinkedHashSet<DeviceTemplate>();
        Element elemDT = AXDomUtil.addElement((Element)elemParent, (String)"DeviceTemplate");
        Substrate substrate = dt.getSubstrate();
        if (substrate != null) {
            elemDT.setAttribute("substrate", substrate.getName());
        }
        elemDT.setAttribute("name", dt.getName());
        ARect bounds = dt.getBB();
        elemDT.setAttribute("llx", unit.toUserStr(bounds.getLL().getX()));
        elemDT.setAttribute("lly", unit.toUserStr(bounds.getLL().getY()));
        elemDT.setAttribute("urx", unit.toUserStr(bounds.getUR().getX()));
        elemDT.setAttribute("ury", unit.toUserStr(bounds.getUR().getY()));
        elemDT.setAttribute("type", dt.getType().name());
        elemDT.setAttribute("sourceType", dt.getSourceType().name());
        String sourceFile = dt.getSourceFile();
        if (sourceFile != null) {
            elemDT.setAttribute("sourceFile", sourceFile);
        }
        if ((srcModifiedTime = dt.getSourceFileModifiedTime()) != 0L) {
            elemDT.setAttribute("sourceFileModified", new Date(srcModifiedTime).toString());
        }
        for (Net net : dt.getNets()) {
            Element elemNet = AXDomUtil.addElement((Element)elemDT, (String)"Net");
            elemNet.setAttribute("name", net.getName());
            for (PinTemplate pinT : net.getPinTemplates()) {
                Element elemPinT = AXDomUtil.addElement((Element)elemNet, (String)"Pin");
                elemPinT.setAttribute("name", pinT.getName());
                elemPinT.setAttribute("type", pinT.getType().name());
                elemPinT.setAttribute("direction", pinT.getDirection().name());
                elemPinT.setAttribute("use", pinT.getUse().name());
                for (PortTemplate portT : pinT.getPortTemplates()) {
                    PadTemplate padT;
                    boolean mirror;
                    float rotate;
                    Element elemPortT = AXDomUtil.addElement((Element)elemPinT, (String)"Port");
                    elemPortT.setAttribute("portNum", Integer.toString(portT.getPortNum()));
                    APoint2D loc = portT.getLoc();
                    if (loc != null) {
                        elemPortT.setAttribute("x", unit.toUserStr(loc.getX()));
                        elemPortT.setAttribute("y", unit.toUserStr(loc.getY()));
                    }
                    if ((rotate = portT.getRotate()) != 0.0f) {
                        elemPortT.setAttribute("rotate", Float.toString(rotate));
                    }
                    if (mirror = portT.getMirror()) {
                        elemPortT.setAttribute("mirror", Boolean.TRUE.toString());
                    }
                    if ((padT = portT.getPadTemplate()) == null) continue;
                    elemPortT.setAttribute("padTemplate", padT.getName());
                }
            }
        }
        for (Device device : dt.getChildren()) {
            boolean flipped;
            boolean mirror;
            float rotate;
            if (outputReferencedDeviceTemplates) {
                referencedTemplates.add(device.getTemplate());
            }
            Element elemDevice = AXDomUtil.addElement((Element)elemDT, (String)"Device");
            elemDevice.setAttribute("name", device.getName());
            Substrate devSubstrate = device.getSubstrate();
            if (devSubstrate != substrate) {
                elemDevice.setAttribute("susbstrate", devSubstrate.getName());
            }
            elemDevice.setAttribute("template", device.getTemplate().getName());
            APoint2D loc = device.getLoc();
            if (loc != null) {
                elemDevice.setAttribute("x", unit.toUserStr(loc.getX()));
                elemDevice.setAttribute("y", unit.toUserStr(loc.getY()));
            }
            if ((rotate = device.getRotate()) != 0.0f) {
                elemDevice.setAttribute("rotate", Float.toString(rotate));
            }
            if (mirror = device.getMirror()) {
                elemDevice.setAttribute("mirror", Boolean.TRUE.toString());
            }
            if (!(flipped = device.getMirror())) continue;
            elemDevice.setAttribute("flipped", Boolean.TRUE.toString());
        }
        for (DeviceTemplate refDT : referencedTemplates) {
            XMLExport.outputDeviceTemplate(elemParent, unit, refDT, true);
        }
    }

    private XMLExport() {
    }
}

