/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.serial;

import com.sigrity.acl.ABoolean;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomSaxUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.xml.AXSaxUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.io.CharArrayWriter;
import java.io.File;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class UpdXmlReader {
    protected Db mDb;
    protected DeviceTemplate mDeviceTemplate = null;
    protected PinTemplate mPinTemplate = null;
    protected Layer mLayer = null;
    protected Device mDevice;
    protected PadTemplate mPadTemplate;
    protected String mLayerRefName;
    protected int mPinNum = 1;
    protected static double mUPDPerMicron;
    protected static long mInternalToMicron;
    protected Device mRootDevice = null;
    protected ArrayList<Device> mAddedDevices = new ArrayList();
    protected AXSaxUtil.ElementHandler mRootHandler = new AXSaxUtil.ElementHandler();
    protected AXSaxUtil.ElementHandler mDesignHandler = new AXSaxUtil.ElementHandler(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            String s = attr.getValue("InternalPerInch");
            double d = s != null ? Double.parseDouble(s) : 2.54E7;
            mUPDPerMicron = d / 25400.0;
            Design design = Design.getDesign((Db)UpdXmlReader.this.mDb);
            mInternalToMicron = design.getInternalPerMicron();
        }
    };
    protected AXSaxUtil.ElementHandler mDeviceTemplatesHandler = new AXSaxUtil.ElementHandler();
    protected AGeomSaxUtil.GeomHandler.GeomConsumer mDeviceTemplateHandler = new AGeomSaxUtil.GeomHandler.GeomConsumer(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            DbClass dbClass = UpdXmlReader.this.mDb.getDbClass("DeviceTemplate");
            UpdXmlReader.this.mDeviceTemplate = (DeviceTemplate)dbClass.createInstance();
            UpdXmlReader.this.mDeviceTemplate.setName(attr.getValue("Name"));
            UpdXmlReader.this.mDb.add((DbObject)UpdXmlReader.this.mDeviceTemplate);
        }

        public void setGeom(AGeom g, String hint) {
            UpdXmlReader.this.mDeviceTemplate.setValue(hint, (Object)g);
        }
    };
    protected AXSaxUtil.ElementHandler mDeviceTemplatePortsHandler = new AXSaxUtil.ElementHandler();
    protected AGeomSaxUtil.PointHandler.PointConsumer mDeviceTemplatePortHandler = new AGeomSaxUtil.PointHandler.PointConsumer(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            DbClass dbClass = UpdXmlReader.this.mDb.getDbClass("PinTemplate");
            UpdXmlReader.this.mPinTemplate = (PinTemplate)dbClass.createInstance();
            UpdXmlReader.this.mPinTemplate.setName(UpdXmlReader.this.mDeviceTemplate.getName() + attr.getValue("Name"));
            PadTemplate pt = (PadTemplate)UpdXmlReader.this.mDb.getByKeyStr(PadTemplate.class, attr.getValue("Padstack"));
            if (pt != null) {
                UpdXmlReader.this.mPinTemplate.setPadTemplate(pt);
            }
            UpdXmlReader.this.mPinTemplate.setValue("template", (Object)UpdXmlReader.this.mDeviceTemplate);
            UpdXmlReader.this.mDb.add((DbObject)UpdXmlReader.this.mPinTemplate);
        }

        public void setPoint(APoint2D p, String hint) {
            UpdXmlReader.this.mPinTemplate.setValue(hint, (Object)p);
        }
    };
    protected AXSaxUtil.ElementHandler mNetsHandler = new AXSaxUtil.ElementHandler();
    protected AXSaxUtil.ElementHandler mNetHandler = new AGeomSaxUtil.PointHandler.PointConsumer(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            Net net = (Net)UpdXmlReader.this.mDb.getByKeyStr(Net.class, attr.getValue("Name"));
            if (net != null) {
                net.setValue("isPower", (Object)ABoolean.fromString((String)attr.getValue("IsPower")));
            }
        }

        public void setPoint(APoint2D p, String hint) {
            UpdXmlReader.this.mPinTemplate.setValue(hint, (Object)p);
        }
    };
    protected AXSaxUtil.ElementHandler mLayersHandler = new AXSaxUtil.ElementHandler();
    protected AXSaxUtil.ElementHandler mLayerHandler = new AGeomSaxUtil.PointHandler.PointConsumer(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            DbClass dbClass = UpdXmlReader.this.mDb.getDbClass("Layer");
            UpdXmlReader.this.mLayer = (Layer)dbClass.createInstance();
            UpdXmlReader.this.mLayer.setName(attr.getValue("Name"));
            UpdXmlReader.this.mLayer.setHeight(AXSaxUtil.getLong((String)"Thickness", (Attributes)attr));
            UpdXmlReader.this.mDb.add((DbObject)UpdXmlReader.this.mLayer);
        }

        public void setPoint(APoint2D p, String hint) {
            UpdXmlReader.this.mPinTemplate.setValue(hint, (Object)p);
        }
    };
    protected AXSaxUtil.ElementHandler mDevicePortsHandler = new AXSaxUtil.ElementHandler();
    protected AGeomSaxUtil.PointHandler.PointConsumer mDevicePortHandler = new AGeomSaxUtil.PointHandler.PointConsumer(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            DbClass dbClass = UpdXmlReader.this.mDb.getDbClass("PinInstance");
            PinInstance dp = (PinInstance)dbClass.createInstance();
            String netKey = attr.getValue("Net");
            Net net = (Net)UpdXmlReader.this.mDb.getByKeyStr(Net.class, netKey);
            if (net == null) {
                net = new Net(null, netKey);
                UpdXmlReader.this.mDb.add((DbObject)net);
            }
            dp.setNet(net);
            DeviceTemplate dt = UpdXmlReader.this.mDevice.getTemplate();
            String dtpn = dt.getName() + Integer.valueOf(UpdXmlReader.this.mPinNum).toString();
            PinTemplate dtp = net.getPinTemplate(dtpn);
            dp.setValue("pinTemplate", (Object)dtp);
            dp.setValue("device", (Object)UpdXmlReader.this.mDevice);
            String dpn = UpdXmlReader.this.mDevice.getName() + Integer.valueOf(UpdXmlReader.this.mPinNum).toString();
            dp.setPinInstanceName(dpn);
            UpdXmlReader.this.mDb.add((DbObject)dp);
            ++UpdXmlReader.this.mPinNum;
        }

        public void setPoint(APoint2D p, String hint) {
        }
    };
    protected AXSaxUtil.ElementHandler mDevicesHandler = new AXSaxUtil.ElementHandler();
    protected AGeomSaxUtil.PointHandler.PointConsumer mDeviceHandler = new AGeomSaxUtil.PointHandler.PointConsumer(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            DbClass dbClass = UpdXmlReader.this.mDb.getDbClass("Device");
            UpdXmlReader.this.mDevice = (Device)dbClass.createInstance();
            String name = attr.getValue("Name");
            UpdXmlReader.this.mDevice.setName(name);
            UpdXmlReader.this.mDevice.setIsPlaced(ABoolean.fromString((String)attr.getValue("Placed")));
            String rString = attr.getValue("Rotation");
            if (rString != null) {
                int r = (int)Double.parseDouble(rString);
                r = (360 - r) % 360;
                UpdXmlReader.this.mDevice.setRotate((float)r);
            }
            if ((rString = attr.getValue("Mirror")) != null) {
                UpdXmlReader.this.mDevice.setMirror(true);
            }
            UpdXmlReader.this.mDb.add((DbObject)UpdXmlReader.this.mDevice);
            if (UpdXmlReader.this.mRootDevice == null) {
                UpdXmlReader.this.mRootDevice = UpdXmlReader.this.mDevice;
            }
            UpdXmlReader.this.mAddedDevices.add(UpdXmlReader.this.mDevice);
            DbObject template = UpdXmlReader.this.mDb.getByKeyStr(DeviceTemplate.class, attr.getValue("DeviceTemplate"));
            if (template != null) {
                UpdXmlReader.this.mDb.getRelation("Device-template").relate((DbObject)UpdXmlReader.this.mDevice, template);
            } else {
                ALog.logWarn((String)("Device " + name + " looking for nonnexistant template" + attr.getValue("DeviceTemplate")));
            }
            UpdXmlReader.this.mPinNum = 1;
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
            if (UpdXmlReader.this.mDevice.getValue("loc") == null) {
                UpdXmlReader.this.mDevice.setLoc(new APoint2D());
            }
        }

        public void setPoint(APoint2D p, String hint) {
            UpdXmlReader.this.mDevice.setValue(hint, (Object)p);
        }
    };
    protected AXSaxUtil.ElementHandler mPadTemplatesHandler = new AXSaxUtil.ElementHandler();
    protected AXSaxUtil.ElementHandler mPadTemplateHandler = new AGeomSaxUtil.PointHandler.PointConsumer(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            String name = attr.getValue("Name");
            if (UpdXmlReader.this.mDb.getDbClass("PadTemplate").getInstanceByKey(new Object[]{name}) == null) {
                super.onStart(namespaceURI, localName, qName, attr);
                DbClass dbClass = UpdXmlReader.this.mDb.getDbClass("PadTemplate");
                UpdXmlReader.this.mPadTemplate = (PadTemplate)dbClass.createInstance();
                UpdXmlReader.this.mPadTemplate.setName(name);
                UpdXmlReader.this.mDb.add((DbObject)UpdXmlReader.this.mPadTemplate);
            }
        }

        public void setPoint(APoint2D p, String hint) {
        }
    };
    protected AGeomSaxUtil.GeomHandler.GeomConsumer mLayerRefHandler = new AGeomSaxUtil.GeomHandler.GeomConsumer(){

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            UpdXmlReader.this.mLayerRefName = attr.getValue("Name");
        }

        public void setGeom(AGeom g, String hint) {
            Layer l = (Layer)UpdXmlReader.this.mDb.getByKeyStr(Layer.class, UpdXmlReader.this.mLayerRefName);
            if (l != null) {
                LayerShape.create((Layer)l, (DbObject)UpdXmlReader.this.mPadTemplate, (AGeom)g);
            }
        }
    };
    protected AGeomSaxUtil.UnitConversion mUnitConversion = new AGeomSaxUtil.UnitConversion(){

        public long convertUnit(long updV) {
            return (long)((double)updV / mUPDPerMicron * (double)mInternalToMicron);
        }
    };

    public static boolean importUpdXml(String filePath) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot import '%s', there is no current database.", (Object[])new Object[]{filePath});
            return false;
        }
        UpdXmlReader reader = new UpdXmlReader();
        File f = new File(filePath);
        if (!reader.loadUpdXml(db, f)) {
            return false;
        }
        Design d = Design.getDesign((Db)db);
        d.binAllDevices();
        return true;
    }

    public boolean loadUpdXml(Db db, File f) {
        this.mDb = db;
        this.mRootHandler.setHandler("UPDDesign", this.mDesignHandler);
        this.mDesignHandler.setHandler("DeviceTemplates", this.mDeviceTemplatesHandler);
        this.mDeviceTemplatesHandler.setHandler("DeviceTemplate", (AXSaxUtil.ElementHandler)this.mDeviceTemplateHandler);
        this.mDeviceTemplateHandler.setHandler("Geom", (AXSaxUtil.ElementHandler)new AGeomSaxUtil.GeomHandler(this.mDeviceTemplateHandler, this.mUnitConversion, "bounds"));
        this.mDeviceTemplateHandler.setHandler("DeviceTemplatePorts", this.mDeviceTemplatePortsHandler);
        this.mDeviceTemplatePortsHandler.setHandler("PinTemplate", (AXSaxUtil.ElementHandler)this.mDeviceTemplatePortHandler);
        this.mDeviceTemplatePortHandler.setHandler("point", (AXSaxUtil.ElementHandler)new AGeomSaxUtil.PointHandler(this.mDeviceTemplatePortHandler, this.mUnitConversion, "loc"));
        this.mDesignHandler.setHandler("Layers", this.mLayersHandler);
        this.mLayersHandler.setHandler("Layer", this.mLayerHandler);
        this.mDesignHandler.setHandler("Devices", this.mDevicesHandler);
        this.mDevicesHandler.setHandler("Device", (AXSaxUtil.ElementHandler)this.mDeviceHandler);
        this.mDesignHandler.setHandler("Nets", this.mNetsHandler);
        this.mNetsHandler.setHandler("Net", this.mNetHandler);
        this.mDeviceHandler.setHandler("point", (AXSaxUtil.ElementHandler)new AGeomSaxUtil.PointHandler(this.mDeviceHandler, this.mUnitConversion, "loc"));
        this.mDeviceHandler.setHandler("DevicePorts", this.mDevicePortsHandler);
        this.mDevicePortsHandler.setHandler("PinInstance", (AXSaxUtil.ElementHandler)this.mDevicePortHandler);
        this.mDesignHandler.setHandler("PadTemplates", this.mPadTemplatesHandler);
        this.mPadTemplatesHandler.setHandler("PadTemplate", this.mPadTemplateHandler);
        this.mPadTemplateHandler.setHandler("LayerRef", (AXSaxUtil.ElementHandler)this.mLayerRefHandler);
        this.mLayerRefHandler.setHandler("Geom", (AXSaxUtil.ElementHandler)new AGeomSaxUtil.GeomHandler(this.mLayerRefHandler, this.mUnitConversion, "geom"));
        AXSaxUtil.SaxParser sp = new AXSaxUtil.SaxParser(this.mRootHandler);
        if (!sp.parse(f)) {
            return false;
        }
        this.fixUpHierarchy();
        this.fixUpOffsets();
        return true;
    }

    protected void fixUpOffsets() {
        if (this.mRootDevice == null) {
            return;
        }
        DevicePath pathRootDevice = new DevicePath((DeviceTemplate)Design.getDesign((Db)this.mDb), this.mRootDevice);
        APoint2D ll = this.mRootDevice.getTemplate().getBB().getLL();
        for (Device d : this.mAddedDevices) {
            if (d == this.mRootDevice) continue;
            DevicePath path = new DevicePath(pathRootDevice, d);
            APoint2D myll = path.getBB().getLL();
            d.moveTo(myll.getX() - ll.getX(), myll.getY() - ll.getY());
        }
    }

    protected void fixUpHierarchy() {
        Design currentDesign = Design.getDesign((Db)this.mDb);
        if (this.mRootDevice == null) {
            return;
        }
        this.mRootDevice.setParent((DeviceTemplate)currentDesign);
        for (Device d : this.mAddedDevices) {
            DeviceTemplate t = d.getTemplate();
            if (d != this.mRootDevice) {
                d.setParent(this.mRootDevice.getTemplate());
                t.setType(DeviceTemplate.Type.PACKAGEDDIE);
                continue;
            }
            t.setType(DeviceTemplate.Type.PACKAGE);
        }
    }
}

