/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.spd2000;

import com.sigrity.acl.AFile;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.SPDOut;
import com.sigrity.orbit.spd2000.Spd2000Reader;
import com.sigrity.orbit.spd2000.SpdDBProcessor;
import java.io.File;
import java.util.ArrayList;

public class Spd2000 {
    public static final String FILE_EXT_SPD = "spd";
    public static final String FILE_DESC_SPD = "SPD File";
    public static final OrbitIO.FileHandler FileHandler = new OrbitIO.FileHandler(){

        @Override
        public boolean canHandle(String action, File file) {
            if (!file.isFile()) {
                return false;
            }
            if (!file.canRead()) {
                return false;
            }
            String ext = AFile.getExtension((File)file);
            if (ext == null) {
                return false;
            }
            return ext.equalsIgnoreCase(Spd2000.FILE_EXT_SPD);
        }

        @Override
        public boolean handle(String action, File file) {
            if (!this.canHandle(action, file)) {
                return false;
            }
            OrbitIO.getApp().getWorkspace().importSpeed(null, file);
            return true;
        }
    };

    public static void importFile(String fileName, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type templateType, boolean readWire, boolean readShape, String substrateKeyStr) {
        Spd2000.importFile(fileName, rootDeviceName, deviceTemplatePrefix, templateType, readWire, readShape, substrateKeyStr, false, false);
    }

    public static void importFile(String fileName, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type templateType, boolean readWire, boolean readShape, String substrateKeyStr, boolean isIgnoreLayerPrefix, boolean isIgnoreDielectric) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            OrbitIO.getApp().createDesign();
            db = OrbitIO.getCurDb();
        }
        assert (db != null);
        Spd2000Reader reader = new Spd2000Reader();
        SpdDBProcessor p = new SpdDBProcessor(db, reader, rootDeviceName, deviceTemplatePrefix, templateType, readWire, readShape, substrateKeyStr, isIgnoreLayerPrefix, isIgnoreDielectric);
        reader.setDbProcessor(p);
        reader.mkDesign(fileName);
    }

    public static boolean exportSpd(String fileName, String substrate) {
        SPDOut out = new SPDOut(true);
        return out.exportSpd(fileName, substrate);
    }

    protected static interface SpdReader {
        public String newLineString();

        public String nextToken();

        public String currentToken();

        public String getCurrentContent();

        public long getCurrentLineID();

        public void pushbackToken(String var1);

        public void skipLine();

        public boolean skipTokens(int var1);

        public boolean findToken(String var1);

        public ArrayList<String> readTokens(int var1);

        public String getSourceFile();
    }
}

