/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.spd2000;

import com.sigrity.acl.ALog;
import com.sigrity.orbit.spd2000.Spd2000;
import com.sigrity.orbit.spd2000.SpdDBProcessor;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;

public class Spd2000Reader
implements Spd2000.SpdReader {
    protected static String NEWLINE = "\n";
    protected String mFile;
    protected String mOldToken = null;
    protected String mLineBuffer = "";
    protected SpdDBProcessor mProcessor = null;
    protected BufferedReader mInReader = null;
    protected LinkedList<String> mLineTokens = new LinkedList();
    protected Stack<String> mPendingToken = new Stack();
    protected long mCurrentLineID = 0L;
    protected String mCurrentContent = "";

    public void setDbProcessor(SpdDBProcessor processor) {
        this.mProcessor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkDesign(String file) {
        ALog.logInfo((String)"Importing SPD file '%s'...", (Object[])new Object[]{file});
        this.mFile = file;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            this.mInReader = reader;
            this.mProcessor.mkDesign();
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"File '%s' not found.", (Object[])new Object[]{file});
        }
        catch (IOException ex) {
            ALog.logError((Throwable)ex, (String)"IOError while reading '%s'.", (Object[])new Object[]{file});
        }
        finally {
            ALog.logInfo((String)"Done.");
        }
    }

    @Override
    public String newLineString() {
        return NEWLINE;
    }

    @Override
    public String nextToken() {
        this.mOldToken = this.readToken();
        return this.mOldToken;
    }

    @Override
    public String currentToken() {
        return this.mOldToken;
    }

    @Override
    public void pushbackToken(String token) {
        this.mPendingToken.push(token);
    }

    @Override
    public void skipLine() {
        String s = this.nextToken();
        while (s != null && !s.equalsIgnoreCase(NEWLINE)) {
            s = this.nextToken();
        }
    }

    @Override
    public boolean skipTokens(int tokenNum) {
        for (int i = 0; i < tokenNum; ++i) {
            String s = this.nextToken();
            if (s != null && !s.equalsIgnoreCase(NEWLINE)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean findToken(String token) {
        String s;
        while ((s = this.nextToken()) != null && !s.equalsIgnoreCase(NEWLINE)) {
            if (!s.equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<String> readTokens(int n) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String s = this.nextToken();
            if (s == null || s.equalsIgnoreCase(NEWLINE)) {
                return null;
            }
            l.add(s);
        }
        return l;
    }

    protected String readLine() throws IOException {
        Object line;
        block2: {
            String s;
            line = this.mLineBuffer;
            this.mLineBuffer = "";
            while (true) {
                s = this.mInReader.readLine();
                ++this.mCurrentLineID;
                if (s == null) break block2;
                s.trim();
                if (s.isEmpty() || s.charAt(0) == '*') continue;
                if (s.charAt(0) == '+') {
                    line = (String)line + " " + s.substring(1);
                    continue;
                }
                if (!((String)line).isEmpty()) break;
                line = s;
            }
            this.mLineBuffer = s;
        }
        return ((String)line).isEmpty() ? null : line;
    }

    protected void parseLineTokens() throws IOException {
        String[] tokens;
        assert (this.mLineTokens.isEmpty());
        this.mCurrentContent = this.readLine();
        if (this.mCurrentContent == null || this.mCurrentContent.isEmpty()) {
            return;
        }
        for (String t : tokens = this.mCurrentContent.split("\\s+")) {
            int i = t.indexOf(61);
            if (i <= 0) {
                this.mLineTokens.add(t);
                continue;
            }
            this.mLineTokens.add(t.substring(0, i));
            this.mLineTokens.add("=");
            if (i >= t.length() - 1) continue;
            this.mLineTokens.add(t.substring(i + 1));
        }
        this.mLineTokens.add(NEWLINE);
    }

    protected String readToken() {
        if (!this.mPendingToken.empty()) {
            return this.mPendingToken.pop();
        }
        String token = null;
        try {
            if (this.mLineTokens.isEmpty()) {
                this.parseLineTokens();
            }
            if (!this.mLineTokens.isEmpty()) {
                token = this.mLineTokens.removeFirst();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return token;
    }

    @Override
    public String getSourceFile() {
        return this.mFile;
    }

    @Override
    public String getCurrentContent() {
        return this.mCurrentContent;
    }

    @Override
    public long getCurrentLineID() {
        return this.mCurrentLineID;
    }
}

