/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.spd2000;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomWithCutouts;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.spd2000.Spd2000;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpdDBProcessor {
    public static final String DEFAULT_ROOTDEVNAME = "SPDDesign";
    public static final String DEFAULT_LENGTH_UNIT = "m";
    public static final long MICRONPERMETER = 1000000L;
    public static final String DEFAULTPADSTACKNAME = "~DefaultPadStack";
    public static boolean MergeWires = true;
    protected Db mDb;
    protected Design mDbDesign = null;
    protected APoint2D mOffsetOrigin = new APoint2D();
    protected SpdDesign mDesignSection = null;
    protected Spd2000.SpdReader mReader;
    protected String mRootDeviceName;
    protected Device mRootDevice = null;
    protected boolean mReadTrace = true;
    protected boolean mReadShape = true;
    protected Substrate mSubstrate;
    protected boolean mIgnoreLayerPrefix = true;
    protected boolean mIgnoreDielectric = true;
    protected SpdUnit mInternalUnit = null;
    protected SpdGeomParser mGeomParser = null;
    protected DeviceTemplate.Type mTemplateType = DeviceTemplate.Type.PACKAGE;
    protected int mLayerOrder = 0;
    protected static int mKeyIndex = 0;
    protected String mDeviceTemplatePrefix = null;
    protected PadTemplate mDefaultPadStack = null;
    protected HashMap<SpdNode, PinTemplate> mNode2Pin = new HashMap();
    protected HashMultimap<SpdNode, Wire> mNode2Wires = HashMultimap.create();
    protected LinkedHashMap<Wire, SpdNode> mWire2StartNode = new LinkedHashMap();
    protected LinkedHashMap<Wire, SpdNode> mWire2EndNode = new LinkedHashMap();
    protected HashMap<String, String> mRenamedDeviceTemplates = new HashMap();
    protected BiMap<String, String> mNames = HashBiMap.create();
    protected Pattern mPattern = Pattern.compile("[a-zA-Z0-9_\\-\\:\\[\\]]");
    protected HashMap<SpdSection, HashMap<String, SpdVia>> mNode2Via = new HashMap();
    protected HashMap<String, HashMap<Layer, PadTemplate>> mLayer2PadStack = new HashMap();
    protected HashSet<Device> unplacedDevices = new HashSet();
    protected HashMap<SpdNode, MutableInteger> mStartNodes = new HashMap();
    protected HashMap<SpdNode, MutableInteger> mEndNodes = new HashMap();
    protected LinkedHashMap<String, SpdVia> viaTable = new LinkedHashMap();
    protected HashMap<Long, HashMap<String, PadTemplate>> mWidthLayerName2PadStack = new HashMap();
    protected LinkedHashMap<Net, LinkedHashMultimap<Layer, Wire>> mNetLayer2Wires = new LinkedHashMap();
    protected long mNextWireEndId = 1L;

    public SpdDBProcessor(Db db, Spd2000.SpdReader reader, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type type, boolean readWire, boolean readShape, String substrateKeyStr) {
        this(db, reader, rootDeviceName, deviceTemplatePrefix, type, readWire, readShape, substrateKeyStr, false, false);
    }

    public SpdDBProcessor(Db db, Spd2000.SpdReader reader, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type type, boolean readWire, boolean readShape, String substrateKeyStr, boolean isIgnoreLayerPrefix, boolean isIgnoreDielectric) {
        this.mDb = db;
        this.mReader = reader;
        this.mRootDeviceName = rootDeviceName;
        if (this.mRootDeviceName == null || this.mRootDeviceName.isEmpty()) {
            this.mRootDeviceName = DEFAULT_ROOTDEVNAME;
        }
        this.mDeviceTemplatePrefix = deviceTemplatePrefix;
        this.mTemplateType = type;
        this.mReadTrace = readWire;
        this.mReadShape = readShape;
        this.mSubstrate = substrateKeyStr.isEmpty() ? null : (Substrate)this.mDb.getByKeyStr(Substrate.class, substrateKeyStr);
        this.mIgnoreLayerPrefix = isIgnoreLayerPrefix;
        this.mIgnoreDielectric = isIgnoreDielectric;
        this.mDbDesign = Design.getDesign((Db)this.mDb);
        if (this.mDbDesign == null) {
            this.mDbDesign = Design.create((Db)this.mDb);
        }
        this.mInternalUnit = new SpdUnit(this.mDb);
        this.mGeomParser = new SpdGeomParser();
    }

    public void mkDesign() {
        try {
            this.mDesignSection = new SpdDesign(null, "design");
            this.mDesignSection.mSectionDef = new SectionDef("", "^\\.end$", SpdDesign.class);
            this.mDesignSection.parse("design");
            this.createDb();
        }
        catch (InvalidDataException e) {
            ALog.logError((String)e.getMessage());
        }
    }

    public Device getRootDevice() {
        return this.mRootDevice;
    }

    protected ArrayList<String> parseTokens(String str, String[] delimiters) {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Integer> pos = new ArrayList<Integer>();
        tokens.add("");
        for (int i = 0; str != null && i < delimiters.length; ++i) {
            pos.add(str.indexOf(delimiters[i]));
        }
        int minPos = Integer.MAX_VALUE;
        for (int i = 0; i < pos.size(); ++i) {
            int startPos = (Integer)pos.get(i);
            if (startPos < 0) {
                tokens.add("");
                continue;
            }
            if (minPos > startPos) {
                minPos = startPos;
            }
            int endPos = str.length();
            Iterator iterator = pos.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                if (k <= startPos || k >= endPos) continue;
                endPos = k;
            }
            if (startPos + delimiters[i].length() == str.length()) {
                tokens.add("");
                continue;
            }
            tokens.add(str.substring(startPos + delimiters[i].length(), endPos));
        }
        tokens.set(0, minPos == Integer.MAX_VALUE ? str : str.substring(0, minPos));
        return tokens;
    }

    protected String correctName(String name) {
        Object result = (String)this.mNames.get((Object)name);
        if (result != null) {
            return result;
        }
        result = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            result = (String)result + (Serializable)(this.mPattern.matcher("" + c).matches() ? Character.valueOf(c) : "_");
        }
        String old = result;
        int i = 0;
        while (this.mNames.inverse().get(result) != null) {
            result = old + "_" + i;
            ++i;
        }
        this.mNames.put((Object)name, result);
        return result;
    }

    protected String correctLayerName(String layerName) {
        if (this.mIgnoreLayerPrefix) {
            layerName = layerName.replaceFirst("^[Pp]lane_", "");
            layerName = layerName.replaceFirst("^[Ss]hape_", "");
            layerName = layerName.replaceFirst("^[Ss]ignal_", "");
            layerName = layerName.replaceFirst("^[Mm]edium_", "");
        }
        return layerName;
    }

    protected String getDeviceTemplateName(String baseName) {
        return this.mDeviceTemplatePrefix == null ? baseName : String.format("%s%s", this.mDeviceTemplatePrefix, baseName);
    }

    protected DeviceTemplate getDeviceTemplate(String baseName) {
        String name = this.getDeviceTemplateName(baseName);
        String rename = this.mRenamedDeviceTemplates.get(name);
        if (rename != null) {
            name = rename;
        }
        return DeviceTemplate.getDeviceTemplate((Substrate)this.mSubstrate, (String)name);
    }

    protected DeviceTemplate createDeviceTemplate(String baseName) {
        String name;
        String string = name = DeviceTemplate.getDeviceTemplate((Substrate)this.mSubstrate, (String)(baseName = this.getDeviceTemplateName(baseName))) != null ? DeviceTemplate.getUniqueName((Substrate)this.mSubstrate, (String)baseName) : baseName;
        if (!name.equals(baseName)) {
            this.mRenamedDeviceTemplates.put(baseName, name);
        }
        DeviceTemplate dt = new DeviceTemplate(name, this.mSubstrate);
        dt.setSourceType(DeviceTemplate.SourceType.SPD);
        dt.setSourceFile(this.mReader.getSourceFile());
        return dt;
    }

    protected <T extends SpdSection> T getSpdSection(SpdSection parent, Class<T> cls, String key) {
        assert (parent != null);
        return parent.getSubSection(cls, key);
    }

    protected SpdPadStackDef getRelatedPadStack(SpdSection parent, String nodeName) {
        HashMap<String, SpdVia> vias = this.mNode2Via.get(parent);
        if (vias == null) {
            return null;
        }
        SpdVia via = vias.get(nodeName.toLowerCase());
        if (via == null || via.mPadStack == null || via.mPadStack.isEmpty()) {
            return null;
        }
        return this.getSpdSection(parent, SpdPadStackDef.class, via.mPadStack);
    }

    protected void createSubstrate(SpdPackage pkgSection) {
        Object substrateName = this.mRootDeviceName + "_Substrate";
        if (!((String)substrateName).startsWith("SPD_")) {
            substrateName = "SPD_" + (String)substrateName;
        }
        if (Substrate.getSubstrate((Db)this.mDb, (String)(substrateName = this.correctName((String)substrateName))) != null) {
            substrateName = Substrate.getUniqueName((Db)this.mDb, (String)substrateName);
        }
        this.mSubstrate = Substrate.create((Db)this.mDb, (String)substrateName);
    }

    protected void createLayers(SpdPackage pkgSection) {
        Iterator itrLayer = pkgSection.getSubSection(SpdLayer.class);
        ArrayList<SpdLayer> listLayer = new ArrayList<SpdLayer>();
        while (itrLayer != null && itrLayer.hasNext()) {
            listLayer.add((SpdLayer)itrLayer.next());
        }
        Collections.sort(listLayer);
        for (SpdLayer ls : listLayer) {
            if (this.mIgnoreDielectric && ls.mType == Layer.LayerType.Dielectric) continue;
            Layer l = this.mSubstrate.getLayer(ls.mName);
            if (l == null) {
                l = Layer.create((Substrate)this.mSubstrate, (String)ls.mName);
            }
            l.setType(ls.mType);
            if (ls.mThickness > 0.0) {
                l.setHeight((long)ls.mThickness);
            }
            if (!(ls.mWidth > 0.0)) continue;
            l.setWidth((long)ls.mWidth);
        }
        int order = listLayer.size() - 1;
        for (SpdLayer ls : listLayer) {
            Layer l = this.mSubstrate.getLayer(ls.mName);
            if (l == null) continue;
            l.setOrder(order--);
        }
    }

    private PadTemplate getDefaultPadTemplate() {
        if (this.mDefaultPadStack == null) {
            Object defaultPadStackName = DEFAULTPADSTACKNAME;
            int i = 0;
            while (PadTemplate.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)defaultPadStackName) != null) {
                defaultPadStackName = DEFAULTPADSTACKNAME + i;
                ++i;
            }
            this.mDefaultPadStack = PadTemplate.create((Db)this.mDb, (Substrate)this.mSubstrate, (String)defaultPadStackName);
        }
        return this.mDefaultPadStack;
    }

    protected PadTemplate getPadTemplate(SpdPackage pkgSection, String padStackName, Layer layer) {
        PadTemplate padTemplate;
        HashMap<Object, Object> layer2PadTemplate = this.mLayer2PadStack.get(padStackName);
        if (layer2PadTemplate != null && (padTemplate = layer2PadTemplate.get(layer)) != null) {
            return padTemplate;
        }
        SpdPadStackDef spsd = pkgSection.getSubSection(SpdPadStackDef.class, padStackName);
        if (spsd == null) {
            return null;
        }
        Object pn = "_paddef_" + layer.getName().toLowerCase();
        SpdPadDef spd = spsd.getSubSection(SpdPadDef.class, (String)pn);
        if (spd == null) {
            pn = "_paddef_defaultliblayer";
        }
        if ((spd = spsd.getSubSection(SpdPadDef.class, (String)pn)) == null) {
            return null;
        }
        Object newName = padStackName;
        int i = 0;
        while ((padTemplate = PadTemplate.get((Db)this.mDb, (Substrate)layer.getSubstrate(), (String)newName)) != null) {
            newName = padStackName + i++;
        }
        padTemplate = PadTemplate.create((Db)this.mDb, (Substrate)layer.getSubstrate(), (String)newName);
        if (layer2PadTemplate == null) {
            layer2PadTemplate = new HashMap();
            this.mLayer2PadStack.put(padStackName, layer2PadTemplate);
        }
        layer2PadTemplate.put(layer, padTemplate);
        Iterator itrGeom = spd.getSubSection(SpdPad.class);
        if (itrGeom != null && itrGeom.hasNext()) {
            SpdPad padGeom = (SpdPad)itrGeom.next();
            LayerShape.create((Db)this.mDb, (Layer)layer, (DbObject)padTemplate, (AGeom)padGeom.mGeom);
        }
        return padTemplate;
    }

    protected void createComponents(SpdPackage pkgSection) {
        this.createCircuit(pkgSection, pkgSection);
        Iterator itrConns = this.mDesignSection.getSubSection(SpdConnect.class);
        while (itrConns != null && itrConns.hasNext()) {
            this.createCircuit(pkgSection, (SpdSection)itrConns.next());
        }
    }

    protected ARect getPadStackBound(SpdPadStackDef padStack) {
        ARect bb = new ARect();
        if (padStack == null) {
            return bb;
        }
        if (padStack.mBound != null) {
            return padStack.mBound;
        }
        Iterator itrPadDef = padStack.getSubSection(SpdPadDef.class);
        while (itrPadDef != null && itrPadDef.hasNext()) {
            SpdPadDef padDef = (SpdPadDef)itrPadDef.next();
            Iterator itrPad = padDef.getSubSection(SpdPad.class);
            while (itrPad != null && itrPad.hasNext()) {
                SpdPad pad = (SpdPad)itrPad.next();
                bb.expand(pad.mGeom.getBounds());
            }
        }
        padStack.mBound = bb;
        return bb;
    }

    protected void createPorts(SpdPackage pkgSection, SpdSection section, Device device) {
        boolean pkgFlag = pkgSection == section;
        Iterator<Object> itrNode = null;
        DeviceTemplate dt = device.getTemplate();
        itrNode = !pkgFlag ? this.getComponentNodes(pkgSection, (SpdConnect)section).iterator() : pkgSection.getSubSection(SpdNode.class);
        int nodeCnt = 0;
        ARect bound = null;
        while (itrNode != null && itrNode.hasNext()) {
            HashMap<String, SpdVia> vias;
            SpdPadStackDef spsd;
            SpdNode node = (SpdNode)itrNode.next();
            String psName = node.mPadStackName;
            if ((psName == null || psName.isEmpty()) && ((psName = (spsd = this.getRelatedPadStack(pkgSection, node.mName)) == null ? null : spsd.mName) == null || psName.isEmpty()) || (spsd = pkgSection.getSubSection(SpdPadStackDef.class, psName)) == null) continue;
            ARect rcPadStack = this.getPadStackBound(spsd);
            AffineTransform t = ATransformUtil.createTransform((double)0.0, (double)0.0, (float)node.mAbsoluteRotation, (boolean)false);
            APolygon pp = new APolygon(rcPadStack).transform(t);
            pp.moveCenterTo(node.mPoint);
            if (bound == null) {
                bound = pp.getBounds();
            } else {
                bound.expand(pp.getBounds());
            }
            ++nodeCnt;
            if (pkgFlag && this.getSectionOfPin(node.mName, pkgSection) != null) continue;
            Net net = this.createNet(device, node.mNetName);
            PadTemplate padTemplate = null;
            if (psName != null) {
                Layer l = Layer.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)node.mLayerName);
                if (l == null) {
                    ALog.logWarn((String)"Unable to find Layer '%s'.", (Object[])new Object[]{node.mLayerName});
                } else {
                    padTemplate = this.getPadTemplate(pkgSection, psName, l);
                }
            }
            if (padTemplate == null) {
                ALog.logWarn((String)"Unable to find PadTemplate '%s' for node '%s'.", (Object[])new Object[]{psName, node.mName});
                padTemplate = this.getDefaultPadTemplate();
            }
            PinTemplate.Type pinType = PinTemplate.Type.BALLPAD;
            String pinName = node.mName.split("\\::")[0];
            SpdPadStackDef viaPS = this.getRelatedPadStack(pkgSection, node.mName);
            SpdVia viaRec = viaPS == null ? null : this.viaTable.get(viaPS.mName);
            SpdVia via = null;
            boolean viaBallSize = false;
            if (viaRec != null && viaRec.mPadTemplate != null && (vias = this.mNode2Via.get(pkgSection)) != null && (via = vias.get(node.mName.toLowerCase())) != null) {
                if (via.viaCreated) {
                    if (!node.isPin()) {
                        PinTemplate pt = this.mNode2Pin.get(node);
                        if (pt != null || via.viaPinTemplate == null) continue;
                        this.mNode2Pin.put(node, via.viaPinTemplate);
                        continue;
                    }
                } else {
                    if (viaPS.mName.equals(psName)) {
                        if (!node.isPin()) {
                            via.viaCreated = true;
                            padTemplate = viaRec.mPadTemplate;
                            pinType = PinTemplate.Type.VIA;
                            viaBallSize = true;
                        }
                    } else {
                        via.viaCreated = true;
                        pinName = via.mName;
                        PinTemplate viaPin = PinTemplate.create((Net)net, (String)pinName);
                        viaPin.setPadTemplate(viaRec.mPadTemplate);
                        viaPin.setType(PinTemplate.Type.VIA);
                        viaPin.setLoc(new APoint2D(node.mPoint));
                        PinInstance viaPinInst = new PinInstance(pinName, device, viaPin);
                        this.mDb.add((DbObject)viaPinInst);
                        via.viaPinTemplate = viaPin;
                    }
                    if (via.mName != null && !via.mName.isEmpty()) {
                        pinName = via.mName.split("\\::")[0];
                    }
                }
            }
            PinTemplate pinTemplate = PinTemplate.create((Net)net, (String)(node.isPin() ? node.mPinName : pinName));
            pinTemplate.setPadTemplate(padTemplate);
            pinTemplate.setRotate(node.mAbsoluteRotation);
            PinInstance dp = new PinInstance(pinTemplate.getName(), device, pinTemplate);
            this.mDb.add((DbObject)dp);
            pinTemplate.setLoc(new APoint2D(node.mPoint));
            pinTemplate.setType(pinType);
            if (viaBallSize) {
                via.viaPinTemplate = pinTemplate;
            }
            this.mNode2Pin.put(node, pinTemplate);
        }
        if (nodeCnt == 0) {
            bound = new ARect(0L, 0L, 0L, 0L);
        }
        if (!pkgFlag) {
            device.setLoc(bound.getLL());
            dt.setBounds((AGeom)new ARect(0L, 0L, bound.width(), bound.height()));
            for (PinInstance p : device.getPins()) {
                PinTemplate dtp = p.getPinTemplate();
                APoint2D loc = dtp.getLoc();
                loc.moveBy(this.mOffsetOrigin.getX() - bound.getLL().getX(), this.mOffsetOrigin.getY() - bound.getLL().getY());
                dtp.setLoc(loc);
            }
        } else {
            dt.setBounds(bound);
        }
    }

    protected void createViaPadTemplates(SpdPackage pkgSection, HashMap<String, SpdVia> map) {
        for (String key : map.keySet()) {
            SpdPadStackDef padStackDef;
            SpdVia via = map.get(key);
            if (via == null || via.mPadStack == null || via.mPadStack.isEmpty() || (padStackDef = this.getSpdSection(pkgSection, SpdPadStackDef.class, via.mPadStack)) == null) continue;
            Object newName = via.mPadStack;
            int i = 0;
            while (PadTemplate.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)newName) != null) {
                newName = via.mPadStack + i++;
            }
            PadTemplate padTemplate = PadTemplate.create((Db)this.mDb, (Substrate)this.mSubstrate, (String)newName);
            boolean validPadTemplate = false;
            Iterator itrPadDef = padStackDef.getSubSection(SpdPadDef.class);
            while (itrPadDef != null && itrPadDef.hasNext()) {
                SpdPadDef padDef = (SpdPadDef)itrPadDef.next();
                if (padDef.mLayerName.toLowerCase().contains("defaultliblayer")) {
                    Iterator itrLayer = pkgSection.getSubSection(SpdLayer.class);
                    ArrayList<SpdLayer> listLayer = new ArrayList<SpdLayer>();
                    while (itrLayer != null && itrLayer.hasNext()) {
                        listLayer.add((SpdLayer)itrLayer.next());
                    }
                    Collections.sort(listLayer);
                    for (SpdLayer ls : listLayer) {
                        Layer layer = Layer.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)ls.mName);
                        if (layer == null) continue;
                        Iterator itrPad = padDef.getSubSection(SpdPad.class);
                        while (itrPad != null && itrPad.hasNext()) {
                            SpdPad pad = (SpdPad)itrPad.next();
                            if (padTemplate.getLayerShapes(layer).hasNext()) continue;
                            LayerShape.create((Db)this.mDb, (Layer)layer, (DbObject)padTemplate, (AGeom)pad.mGeom);
                            validPadTemplate = true;
                        }
                    }
                    break;
                }
                Iterator itrPad = padDef.getSubSection(SpdPad.class);
                Layer layer = Layer.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)padDef.mLayerName);
                if (layer == null) continue;
                while (itrPad != null && itrPad.hasNext()) {
                    SpdPad pad = (SpdPad)itrPad.next();
                    if (padTemplate.getLayerShapes(layer) != null) {
                        padTemplate.removeLayerShapes(layer);
                    }
                    LayerShape.create((Db)this.mDb, (Layer)layer, (DbObject)padTemplate, (AGeom)pad.mGeom);
                    validPadTemplate = true;
                }
            }
            if (validPadTemplate) {
                via.mPadTemplate = padTemplate;
                continue;
            }
            padTemplate.deleteFromDb();
        }
    }

    protected void createWires(SpdPackage pkgSection, SpdSection section, Device device) {
        Iterator itrTrace = section.getSubSection(SpdTrace.class);
        while (itrTrace != null && itrTrace.hasNext()) {
            MutableInteger count;
            SpdTrace trace = (SpdTrace)itrTrace.next();
            if (trace.mStartNode == null || trace.mEndNode == null) continue;
            SpdNode nodeStart = section.getSubSection(SpdNode.class, trace.mStartNode);
            SpdNode nodeEnd = section.getSubSection(SpdNode.class, trace.mEndNode);
            assert (nodeStart.mLayerName.equals(nodeEnd.mLayerName));
            APath path = new APath(trace.mWidth, new APoint2D[]{nodeStart.mPoint, nodeEnd.mPoint});
            Layer l = this.mSubstrate.getLayer(nodeStart.mLayerName);
            Net net = this.createNet(device, trace.mNetName);
            Wire wire = new Wire(net, l, path);
            this.mDb.add((DbObject)wire);
            this.mWire2StartNode.put(wire, nodeStart);
            this.mWire2EndNode.put(wire, nodeEnd);
            this.mNode2Wires.put((Object)nodeStart, (Object)wire);
            this.mNode2Wires.put((Object)nodeEnd, (Object)wire);
            if (this.mStartNodes.containsKey(nodeStart)) {
                count = this.mStartNodes.get(nodeStart);
                count.add(1);
            } else {
                this.mStartNodes.put(nodeStart, new MutableInteger(1));
            }
            if (this.mEndNodes.containsKey(nodeEnd)) {
                count = this.mEndNodes.get(nodeEnd);
                count.add(1);
            } else {
                this.mEndNodes.put(nodeEnd, new MutableInteger(1));
            }
            LinkedHashMultimap layer2Wire = this.mNetLayer2Wires.computeIfAbsent(net, n -> LinkedHashMultimap.create());
            layer2Wire.put((Object)l, (Object)wire);
        }
    }

    protected void createMetal(SpdPackage pkgSection, SpdSection section, Device device) {
        Substrate s = device.getSubstrate();
        Iterator itrShape = section.getSubSection(SpdShape.class);
        while (itrShape != null && itrShape.hasNext()) {
            SpdShape shape = (SpdShape)itrShape.next();
            String layerName = shape.mName;
            Layer layer = s.getLayer(layerName);
            if (layer == null) {
                layer = Layer.create((Substrate)s, (String)layerName);
            }
            Iterator<SpdShapeGeom> itr = shape.mShapeGeoms.iterator();
            boolean lastFilled = false;
            Object lastGeom = null;
            Net lastNet = null;
            while (itr != null && itr.hasNext()) {
                ACompositeGeom cutout;
                SpdShapeGeom spdGeom = itr.next();
                boolean f = spdGeom.mFilled;
                AGeom g = spdGeom.mGeom;
                Net n = this.createNet(device, spdGeom.mNetName);
                CreateMetalStatus status = lastGeom == null ? CreateMetalStatus.None : (f ? CreateMetalStatus.Metal : (lastFilled ? CreateMetalStatus.AGeomWithCutouts : (lastGeom.getClass() == AGeomWithCutouts.class ? CreateMetalStatus.AddCutout : CreateMetalStatus.Metal)));
                if (status == CreateMetalStatus.None) {
                    lastFilled = f;
                    lastGeom = g;
                    lastNet = n;
                    continue;
                }
                if (status == CreateMetalStatus.Metal) {
                    Metal.create((Net)lastNet, (Layer)layer, (AGeom)lastGeom);
                    lastFilled = f;
                    lastGeom = g;
                    lastNet = n;
                    continue;
                }
                if (status == CreateMetalStatus.AGeomWithCutouts) {
                    cutout = new ACompositeGeom();
                    cutout.addChild(g);
                    lastGeom = new AGeomWithCutouts((AGeom)lastGeom, (AGeom)cutout);
                    lastFilled = f;
                    continue;
                }
                if (status != CreateMetalStatus.AddCutout) continue;
                cutout = (ACompositeGeom)((AGeomWithCutouts)lastGeom).getCutout();
                cutout.addChild(g);
                lastFilled = f;
            }
            if (lastGeom == null) continue;
            Metal.create(lastNet, (Layer)layer, lastGeom);
        }
    }

    protected void createDb() {
        SpdPackage pkgSection = this.getPackageSection();
        if (pkgSection == null) {
            return;
        }
        this.mDb.setHistoryEnabled(false);
        this.mDb.setListenersEnabled(false);
        if (this.mSubstrate == null) {
            this.createSubstrate(pkgSection);
        }
        this.createLayers(pkgSection);
        this.createViaPadTemplates(pkgSection, this.viaTable);
        this.createComponents(pkgSection);
        this.processWireNodes(pkgSection, this.mWire2StartNode, true);
        this.processWireNodes(pkgSection, this.mWire2EndNode, false);
        if (MergeWires) {
            this.mergeWires(this.mNetLayer2Wires);
        }
        this.mDb.setListenersEnabled(true);
        this.mDb.setHistoryEnabled(true);
    }

    protected void removeUnplacedDevices() {
        if (!this.unplacedDevices.isEmpty()) {
            ALog.logWarn((String)"%d devices removed as they appear to be unplaced", (Object[])new Object[]{this.unplacedDevices.size()});
            for (Device d : this.unplacedDevices) {
                DeviceTemplate dt = d.getTemplate();
                d.deleteFromDb();
                if (dt == null) continue;
                dt.deleteFromDb();
            }
        }
    }

    protected Device createCircuit(SpdPackage pkgSection, SpdSection section) {
        String tplName;
        String devName;
        Design tplParent;
        boolean pkgFlag = section == pkgSection;
        Object object = tplParent = pkgFlag ? this.mDbDesign : this.mRootDevice.getTemplate();
        if (pkgFlag) {
            tplName = devName = Device.getUniqueName((DeviceTemplate)tplParent, (String)this.mRootDeviceName);
        } else {
            assert (section instanceof SpdConnect);
            tplName = ((SpdConnect)SpdConnect.class.cast((Object)section)).mPartialName;
            devName = Device.getUniqueName((DeviceTemplate)tplParent, (String)section.mName);
        }
        DeviceTemplate dt = this.createDeviceTemplate(tplName);
        dt.setSubstrate(this.mSubstrate);
        dt.setIsSynthesized(false);
        dt.setType(pkgFlag ? this.mTemplateType : DeviceTemplate.Type.PACKAGEDDIE);
        this.mDb.add((DbObject)dt);
        Device device = new Device(devName, (DeviceTemplate)tplParent, dt);
        device.setLoc(new APoint2D(0L, 0L));
        device.setIsPlaced(true);
        device.setSynthesized(false);
        this.mDb.add((DbObject)device);
        if (pkgFlag) {
            this.mRootDevice = device;
        }
        this.createPorts(pkgSection, section, device);
        if (dt.getBounds() == null || dt.getBounds().getArea() == 0.0) {
            this.unplacedDevices.add(device);
        }
        if (this.mReadTrace) {
            this.createWires(pkgSection, section, device);
        }
        this.createMetal(pkgSection, section, device);
        return device;
    }

    protected SpdPackage getPackageSection() {
        Iterator itr = this.mDesignSection.getSubSection(SpdPackage.class);
        if (itr == null || !itr.hasNext()) {
            return null;
        }
        return (SpdPackage)itr.next();
    }

    protected ArrayList<SpdNode> getComponentNodes(SpdPackage pkgSection, SpdConnect connSection) {
        ArrayList<SpdNode> nodes = new ArrayList<SpdNode>();
        Iterator itr = connSection.getSubSection(SpdConnectItem.class);
        while (itr != null && itr.hasNext()) {
            SpdNode node;
            SpdConnectItem item = (SpdConnectItem)itr.next();
            if (item.mPkgName != null && !item.mPkgName.equalsIgnoreCase(pkgSection.mName) || (node = pkgSection.getSubSection(SpdNode.class, item.mPkgNode)) == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    protected SpdConnect getSectionOfPin(String pinName, SpdPackage pkg) {
        Iterator itr = this.mDesignSection.getSubSection(SpdConnect.class);
        while (itr != null && itr.hasNext()) {
            SpdConnect connect = (SpdConnect)itr.next();
            if (connect.getSubSection(SpdConnectItem.class, pinName) == null) continue;
            return connect;
        }
        return null;
    }

    protected Net createNet(Device device, String name) {
        Net net = null;
        DeviceTemplate template = device.getTemplate();
        if (name == null || name.isEmpty()) {
            name = "NetUnused";
        }
        if ((net = template.getNet(name)) == null) {
            net = Net.create((DeviceTemplate)template, (String)name);
        }
        if (this.mRootDevice != device && net != null && !net.isUnused() && NetMap.getParentNet((Device)device, (Net)net) == null) {
            Net netRoot = Net.getOrCreate((DeviceTemplate)this.mRootDevice.getTemplate(), (String)name);
            NetMap.mapChildNet((Device)device, (Net)net, (Net)netRoot);
        }
        return net;
    }

    protected void processWireNodes(SpdPackage pkgSection, HashMap<Wire, SpdNode> map, boolean startNodes) {
        HashMap<String, SpdVia> vias = this.mNode2Via.get(pkgSection);
        for (Map.Entry<Wire, SpdNode> entry : map.entrySet()) {
            long wireEndId;
            int numTimesEndNode;
            SpdNode node = entry.getValue();
            Wire wire = entry.getKey();
            PinTemplate pin = this.mNode2Pin.get(node);
            if (pin != null) {
                StoredPath pinSP;
                SpdVia via;
                if (pin.getType() == PinTemplate.Type.VIA && vias != null && (via = vias.get(node.mName.toLowerCase())) != null) {
                    PinTemplate pt;
                    SpdNode spdNode;
                    String nodeName = null;
                    if (node.mName.equals(via.mUpperNode)) {
                        nodeName = via.mLowerNode;
                    } else if (node.mName.equals(via.mLowerNode)) {
                        nodeName = via.mUpperNode;
                    }
                    if (nodeName != null && !nodeName.isEmpty() && (spdNode = pkgSection.getSubSection(SpdNode.class, nodeName)) != null && (pt = this.mNode2Pin.get(spdNode)) != null) {
                        pin = pt;
                    }
                }
                if (pin.getDeviceTemplate() == this.mRootDevice.getTemplate()) {
                    pinSP = StoredPath.get((DeviceTemplate)this.mRootDevice.getTemplate());
                } else {
                    LinkedList pinDevs = AUtil.linkedList((Iterator)pin.getDeviceTemplate().getDeviceInstances());
                    assert (pinDevs.size() == 1);
                    pinSP = StoredPath.get((Device[])new Device[]{(Device)pinDevs.get(0)});
                }
                if (startNodes) {
                    wire.setPinA(pinSP, pin);
                    continue;
                }
                wire.setPinB(pinSP, pin);
                continue;
            }
            int numWiresThruNode = this.mNode2Wires.get((Object)node).size();
            int numTimesStartNode = this.mStartNodes.get(node) != null ? this.mStartNodes.get(node).getValue() : 0;
            int n = numTimesEndNode = this.mEndNodes.get(node) != null ? this.mEndNodes.get(node).getValue() : 0;
            if (numWiresThruNode == 2 && (numWiresThruNode < 2 || numTimesStartNode < 2 && numTimesEndNode < 2)) continue;
            PadTemplate padT = null;
            ++this.mNextWireEndId;
            pin = PinTemplate.create((Net)wire.getNet(), (String)("WireEnd" + wireEndId));
            pin.setType(PinTemplate.Type.WIREEND);
            long wireWidth = wire.getWidth();
            HashMap<String, Object> width2PadTemplate = this.mWidthLayerName2PadStack.get(wireWidth);
            if (width2PadTemplate != null) {
                padT = width2PadTemplate.get(wire.getLayer().getName());
            }
            if (padT == null) {
                padT = PadTemplate.create((Db)this.mDb, (Substrate)wire.getLayer().getSubstrate(), (String)("WireEnd" + wireWidth / Design.getInternalPerMicron((Db)this.mDb)));
                LayerShape.create((Db)this.mDb, (Layer)wire.getLayer(), (DbObject)padT, (AGeom)new ACircle(new APoint2D(), wire.getWidth() / 2L));
                width2PadTemplate = new HashMap();
                this.mWidthLayerName2PadStack.put(wireWidth, width2PadTemplate);
                width2PadTemplate.put(wire.getLayer().getName(), padT);
            }
            pin.setPadTemplate(padT);
            pin.setLoc(node.mPoint);
            if (startNodes) {
                wire.setPinA(StoredPath.get((DeviceTemplate)pin.getDeviceTemplate()), pin);
                pin.setLoc(wire.getPath().getFirstPoint());
            } else {
                wire.setPinB(StoredPath.get((DeviceTemplate)pin.getDeviceTemplate()), pin);
                pin.setLoc(wire.getPath().getLastPoint());
            }
            pin.createPinInstances();
        }
    }

    public static void checkWires(Db db) {
        for (Wire w : AUtil.linkedList((Iterator)db.getObjects(Wire.class))) {
            if (w.getPinA() != null && w.getPinB() != null) continue;
            ALog.logInfo((String)(" wire " + w.getKeyStr() + " " + w.getNet().asString() + " " + w.getPath().getAsStringArg()));
        }
    }

    protected void mergeWires(HashMap<Net, LinkedHashMultimap<Layer, Wire>> map) {
        map.values().forEach(layer2Wires -> layer2Wires.asMap().values().forEach(this::mergeWires));
    }

    protected void mergeWires(Collection<Wire> wires) {
        LinkedList<Wire> startWires = new LinkedList<Wire>();
        HashMultimap startPt2ContWires = HashMultimap.create();
        for (Wire wire : wires) {
            if (wire.getPinA() != null && wire.getPinB() == null) {
                startWires.add(wire);
                continue;
            }
            if (wire.getPinA() != null || wire.getPath().getPointCount() <= 0) continue;
            startPt2ContWires.put((Object)wire.getPath().getFirstPoint(), (Object)wire);
        }
        this.mergeWires(startWires, (Multimap<APoint2D, Wire>)startPt2ContWires);
    }

    protected void mergeWires(List<Wire> startWires, Multimap<APoint2D, Wire> startPt2ContWires) {
        Collections.sort(startWires);
        LinkedList<Wire> newStartWires = new LinkedList<Wire>();
        for (Wire startWire : startWires) {
            boolean extendedWire = true;
            while (extendedWire) {
                APoint2D startPt = startWire.getPath().getLastPoint();
                Stream continuationWires = startPt2ContWires.get((Object)startPt).stream();
                Map<Boolean, List<Wire>> wiresMatchingWidth = continuationWires.collect(Collectors.partitioningBy(wire -> wire.getWidth() == startWire.getWidth()));
                wiresMatchingWidth.get(false).forEach(wire -> {
                    newStartWires.add((Wire)wire);
                    startPt2ContWires.remove((Object)wire.getPath().getFirstPoint(), wire);
                });
                Optional next = wiresMatchingWidth.get(true).stream().reduce((a, b) -> a.getLength() >= b.getLength() ? a : b);
                if (next.isPresent()) {
                    Wire cont = (Wire)next.get();
                    startPt2ContWires.remove((Object)cont.getPath().getFirstPoint(), (Object)cont);
                    APath nextPath = cont.getPath();
                    nextPath.removeFirst();
                    startWire.getPath().addAll(nextPath);
                    if (cont.getPinB() != null) {
                        startWire.setPinB(cont.getPinB());
                    }
                    cont.deleteFromDb();
                    continue;
                }
                extendedWire = false;
            }
        }
        if (!newStartWires.isEmpty()) {
            this.mergeWires(newStartWires, startPt2ContWires);
        }
    }

    protected class SpdConnectItem
    extends SpdSection {
        protected String mPtlNode;
        protected String mPkgName;
        protected String mPkgNode;

        public SpdConnectItem(SpdSection parent, String key) {
            super(parent, key);
            this.mPtlNode = SpdDBProcessor.this.correctName(key);
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            this.mPkgNode = SpdDBProcessor.this.mReader.nextToken();
            int n = this.mPkgNode.indexOf(46);
            if (n >= 0) {
                this.mPkgName = SpdDBProcessor.this.correctName(this.mPkgNode.substring(0, n));
                this.mName = this.mPkgNode = SpdDBProcessor.this.correctName(this.mPkgNode.substring(n + 1));
            } else {
                this.mName = this.mPkgNode = SpdDBProcessor.this.correctName(this.mPkgNode);
            }
        }
    }

    protected class SpdConnect
    extends SpdSection {
        protected String mPartialName;

        public SpdConnect(SpdSection parent, String key) {
            super(parent, key);
            this.addSectionHandler(new SectionDef("", SpdDBProcessor.this.mReader.newLineString(), SpdConnectItem.class));
        }

        public SpdConnectItem getConnectItem(String pkgName, String nodeName) {
            Iterator itr = this.getSubSection(SpdConnectItem.class);
            while (itr != null && itr.hasNext()) {
                SpdConnectItem item = (SpdConnectItem)itr.next();
                if (!item.mPkgName.equalsIgnoreCase(pkgName) || !item.mPkgNode.equalsIgnoreCase(nodeName)) continue;
                return item;
            }
            return null;
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            this.mName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
            this.mPartialName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
        }
    }

    protected class SpdPartialCkt
    extends SpdSection {
        public SpdPartialCkt(SpdSection parent, String key) {
            super(parent, key);
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            this.mName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
        }
    }

    protected class SpdPad
    extends SpdSection {
        protected AGeom mGeom;

        public SpdPad(SpdSection parent, String key) {
            super(parent, key);
            this.mGeom = null;
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            this.mName = "_pad_" + key + mKeyIndex++;
            String sGeom = SpdDBProcessor.this.mReader.nextToken();
            this.mGeom = SpdDBProcessor.this.mGeomParser.parse(sGeom, false);
            ARect bound = this.mGeom.getBounds();
            if (this.mGeom instanceof ARect) {
                long w = bound.width() / 2L;
                long h = bound.height() / 2L;
                this.mGeom.moveBy(-w, -h);
            }
        }
    }

    protected class SpdPadDef
    extends SpdSection {
        protected String mLayerName;

        public SpdPadDef(SpdSection parent, String key) {
            super(parent, key);
            this.addSectionHandler(new SectionDef("^regular$", SpdDBProcessor.this.mReader.newLineString(), SpdPad.class));
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            this.mLayerName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
            this.mLayerName = SpdDBProcessor.this.correctLayerName(this.mLayerName);
            this.mName = "_paddef_" + this.mLayerName.toLowerCase();
        }
    }

    protected class SpdPadStackDef
    extends SpdSection {
        protected ARect mBound;

        public SpdPadStackDef(SpdSection parent, String key) {
            super(parent, key);
            this.mBound = null;
            this.addSectionHandler(new SectionDef("^\\.paddef$", "^\\.endpaddef$", SpdPadDef.class));
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            this.mName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
        }
    }

    protected class SpdTrace
    extends SpdSection {
        protected String mNetName;
        protected String mStartNode;
        protected String mEndNode;
        protected long mWidth;

        public SpdTrace(SpdSection parent, String key) {
            super(parent, key);
            this.mWidth = Design.micronToInternal((Db)SpdDBProcessor.this.mDb, (double)100.0);
            ArrayList<String> ss = SpdDBProcessor.this.parseTokens(key, new String[]{"::"});
            this.mNetName = SpdDBProcessor.this.correctName(ss.get(1));
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            String s = SpdDBProcessor.this.mReader.nextToken();
            while (s != null && !s.equalsIgnoreCase(SpdDBProcessor.this.mReader.newLineString())) {
                if (s.equalsIgnoreCase("startingnode") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mStartNode = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                } else if (s.equalsIgnoreCase("endingnode") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mEndNode = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                } else if (s.equalsIgnoreCase("width") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mWidth = (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(SpdDBProcessor.this.mReader.nextToken(), SpdDBProcessor.DEFAULT_LENGTH_UNIT);
                }
                s = SpdDBProcessor.this.mReader.nextToken();
            }
        }
    }

    protected class SpdVia
    extends SpdSection {
        protected String mNetName;
        protected String mUpperNode;
        protected String mLowerNode;
        protected float mAbsoluteRotation;
        protected double mConductivity;
        protected String mPadStack;
        protected String mColor;
        protected PadTemplate mPadTemplate;
        boolean viaCreated;
        PinTemplate viaPinTemplate;

        public SpdVia(SpdSection parent, String key) {
            super(parent, key);
            this.mAbsoluteRotation = 0.0f;
            this.mConductivity = 5.8E7;
            this.mPadTemplate = null;
            this.viaCreated = false;
            this.viaPinTemplate = null;
            ArrayList<String> ss = SpdDBProcessor.this.parseTokens(key, new String[]{"::"});
            this.mNetName = SpdDBProcessor.this.correctName(ss.get(1));
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            String s = SpdDBProcessor.this.mReader.nextToken();
            while (s != null && !s.equalsIgnoreCase(SpdDBProcessor.this.mReader.newLineString())) {
                if (s.equalsIgnoreCase("UpperNode") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mUpperNode = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                } else if (s.equalsIgnoreCase("LowerNode") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mLowerNode = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                } else if (s.equalsIgnoreCase("Conductivity") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mConductivity = Double.parseDouble(SpdDBProcessor.this.mReader.nextToken());
                } else if (s.equalsIgnoreCase("Color") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mColor = SpdDBProcessor.this.mReader.nextToken();
                } else if (s.equalsIgnoreCase("Padstack") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mPadStack = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                } else if (s.equalsIgnoreCase("[AbsoluteRotation") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mAbsoluteRotation = -Float.parseFloat(SpdDBProcessor.this.mReader.nextToken());
                }
                s = SpdDBProcessor.this.mReader.nextToken();
            }
        }

        @Override
        public void onEndSection() throws InvalidDataException {
            HashMap vias = SpdDBProcessor.this.mNode2Via.computeIfAbsent(this.mParent, s -> new HashMap());
            if (this.mUpperNode != null && !this.mUpperNode.isEmpty()) {
                vias.put(this.mUpperNode.toLowerCase(), this);
            }
            if (this.mLowerNode != null && !this.mLowerNode.isEmpty()) {
                vias.put(this.mLowerNode.toLowerCase(), this);
            }
            SpdDBProcessor.this.viaTable.put(this.mPadStack, this);
        }
    }

    protected class SpdNode
    extends SpdSection {
        protected String mPinName;
        protected String mNetName;
        protected APoint2D mPoint;
        protected String mLayerName;
        protected String mPadStackName;
        protected float mAbsoluteRotation;

        public SpdNode(SpdSection parent, String key) {
            super(parent, key);
            this.mPinName = null;
            this.mNetName = null;
            this.mAbsoluteRotation = 0.0f;
            ArrayList<String> ss = SpdDBProcessor.this.parseTokens(key, new String[]{"!!", "::"});
            this.mPinName = SpdDBProcessor.this.correctName(ss.get(1));
            this.mNetName = SpdDBProcessor.this.correctName(ss.get(2));
        }

        public boolean isPin() {
            return this.mPinName != null && !this.mPinName.isEmpty();
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            String x = "";
            String y = "";
            String s = SpdDBProcessor.this.mReader.nextToken();
            while (s != null && !s.equalsIgnoreCase(SpdDBProcessor.this.mReader.newLineString())) {
                if (s.equalsIgnoreCase("x") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    x = SpdDBProcessor.this.mReader.nextToken();
                } else if (s.equalsIgnoreCase("y") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    y = SpdDBProcessor.this.mReader.nextToken();
                } else if (s.equalsIgnoreCase("layer") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mLayerName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                    this.mLayerName = SpdDBProcessor.this.correctLayerName(this.mLayerName);
                } else if (s.equalsIgnoreCase("padstack") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mPadStackName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                } else if (s.equalsIgnoreCase("AbsoluteRotation") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mAbsoluteRotation = -Float.parseFloat(SpdDBProcessor.this.mReader.nextToken());
                }
                s = SpdDBProcessor.this.mReader.nextToken();
            }
            this.mPoint = new APoint2D((long)SpdDBProcessor.this.mInternalUnit.spdToInternal(x, SpdDBProcessor.DEFAULT_LENGTH_UNIT), (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(y, SpdDBProcessor.DEFAULT_LENGTH_UNIT));
        }
    }

    protected class SpdLayer
    extends SpdSection
    implements Comparable<SpdLayer> {
        protected Layer.LayerType mType;
        protected double mThickness;
        protected double mWidth;
        protected String mShape;
        protected int mOrder;

        public SpdLayer(SpdSection parent, String key) {
            super(parent, key);
            this.mType = Layer.LayerType.Unknown;
            this.mThickness = 0.0;
            this.mWidth = 0.0;
            this.mShape = null;
            this.mOrder = -1;
            if (this.mName.matches("^[Pp]lane_.*")) {
                this.mType = Layer.LayerType.Route;
            } else if (this.mName.matches("^[Ss]hape_.*") || this.mName.matches("^[Ss]ignal_.*")) {
                this.mType = Layer.LayerType.Signal;
            } else if (this.mName.matches("^[Mm]edium_.*")) {
                this.mType = Layer.LayerType.Dielectric;
            }
            this.mName = SpdDBProcessor.this.correctLayerName(this.mName);
            this.mOrder = SpdDBProcessor.this.mLayerOrder++;
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            String t = SpdDBProcessor.this.mReader.nextToken();
            while (t != null && !t.equalsIgnoreCase(SpdDBProcessor.this.mReader.newLineString())) {
                if (t.equalsIgnoreCase("thickness") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mThickness = SpdDBProcessor.this.mInternalUnit.spdToInternal(SpdDBProcessor.this.mReader.nextToken(), SpdDBProcessor.DEFAULT_LENGTH_UNIT);
                } else if (t.equalsIgnoreCase("width") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mWidth = SpdDBProcessor.this.mInternalUnit.spdToInternal(SpdDBProcessor.this.mReader.nextToken(), SpdDBProcessor.DEFAULT_LENGTH_UNIT);
                } else if (t.equalsIgnoreCase("shape") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                    this.mShape = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                }
                t = SpdDBProcessor.this.mReader.nextToken();
            }
        }

        @Override
        public int compareTo(SpdLayer o) {
            return this.mOrder - o.mOrder;
        }
    }

    protected class SpdShapeGeom
    extends SpdSection {
        protected String mNetName;
        protected AGeom mGeom;
        protected boolean mFilled;

        public SpdShapeGeom(SpdSection parent, String key) {
            super(parent, key);
            this.mGeom = null;
            this.mFilled = true;
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            int i;
            ArrayList<String> ss = SpdDBProcessor.this.parseTokens(key, new String[]{"::"});
            if (ss.size() != 2) {
                throw new InvalidDataException("Unexpected tokens");
            }
            String next = SpdDBProcessor.this.mReader.nextToken();
            if (next.equalsIgnoreCase("color")) {
                SpdDBProcessor.this.mReader.skipTokens(2);
            } else {
                SpdDBProcessor.this.mReader.pushbackToken(next);
            }
            this.mNetName = ss.get(1);
            this.mFilled = !this.mNetName.matches(".*-$");
            this.mNetName = this.mNetName.replaceFirst("\\+$", "");
            this.mNetName = this.mNetName.replaceFirst("-$", "");
            this.mNetName = SpdDBProcessor.this.correctName(this.mNetName);
            String[] t = new String[]{"polygon", "box", "circle"};
            for (i = 0; i < t.length; ++i) {
                if (!this.mName.toLowerCase().startsWith(t[i])) continue;
                this.mGeom = SpdDBProcessor.this.mGeomParser.parse(t[i], true);
                break;
            }
            if (i >= t.length) {
                throw new InvalidDataException("Unexpected tokens");
            }
            ((SpdShape)this.mParent).mShapeGeoms.add(this);
        }
    }

    protected class SpdShape
    extends SpdSection {
        protected ArrayList<SpdShapeGeom> mShapeGeoms;

        public SpdShape(SpdSection parent, String key) {
            super(parent, key);
            this.mShapeGeoms = new ArrayList();
            this.addSectionHandler(new SectionDef("^polygon.*", SpdDBProcessor.this.mReader.newLineString(), SpdShapeGeom.class));
            this.addSectionHandler(new SectionDef("^circle.*", SpdDBProcessor.this.mReader.newLineString(), SpdShapeGeom.class));
            this.addSectionHandler(new SectionDef("^box.*", SpdDBProcessor.this.mReader.newLineString(), SpdShapeGeom.class));
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            this.mName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
            this.mName = SpdDBProcessor.this.correctLayerName(this.mName);
        }
    }

    protected class SpdPackage
    extends SpdSection {
        public SpdPackage(SpdSection parent, String key) {
            super(parent, key);
            SpdDBProcessor.this.mLayerOrder = 0;
            if (SpdDBProcessor.this.mReadShape) {
                this.addSectionHandler(new SectionDef("^\\.shape$", "^\\.endshape$", SpdShape.class));
            }
            this.addSectionHandler(new SectionDef("^plane.*", SpdDBProcessor.this.mReader.newLineString(), SpdLayer.class));
            this.addSectionHandler(new SectionDef("^shape.*", SpdDBProcessor.this.mReader.newLineString(), SpdLayer.class));
            this.addSectionHandler(new SectionDef("^signal.*", SpdDBProcessor.this.mReader.newLineString(), SpdLayer.class));
            this.addSectionHandler(new SectionDef("^medium.*", SpdDBProcessor.this.mReader.newLineString(), SpdLayer.class));
            this.addSectionHandler(new SectionDef("^node.*", SpdDBProcessor.this.mReader.newLineString(), SpdNode.class));
            this.addSectionHandler(new SectionDef("^via.*", SpdDBProcessor.this.mReader.newLineString(), SpdVia.class));
            if (SpdDBProcessor.this.mReadTrace) {
                this.addSectionHandler(new SectionDef("^trace.*", SpdDBProcessor.this.mReader.newLineString(), SpdTrace.class));
            }
            this.addSectionHandler(new SectionDef("^\\.padstackdef$", "^\\.endpadstackdef$", SpdPadStackDef.class));
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            this.mName = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
        }

        @Override
        public boolean onUnHandleSection(String key, SpdSection parent) throws InvalidDataException {
            if (key.toLowerCase().startsWith("patch")) {
                String shape = null;
                String layer = null;
                String s = SpdDBProcessor.this.mReader.nextToken();
                while (s != null && !s.equalsIgnoreCase(SpdDBProcessor.this.mReader.newLineString())) {
                    if (s.equalsIgnoreCase("shape") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                        shape = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                    } else if (s.equalsIgnoreCase("layer") && SpdDBProcessor.this.mReader.nextToken().equals("=")) {
                        layer = SpdDBProcessor.this.correctName(SpdDBProcessor.this.mReader.nextToken());
                    }
                    s = SpdDBProcessor.this.mReader.nextToken();
                }
                if (shape != null && layer != null) {
                    SpdLayer spd = this.getSubSection(SpdLayer.class, layer);
                    spd.mShape = shape;
                }
            }
            return true;
        }
    }

    protected class SpdDesign
    extends SpdSection {
        protected String mTitle;

        public SpdDesign(SpdSection parent, String key) {
            super(parent, key);
            this.mTitle = "";
            this.addSectionHandler(new SectionDef("^\\.package$", "^\\.endpackage$", SpdPackage.class));
            this.addSectionHandler(new SectionDef("^\\.partialckt$", "^\\.endpartialckt$", SpdPartialCkt.class));
            this.addSectionHandler(new SectionDef("^\\.connect$", "^\\.endc$", SpdConnect.class));
        }

        @Override
        protected void parseProperty(String key) throws InvalidDataException {
            String s = SpdDBProcessor.this.mReader.nextToken();
            while (s != null && !s.equalsIgnoreCase(SpdDBProcessor.this.mReader.newLineString())) {
                this.mTitle = this.mTitle + s;
                s = SpdDBProcessor.this.mReader.nextToken();
            }
        }
    }

    protected abstract class SpdSection
    implements parser {
        protected String mName;
        protected SpdSection mParent = null;
        protected SectionDef mSectionDef = SectionDef.NONE_SECTIONDEF;
        protected ArrayList<SectionDef> mSubSectionDefs = new ArrayList();
        protected HashMap<Class<?>, HashMap<String, SpdSection>> mSubSections = new HashMap();

        public SpdSection(SpdSection parent, String key) {
            this.mParent = parent;
            this.mName = SpdDBProcessor.this.correctName(key);
        }

        protected abstract void parseProperty(String var1) throws InvalidDataException;

        public void addSectionHandler(SectionDef secDef) {
            this.mSubSectionDefs.add(secDef);
        }

        public SpdSection newSection(String key, SpdSection parent) throws InvalidDataException {
            SpdSection section = null;
            for (SectionDef def : this.mSubSectionDefs) {
                if (!this.isInterestedSection(def, key)) continue;
                Class<?> cls = def.mClass;
                try {
                    section = (SpdSection)cls.getDeclaredConstructor(SpdDBProcessor.class, SpdSection.class, String.class).newInstance(SpdDBProcessor.this, parent, key);
                    section.mSectionDef = def;
                    break;
                }
                catch (Exception e) {
                    String err = String.format("Failed to create the instance of %s : %s", cls.getName(), e.getMessage());
                    throw new InvalidDataException(err);
                }
            }
            return section;
        }

        public boolean onUnHandleSection(String key, SpdSection parent) throws InvalidDataException {
            return true;
        }

        public boolean onNewSubSection(SpdSection section) throws InvalidDataException {
            return true;
        }

        public void onEndSection() throws InvalidDataException {
        }

        public <T extends SpdSection> T getSubSection(Class<T> cls, String key) {
            HashMap<String, SpdSection> map = this.mSubSections.get(cls);
            if (map == null) {
                return null;
            }
            return (T)map.get(key.toLowerCase());
        }

        public <T extends SpdSection> Iterator<T> getSubSection(Class<?> cls) {
            HashMap<String, SpdSection> map = this.mSubSections.get(cls);
            if (map == null) {
                return null;
            }
            Iterator<SpdSection> res = map.values().iterator();
            return res;
        }

        @Override
        public Object parse(String key) throws InvalidDataException {
            this.parseProperty(key);
            if (!SpdDBProcessor.this.mReader.currentToken().equalsIgnoreCase(SpdDBProcessor.this.mReader.newLineString())) {
                SpdDBProcessor.this.mReader.skipLine();
            }
            SpdDBProcessor.this.mReader.pushbackToken(SpdDBProcessor.this.mReader.newLineString());
            String t = SpdDBProcessor.this.mReader.nextToken();
            while (t != null && !t.isEmpty()) {
                if (this.isEndSection(t)) {
                    this.onEndSection();
                    return this;
                }
                if (!t.equalsIgnoreCase(SpdDBProcessor.this.mReader.newLineString())) {
                    SpdSection section = this.newSection(t, this);
                    if (section == null) {
                        if (!this.onUnHandleSection(key, this)) break;
                        SpdDBProcessor.this.mReader.skipLine();
                    } else {
                        if (!this.onNewSubSection(section)) break;
                        try {
                            section.parse(t);
                            this.addSection(section);
                        }
                        catch (InvalidDataException e) {
                            ALog.logError((String)"%s (%d) : error : %s", (Object[])new Object[]{SpdDBProcessor.this.mReader.getSourceFile(), SpdDBProcessor.this.mReader.getCurrentLineID(), e.getMessage()});
                        }
                    }
                }
                t = SpdDBProcessor.this.mReader.nextToken();
            }
            this.onEndSection();
            return this;
        }

        protected boolean isEndSection(String key) {
            if (this.mSectionDef.mEndRegex == null) {
                return false;
            }
            key = key.toLowerCase();
            return this.mSectionDef.mEndRegex.matcher(key).matches();
        }

        protected boolean isInterestedSection(SectionDef def, String key) {
            if (def.mStartRegex == null) {
                return true;
            }
            key = key.toLowerCase();
            return def.mStartRegex.matcher(key).matches();
        }

        protected void addSection(SpdSection section) {
            HashMap<String, SpdSection> map = this.mSubSections.get(section.getClass());
            if (map == null) {
                map = new HashMap();
                this.mSubSections.put(section.getClass(), map);
            }
            map.put(section.mName.toLowerCase(), section);
        }

        protected void removeSection(SpdSection section) {
            HashMap<String, SpdSection> map = this.mSubSections.get(section.getClass());
            if (map != null) {
                map.remove(section.mName.toLowerCase());
            }
        }
    }

    protected static class SectionDef {
        protected String sKey;
        protected String eKey;
        protected Pattern mStartRegex = null;
        protected Pattern mEndRegex = null;
        protected Class<?> mClass = null;
        protected static final SectionDef NONE_SECTIONDEF = new SectionDef("", "", null);

        public SectionDef(String startRegex, String endRegex, Class<?> cls) {
            this.mClass = cls;
            if (startRegex != null && !startRegex.isEmpty()) {
                this.sKey = startRegex;
                this.mStartRegex = Pattern.compile(startRegex);
            }
            if (endRegex != null && !endRegex.isEmpty()) {
                this.eKey = endRegex;
                this.mEndRegex = Pattern.compile(endRegex);
            }
        }
    }

    protected class SpdGeomParser {
        protected SpdGeomParser() {
        }

        public AGeom parse(String type, boolean withCoordinate) throws InvalidDataException {
            APolygon geom = null;
            ArrayList<String> l = null;
            int i = 0;
            if ((type = type.toLowerCase()).equals("polygon")) {
                geom = new APolygon();
                while ((l = SpdDBProcessor.this.mReader.readTokens(2)) != null) {
                    try {
                        geom.addPoint((long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(0), SpdDBProcessor.DEFAULT_LENGTH_UNIT), (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(1), SpdDBProcessor.DEFAULT_LENGTH_UNIT));
                    }
                    catch (InvalidDataException e) {
                        SpdDBProcessor.this.mReader.pushbackToken(l.get(0));
                        SpdDBProcessor.this.mReader.pushbackToken(l.get(1));
                        break;
                    }
                }
            } else if (type.equals("circle")) {
                geom = new ACircle();
                if (withCoordinate) {
                    l = SpdDBProcessor.this.mReader.readTokens(3);
                    ((ACircle)geom).setCenter((long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(i++), SpdDBProcessor.DEFAULT_LENGTH_UNIT), (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(i++), SpdDBProcessor.DEFAULT_LENGTH_UNIT));
                } else {
                    l = SpdDBProcessor.this.mReader.readTokens(1);
                }
                ((ACircle)geom).setR((long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(i), SpdDBProcessor.DEFAULT_LENGTH_UNIT));
            } else if (type.equals("box")) {
                geom = new ARect();
                long x = 0L;
                long y = 0L;
                if (withCoordinate) {
                    l = SpdDBProcessor.this.mReader.readTokens(4);
                    x = (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(i++), SpdDBProcessor.DEFAULT_LENGTH_UNIT);
                    y = (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(i++), SpdDBProcessor.DEFAULT_LENGTH_UNIT);
                } else {
                    l = SpdDBProcessor.this.mReader.readTokens(2);
                }
                ((ARect)geom).setLL(x, y);
                ((ARect)geom).setUR(x + (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(i++), SpdDBProcessor.DEFAULT_LENGTH_UNIT), y + (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(i), SpdDBProcessor.DEFAULT_LENGTH_UNIT));
            } else if (type.equals("square")) {
                assert (!withCoordinate);
                geom = new ARect();
                l = SpdDBProcessor.this.mReader.readTokens(1);
                long w = (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(i), SpdDBProcessor.DEFAULT_LENGTH_UNIT);
                ((ARect)geom).setLL(0L, 0L);
                ((ARect)geom).setUR(w, w);
            } else if (type.equals("roundedrect_x") || type.equals("roundedrect_y")) {
                assert (!withCoordinate);
                geom = new ARect();
                l = SpdDBProcessor.this.mReader.readTokens(2);
                ((ARect)geom).setLL(0L, 0L);
                ((ARect)geom).setUR((long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(0), SpdDBProcessor.DEFAULT_LENGTH_UNIT), (long)SpdDBProcessor.this.mInternalUnit.spdToInternal(l.get(1), SpdDBProcessor.DEFAULT_LENGTH_UNIT));
            } else {
                throw new InvalidDataException("Unsupported polygon key " + type);
            }
            return geom;
        }
    }

    public static class SpdUnit {
        protected HashMap<String, Double> mScaleUnits = new HashMap();
        protected HashMap<String, Long> mInternalScales = new HashMap();

        public SpdUnit(Db db) {
            Design design = Design.getDesign((Db)db);
            assert (design != null);
            long imm = 1000000L * design.getInternalPerMicron();
            this.mScaleUnits.put(SpdDBProcessor.DEFAULT_LENGTH_UNIT, Math.pow(10.0, -3.0));
            this.mScaleUnits.put("meg", Math.pow(10.0, 6.0));
            this.mScaleUnits.put("t", Math.pow(10.0, 12.0));
            this.mScaleUnits.put("g", Math.pow(10.0, 9.0));
            this.mScaleUnits.put("k", Math.pow(10.0, 3.0));
            this.mScaleUnits.put("u", Math.pow(10.0, -6.0));
            this.mScaleUnits.put("n", Math.pow(10.0, -9.0));
            this.mScaleUnits.put("p", Math.pow(10.0, -12.0));
            this.mScaleUnits.put("f", Math.pow(10.0, -15.0));
            this.mScaleUnits.put("default", 1.0);
            this.mInternalScales.put(SpdDBProcessor.DEFAULT_LENGTH_UNIT, imm);
            this.mInternalScales.put("s", 1L);
            this.mInternalScales.put("o", 1L);
            this.mInternalScales.put("f", 1L);
            this.mInternalScales.put("h", 1L);
            this.mInternalScales.put("a", 1L);
            this.mInternalScales.put("v", 1L);
            this.mInternalScales.put("default", imm);
        }

        public double spdToInternal(String s, String defaultUnit) throws InvalidDataException {
            s = s.toLowerCase();
            defaultUnit = defaultUnit.toLowerCase();
            String sUnit = "";
            long nUnit = 0L;
            for (String n : this.mInternalScales.keySet()) {
                if (!s.endsWith(n)) continue;
                sUnit = n;
                break;
            }
            if (sUnit.isEmpty()) {
                sUnit = defaultUnit;
            } else {
                int e = s.length() - sUnit.length();
                if (e <= 0) {
                    return 0.0;
                }
                s = s.substring(0, e);
            }
            assert (this.mInternalScales.containsKey(sUnit));
            nUnit = this.mInternalScales.get(sUnit);
            String sScale = "";
            double nScale = 1.0;
            for (String n : this.mScaleUnits.keySet()) {
                if (!s.endsWith(n)) continue;
                sScale = n;
                break;
            }
            if (!sScale.isEmpty()) {
                int e = s.length() - sScale.length();
                if (e <= 0) {
                    return 0.0;
                }
                s = s.substring(0, e);
                nScale = this.mScaleUnits.get(sScale);
            }
            try {
                return Double.parseDouble(s) * nScale * (double)nUnit;
            }
            catch (NumberFormatException e) {
                throw new InvalidDataException(e.getMessage());
            }
        }

        public double internalToSpd(double val, String unit, String scale) {
            double nScale = this.mScaleUnits.get(unit);
            long nUnit = this.mInternalScales.get(scale);
            return val / ((double)nUnit * nScale);
        }
    }

    protected static class InvalidDataException
    extends Exception {
        public InvalidDataException() {
        }

        public InvalidDataException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidDataException(String message) {
            super(message);
        }

        public InvalidDataException(Throwable cause) {
            super(cause);
        }
    }

    protected static interface parser {
        public Object parse(String var1) throws InvalidDataException;
    }

    public static enum CreateMetalStatus {
        None,
        Metal,
        AGeomWithCutouts,
        AddCutout;

    }
}

