/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.spd2000;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.SubstrateListRenderer;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SpdImportOptionsPanel
extends JPanel {
    JTextField mTxtRootDevName;
    JComboBox<DeviceTemplate.Type> mCboDevType;
    JCheckBox mCbDevTmpltPrefix;
    JTextField mTxtDevTmpltPrefix;
    JCheckBox mIgnoreLayerPrefix;
    JCheckBox mIgnoreDielectric;
    protected JComboBox<Substrate> mCboSubstrate;

    public SpdImportOptionsPanel(DeviceTemplate.Type t) {
        this.setBorder(BorderFactory.createTitledBorder("Speed Import Options"));
        GridBagManager l = new GridBagManager((Container)this);
        l.add("Root device name:", (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        l.indent();
        l.indent();
        l.indent();
        this.mTxtRootDevName = new JTextField("SPDDesign", 10);
        l.add((Component)this.mTxtRootDevName, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.mCboDevType = new JComboBox<DeviceTemplate.Type>(new DeviceTemplate.Type[]{DeviceTemplate.Type.BOARD, DeviceTemplate.Type.PACKAGE});
        this.mCboDevType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                DeviceTemplate.Type dtt = (DeviceTemplate.Type)value;
                this.setIcon(DbExplorerPanel.getIconForTemplateType(dtt));
                this.setText(AUtil.capitalizeFirstThenLower((String)dtt.name()));
                return this;
            }
        });
        if (t != null) {
            this.mCboDevType.setSelectedItem(t);
        }
        l.add("Import as type:", (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        l.indent();
        l.indent();
        l.indent();
        l.add(this.mCboDevType, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        l.newline();
        l.add("Into substrate:");
        l.indent();
        l.indent();
        l.indent();
        this.mCboSubstrate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.updateAvailableSubstrates();
        this.mCboSubstrate.setRenderer(new SubstrateListRenderer("<Create New>"));
        l.newline();
        this.mCbDevTmpltPrefix = (JCheckBox)l.add((Component)new JCheckBox("Device template prefix:"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        l.indent();
        l.indent();
        l.indent();
        this.mTxtDevTmpltPrefix = new JTextField(8);
        l.add((Component)this.mTxtDevTmpltPrefix, (GridBagConstraints)GridBagManager.FILLX);
        this.mCbDevTmpltPrefix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpdImportOptionsPanel.this.mTxtDevTmpltPrefix.setEnabled(SpdImportOptionsPanel.this.mCbDevTmpltPrefix.isSelected());
            }
        });
        this.mTxtDevTmpltPrefix.setEnabled(false);
        l.newline();
        this.mIgnoreLayerPrefix = (JCheckBox)l.add((Component)new JCheckBox("Ignore layer prefix in .spd file."), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        this.mIgnoreLayerPrefix.setSelected(true);
        l.newline();
        this.mIgnoreDielectric = (JCheckBox)l.add((Component)new JCheckBox("Don't import dielectric layer."), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        this.mIgnoreDielectric.setSelected(true);
        l.addFillY();
        this.setMinimumSize(this.getPreferredSize());
    }

    public String getRootDeviceName() {
        return this.mTxtRootDevName.getText();
    }

    public String getDeviceTemplatePrefix() {
        if (!this.mTxtDevTmpltPrefix.isEnabled()) {
            return "";
        }
        return this.mTxtDevTmpltPrefix.getText();
    }

    public DeviceTemplate.Type getTemplateType() {
        return (DeviceTemplate.Type)this.mCboDevType.getSelectedItem();
    }

    public String getSubstrateKeyStr() {
        Substrate substrate = (Substrate)this.mCboSubstrate.getSelectedItem();
        return substrate == null ? "" : substrate.getKeyStr();
    }

    public Boolean isIgnoreLayerPrefix() {
        return this.mIgnoreLayerPrefix.isSelected();
    }

    public Boolean isIgnoreDielectric() {
        return this.mIgnoreDielectric.isSelected();
    }

    protected void updateAvailableSubstrates() {
        Object origSel = this.mCboSubstrate.getSelectedItem();
        this.mCboSubstrate.removeAllItems();
        this.mCboSubstrate.addItem(null);
        this.mCboSubstrate.setSelectedIndex(0);
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return;
        }
        LinkedList substrates = AUtil.linkedList((Iterator)db.getObjects(Substrate.class));
        Collections.sort(substrates);
        for (Substrate s : substrates) {
            this.mCboSubstrate.addItem(s);
        }
        if (origSel != null) {
            this.mCboSubstrate.setSelectedItem(origSel);
        } else {
            this.mCboSubstrate.setSelectedIndex(0);
        }
    }
}

