/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.ui.netlist_editor.ItemFilters;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class BulkCreate<J> {
    private Device mChildDev;
    private Pattern mSelectorPattern;
    private String mNewNameRegex;
    private BulkHelper.StringGetter<J> mSelectedStringGetter;
    private List<ItemFilters.ItemFilter<J>> mSelectedItemFilters = new ArrayList<ItemFilters.ItemFilter<J>>();

    public BulkCreate(Device childDev, BulkHelper.StringGetter<J> selectedStringGetter) {
        this.mChildDev = childDev;
        this.mSelectedStringGetter = selectedStringGetter;
    }

    public void setSelectorPattern(String regex, int regexFlags) {
        this.mSelectorPattern = Pattern.compile(regex, regexFlags);
    }

    public void setNewNamePattern(String regex) {
        this.mNewNameRegex = regex;
    }

    public void setSelectedStringGetter(BulkHelper.StringGetter<J> selectedStringGetter) {
        this.mSelectedStringGetter = selectedStringGetter;
    }

    public void addSelectedItemFilter(ItemFilters.ItemFilter<J> itemFilter) {
        this.mSelectedItemFilters.add(itemFilter);
    }

    public void execute() {
        for (Object selectedItem : AUtil.arrayList(this.getSelectedItems())) {
            String newName;
            if (!this.isSelectedItemInclude(selectedItem) || (newName = this.getNewName(selectedItem)) == null || newName.isEmpty()) continue;
            this.createAndMapItem(selectedItem, newName);
        }
    }

    protected boolean isSelectedItemInclude(J selectedItem) {
        return ItemFilters.isInclude(this.mSelectedItemFilters, selectedItem);
    }

    protected String getNewName(J item) {
        String refStr = this.getSelectedItemStr(item);
        return this.getNewName(refStr);
    }

    protected String getNewName(String refStr) {
        return BulkHelper.getNewName(this.mSelectorPattern, refStr, this.mNewNameRegex);
    }

    protected Device getChildDev() {
        return this.mChildDev;
    }

    protected DeviceTemplate getChildDevT() {
        return this.mChildDev.getTemplate();
    }

    protected DeviceTemplate getParentDevT() {
        return this.mChildDev.getParent();
    }

    protected String getSelectedItemStr(J selectedItem) {
        return this.mSelectedStringGetter.getShowedStr(this.mChildDev, selectedItem);
    }

    protected abstract IterableIterator<J> getSelectedItems();

    protected abstract void createAndMapItem(J var1, String var2);
}

