/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class BulkHelper {
    public static final StringGetter<Net> NetStringGetter = new StringGetter<Net>("NetStringGetter", "Nets"){

        @Override
        public String getShowedStr(Device owner, Net item) {
            return item == null ? null : item.getName();
        }
    };
    public static final StringGetter<Term> TermStringGetter = new StringGetter<Term>("TermStringGetter", "Terms"){

        @Override
        public String getShowedStr(Device owner, Term item) {
            return item == null ? null : item.getName();
        }
    };
    public static final StringGetter<Term> TermParentNetStringGetter = new StringGetter<Term>("TermParentNetStringGetter", "Parent Nets"){

        @Override
        public String getShowedStr(Device owner, Term item) {
            if (owner == null || item == null) {
                return null;
            }
            Net parentNet = TermMap.getParentNet((Device)owner, (Term)item);
            return parentNet == null ? null : parentNet.getName();
        }
    };
    public static final StringGetter<Device> BumpStringGetter = new StringGetter<Device>("BumpStringGetter", "Bumps"){

        @Override
        public String getShowedStr(Device owner, Device item) {
            return item == null ? null : item.getName();
        }
    };
    public static final StringGetter<Device> BumpNetStringGetter = new StringGetter<Device>("BumpNetStringGetter", "Bump Nets"){

        @Override
        public String getShowedStr(Device owner, Device item) {
            if (item == null) {
                return null;
            }
            TermMap termMap = item.getTermMap();
            return termMap == null ? null : termMap.getParentNet().getName();
        }
    };

    public static Pattern getSelectorPattern(String selectorRegex, int selectorRegexFlags) {
        if (selectorRegex == null || selectorRegex.isEmpty()) {
            return null;
        }
        try {
            return Pattern.compile(selectorRegex, selectorRegexFlags);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    public static List<String> getCapturedValue(Pattern pattern, String refStr) {
        if (pattern == null || refStr == null) {
            return Collections.emptyList();
        }
        Matcher matcher = pattern.matcher(refStr);
        ArrayList<String> curValues = new ArrayList<String>();
        if (matcher.matches()) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                curValues.add(matcher.group(i));
            }
        }
        return curValues;
    }

    public static Pattern getMatchedPattern(Pattern selectoredPattern, String refStr, String matchedRegex, int matchedRegexFlags) {
        if (selectoredPattern == null || refStr == null || matchedRegex == null) {
            return null;
        }
        List<String> capturedValue = BulkHelper.getCapturedValue(selectoredPattern, refStr);
        return BulkHelper.getMatchedPattern(matchedRegex, matchedRegexFlags, capturedValue);
    }

    public static Pattern getMatchedPattern(String regex, int regexFlags, List<String> capturedValue) {
        if (regex == null || capturedValue == null) {
            return null;
        }
        Object[] val = capturedValue.toArray();
        for (int i = 0; i < val.length; ++i) {
            val[i] = Pattern.quote((String)val[i]);
        }
        try {
            String curPattern = MessageFormat.format(regex, val);
            return Pattern.compile(curPattern, regexFlags);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getNewName(Pattern selectoredPattern, String refStr, String newNameRegex) {
        if (refStr == null) {
            return null;
        }
        List<String> captureValue = BulkHelper.getCapturedValue(selectoredPattern, refStr);
        if (captureValue.isEmpty()) {
            return null;
        }
        try {
            return MessageFormat.format(newNameRegex, captureValue.toArray());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private BulkHelper() {
    }

    public static abstract class StringGetter<T> {
        private final String mName;
        private final String mShowStr;

        public StringGetter(String name, String title) {
            this.mName = name;
            this.mShowStr = title;
        }

        public String toString() {
            return this.mShowStr;
        }

        public String name() {
            return this.mName;
        }

        public abstract String getShowedStr(Device var1, T var2);
    }
}

