/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.google.common.base.Stopwatch;
import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.ui.netlist_editor.ItemFilters;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class BulkMap<J, K> {
    private Device mChildDev;
    private Pattern mSelectorPattern;
    private String mMatchedRegex;
    private int mMatchedRegexFlags;
    private List<ItemFilters.ItemFilter<J>> mSelectedItemFilters = new ArrayList<ItemFilters.ItemFilter<J>>();
    private List<ItemFilters.ItemFilter<K>> mMatchedItemFilters = new ArrayList<ItemFilters.ItemFilter<K>>();

    public BulkMap(Device childDev) {
        this.mChildDev = childDev;
    }

    public void setSelectorPattern(String regex, int regexFlags) {
        this.mSelectorPattern = Pattern.compile(regex, regexFlags);
    }

    public void setMatchedPattern(String regex, int regexFlags) {
        this.mMatchedRegex = regex;
        this.mMatchedRegexFlags = regexFlags;
    }

    public void addSelectedItemFilter(ItemFilters.ItemFilter<J> itemFilter) {
        this.mSelectedItemFilters.add(itemFilter);
    }

    public void addMatchedItemFilter(ItemFilters.ItemFilter<K> itemFilter) {
        this.mMatchedItemFilters.add(itemFilter);
    }

    public void execute() {
        Stopwatch timer = Stopwatch.createStarted();
        for (Object selectedItem : this.getSelectedItems()) {
            if (!this.isSelectedItemInclude(selectedItem)) continue;
            String refStr = this.getSelectedItemStr(selectedItem);
            Pattern matcherPattern = BulkHelper.getMatchedPattern(this.mSelectorPattern, refStr, this.mMatchedRegex, this.mMatchedRegexFlags);
            if (matcherPattern == null) {
                ALog.logError((String)"Error matching pattern %s", (Object[])new Object[]{this.mMatchedRegex});
                return;
            }
            for (K i : this.getMatchedItems()) {
                if (!this.isMatchedItemInclude(i) || !matcherPattern.matcher(this.getMatchedItemStr(i)).matches()) continue;
                this.mapItem(selectedItem, i);
            }
        }
        timer.stop();
        ALog.logDebug((String)"Bulk map in : %s", (Object[])new Object[]{timer});
    }

    protected Device getChildDev() {
        return this.mChildDev;
    }

    protected DeviceTemplate getParentDevT() {
        return this.mChildDev.getParent();
    }

    protected boolean isSelectedItemInclude(J selectedItem) {
        return ItemFilters.isInclude(this.mSelectedItemFilters, selectedItem);
    }

    protected boolean isMatchedItemInclude(K item) {
        return ItemFilters.isInclude(this.mMatchedItemFilters, item);
    }

    protected abstract IterableIterator<J> getSelectedItems();

    protected abstract List<K> getMatchedItems();

    protected abstract void mapItem(J var1, K var2);

    protected abstract String getSelectedItemStr(J var1);

    protected abstract String getMatchedItemStr(K var1);
}

