/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.term.BulkMap;
import java.util.Iterator;
import java.util.List;

public class BulkMapNetTerm
extends BulkMap<Net, Term> {
    private List<Term> mChildTerms;

    public BulkMapNetTerm(Device childDev) {
        super(childDev);
    }

    @Override
    protected IterableIterator<Net> getSelectedItems() {
        return this.getChildDev().getParent().getNets();
    }

    @Override
    protected List<Term> getMatchedItems() {
        if (this.mChildTerms == null) {
            this.mChildTerms = AUtil.arrayList((Iterator)this.getChildDev().getTerms());
        }
        return this.mChildTerms;
    }

    @Override
    protected void mapItem(Net selectedItem, Term matchedItem) {
        if (selectedItem.isUnused()) {
            return;
        }
        TermMap.mapChildTerm((Device)this.getChildDev(), (Term)matchedItem, (Net)selectedItem);
    }

    @Override
    protected String getSelectedItemStr(Net selectedItem) {
        return BulkHelper.NetStringGetter.getShowedStr(null, selectedItem);
    }

    @Override
    protected String getMatchedItemStr(Term matchedItem) {
        return BulkHelper.TermStringGetter.getShowedStr(null, matchedItem);
    }
}

