/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.term.BulkMap;
import java.util.Iterator;
import java.util.List;

public class BulkMapTermTerm
extends BulkMap<Term, Term> {
    private List<Term> mChildTerms;

    public BulkMapTermTerm(Device childDev) {
        super(childDev);
    }

    @Override
    protected IterableIterator<Term> getSelectedItems() {
        return this.getChildDev().getParent().getTerms();
    }

    @Override
    protected List<Term> getMatchedItems() {
        if (this.mChildTerms == null) {
            this.mChildTerms = AUtil.arrayList((Iterator)this.getChildDev().getTerms());
        }
        return this.mChildTerms;
    }

    @Override
    protected void mapItem(Term selectedItem, Term matchedItem) {
        Net parentNet = selectedItem.getNet();
        TermMap.mapChildTerm((Device)this.getChildDev(), (Term)matchedItem, (Net)parentNet);
    }

    @Override
    protected String getSelectedItemStr(Term selectedItem) {
        return BulkHelper.TermStringGetter.getShowedStr(null, selectedItem);
    }

    @Override
    protected String getMatchedItemStr(Term matchedItem) {
        return BulkHelper.TermStringGetter.getShowedStr(null, matchedItem);
    }
}

