/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BulkRename<T extends DbObject>
extends BulkCreate<T> {
    private final NameGenerator mTempNameGeneraotr = new NameGenerator("t");
    private Set<T> renamedItem = new HashSet<T>();
    private Map<T, String> mItem2NewName = new HashMap<T, String>();

    public BulkRename(Device childDev, BulkHelper.StringGetter<T> selectedStringGetter) {
        super(childDev, selectedStringGetter);
    }

    protected abstract void mergeAndDelete(T var1, T var2);

    protected abstract void setNewName(T var1, String var2);

    protected abstract T getExistItem(String var1);

    @Override
    protected String getNewName(T item) {
        String newName = this.mItem2NewName.get(item);
        if (newName == null) {
            return super.getNewName(item);
        }
        return newName;
    }

    @Override
    protected void createAndMapItem(T selectedItem, String newName) {
        String selectedItemStr = this.getSelectedItemStr(selectedItem);
        if (selectedItemStr.equals(newName)) {
            return;
        }
        if (this.isNameConflict(newName)) {
            ALog.flogWarn((String)"Rename %s to an existing term name '%s'. Merge two terms.", (Object[])new Object[]{selectedItemStr, newName});
            T existItem = this.getExistItem(newName);
            this.mergeAndDelete(selectedItem, existItem);
            this.renamedItem.add(existItem);
        } else {
            this.setNewName(selectedItem, newName);
            this.renamedItem.add(selectedItem);
        }
    }

    private boolean isNameConflict(String name) {
        T existItem = this.getExistItem(name);
        if (existItem == null) {
            return false;
        }
        if (!this.isSelectedItemInclude(existItem) || this.renamedItem.contains(existItem)) {
            return true;
        }
        String newName = this.getNewName((T)name);
        if (newName != null && !newName.equals(name)) {
            this.mItem2NewName.put(existItem, newName);
            this.setNewName(existItem, this.mTempNameGeneraotr.next());
            return false;
        }
        return true;
    }
}

