/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.util.OrbitValidator;

public class Bump2Term {
    public static void execute(Device bumpDev, String termName) {
        Term bumpTerm = bumpDev.getTerm();
        if (bumpTerm == null) {
            ALog.flogError((String)"Cannot create a term for bump '%s'. Bump should have one term.", (Object[])new Object[]{bumpDev.getName()});
            return;
        }
        Bump2Term.execute(bumpDev, bumpTerm, termName);
    }

    public static void execute(Device bumpDev, Term bumpTerm, String termName) {
        OrbitValidator.validateOwner((DeviceTemplate)bumpDev.getTemplate(), (DbObject)bumpTerm);
        Net bumpParentNet = TermMap.getParentNet((Device)bumpDev, (Term)bumpTerm);
        Term term = Term.get((DeviceTemplate)bumpDev.getParent(), (String)termName);
        if (term != null && bumpParentNet != null && term.getNet() != bumpParentNet) {
            ALog.flogError((String)"Cannot set bump '%s' to the exsiting term '%s' on the different net.", (Object[])new Object[]{bumpDev.getName(), term.getName()});
            return;
        }
        if (term == null && bumpParentNet == null) {
            Net bumpNet = Net.getOrCreate((DeviceTemplate)bumpDev.getParent(), (String)termName);
            TermMap.mapChildTerm((Device)bumpDev, (Term)bumpTerm, (Net)bumpNet);
            term = Term.create((String)termName, (Net)bumpNet);
        } else if (term != null) {
            Net bumpNet = term.getNet();
            TermMap.mapChildTerm((Device)bumpDev, (Term)bumpTerm, (Net)bumpNet);
        } else {
            term = Term.create((String)termName, (Net)bumpParentNet);
            term.syncAttribute(bumpParentNet);
        }
        Bump2Term.labelTerm(bumpDev, bumpTerm, term);
    }

    private static void labelTerm(Device bumpDev, Term bumpTerm, Term ownerTerm) {
        DevicePath bumpDevpath = new DevicePath(bumpDev);
        for (PinTemplate pinT : bumpTerm.getNet().getPins()) {
            PinLabel label = PinLabel.get((DevicePath)bumpDevpath, (PinTemplate)pinT);
            Term curTerm = label.getTerm();
            if (curTerm != null && curTerm != ownerTerm) {
                ALog.flogWarn((String)"Bump '%s' term change from '%s' to '%s'.", (Object[])new Object[]{bumpDev.getName(), curTerm.getName(), ownerTerm.getName()});
            }
            label.setTerm(ownerTerm);
        }
    }

    private Bump2Term() {
    }
}

