/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.term.Bump2Term;
import com.sigrity.orbit.util.OrbitValidator;
import java.util.HashMap;
import java.util.Map;

public class Bump2TermBulkCreate
extends BulkCreate<Device> {
    private static final BulkHelper.StringGetter<Device> DEFAULT_SELECTED_STRING_GETTER = BulkHelper.BumpStringGetter;
    private final Map<DeviceTemplate, Term> mBumpDevT2BumpTerm = new HashMap<DeviceTemplate, Term>();

    public Bump2TermBulkCreate(Device tergetDev) {
        super(tergetDev, DEFAULT_SELECTED_STRING_GETTER);
    }

    public void setBumpTerm(DeviceTemplate bumpDevT, Term bumpTerm) {
        OrbitValidator.validateOwner((DeviceTemplate)bumpDevT, (DbObject)bumpTerm);
        this.mBumpDevT2BumpTerm.put(bumpDevT, bumpTerm);
    }

    @Override
    protected IterableIterator<Device> getSelectedItems() {
        return this.getChildDevT().getChildren(DeviceFilters.FILTER_BUMP);
    }

    @Override
    protected void createAndMapItem(Device selectedItem, String newName) {
        DeviceTemplate bumpDevT = selectedItem.getTemplate();
        Term bumpTerm = this.mBumpDevT2BumpTerm.getOrDefault(bumpDevT, bumpDevT.getTerm());
        Bump2Term.execute(selectedItem, bumpTerm, newName);
    }
}

