/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;

public class ChildTerm2ParentNetBulkCreate
extends BulkCreate<Term> {
    public ChildTerm2ParentNetBulkCreate(Device childDev) {
        super(childDev, BulkHelper.TermStringGetter);
    }

    @Override
    protected IterableIterator<Term> getSelectedItems() {
        return this.getChildDev().getTerms();
    }

    @Override
    protected void createAndMapItem(Term selectedItem, String newName) {
        DeviceTemplate parentDevT = this.getParentDevT();
        Net parentNet = parentDevT.getNet(newName);
        if (parentNet == null) {
            parentNet = Net.create((DeviceTemplate)parentDevT, (String)newName);
            parentNet.syncAttribute(selectedItem);
        }
        TermMap.mapChildTerm((Device)this.getChildDev(), (Term)selectedItem, (Net)parentNet);
    }
}

