/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;
import java.util.Set;

public class ChildTerm2ParentTermBulkCreate
extends BulkCreate<Term> {
    private static final BulkHelper.StringGetter<Term> DEFAULT_SELTECTED_STRING_GETTER = BulkHelper.TermStringGetter;
    private DevicePath mChildPathFromParent = new DevicePath(this.getParentDevT(), this.getChildDev());

    public ChildTerm2ParentTermBulkCreate(Device childDev) {
        super(childDev, DEFAULT_SELTECTED_STRING_GETTER);
    }

    @Override
    protected IterableIterator<Term> getSelectedItems() {
        return this.getChildDev().getTerms();
    }

    @Override
    protected void createAndMapItem(Term selectedItem, String newName) {
        Term parentTerm = this.getParentDevT().getTerm(newName);
        if (parentTerm == null) {
            Net parentNet = this.getParentNet(selectedItem, newName);
            parentTerm = Term.create((String)newName, (Net)parentNet);
            parentTerm.syncAttribute(selectedItem);
        }
        TermMap.mapChildTerm((Device)this.getChildDev(), (Term)selectedItem, (Net)parentTerm.getNet());
        this.labelTerm(selectedItem, parentTerm);
    }

    private Net getParentNet(Term selectedItem, String newName) {
        DeviceTemplate parentDevT = this.getParentDevT();
        Net parentNet = TermMap.getParentNet((Device)this.getChildDev(), (Term)selectedItem);
        if (parentNet == null) {
            parentNet = Net.get((DeviceTemplate)parentDevT, (String)newName);
        }
        if (parentNet == null) {
            parentNet = Net.create((DeviceTemplate)parentDevT, (String)newName);
            parentNet.syncAttribute(selectedItem);
        }
        return parentNet;
    }

    private void labelTerm(Term childTerm, Term parentTerm) {
        if (this.getChildDev().getIsSubstrate()) {
            return;
        }
        for (HierInst desHierPin : TermMap.getDescendantHierPins((DevicePath)this.mChildPathFromParent, (Net)childTerm.getNet(), (boolean)true)) {
            PinLabel parentLabel;
            PinTemplate pin = (PinTemplate)desHierPin.getDbObject();
            if (pin.getType() != PinTemplate.Type.BUMPPAD && pin.getType() != PinTemplate.Type.BALLPAD) continue;
            PinLabel childLabel = PinLabel.get((DeviceTemplate)this.getChildDevT(), (DevicePath)desHierPin.getPath(), (PinTemplate)pin, (boolean)false);
            if (childLabel == null || childLabel.getTerm() == null) {
                Set pinTopMostNet;
                parentLabel = PinLabel.get((DevicePath)desHierPin.getPath(), (PinTemplate)((PinTemplate)desHierPin.getDbObject()));
                if (parentLabel.getTerm() != null || (pinTopMostNet = TermMap.getTopMostNet((Net)pin.getNet(), (DevicePath)desHierPin.getPath().getRelativePathFromAnchor(this.getChildDevT()))).size() != 1 || ((Net)pinTopMostNet.iterator().next()).getTermsCount() != 1) continue;
                parentLabel.setTerm(parentTerm);
                continue;
            }
            if (childLabel.getTerm() != childTerm) continue;
            parentLabel = PinLabel.get((DevicePath)desHierPin.getPath(), (PinTemplate)((PinTemplate)desHierPin.getDbObject()));
            parentLabel.setTerm(parentTerm);
        }
    }
}

