/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;
import java.util.Set;

public class Net2TermBulkCreate
extends BulkCreate<Net> {
    private DevicePath mDevTPath = new DevicePath(this.getChildDevT());

    public Net2TermBulkCreate(Device tergetDev) {
        super(tergetDev, BulkHelper.NetStringGetter);
    }

    @Override
    protected IterableIterator<Net> getSelectedItems() {
        return this.getChildDevT().getNets(false);
    }

    @Override
    protected void createAndMapItem(Net selectedItem, String newName) {
        if (!selectedItem.isNC() && this.getChildDevT().getTerm(newName) == null) {
            Term term = Term.create((String)newName, (Net)selectedItem);
            term.syncAttribute(selectedItem);
            this.labelTerm(selectedItem, term);
        }
    }

    private void labelTerm(Net net, Term term) {
        for (HierInst desHierPin : TermMap.getDescendantHierPins((DevicePath)this.mDevTPath, (Net)net, (boolean)true)) {
            Set pinTopMostNet;
            PinLabel label;
            PinTemplate pin = (PinTemplate)desHierPin.getDbObject();
            if (pin.getType() != PinTemplate.Type.BUMPPAD && pin.getType() != PinTemplate.Type.BALLPAD || (label = PinLabel.get((DeviceTemplate)this.getChildDevT(), (DevicePath)desHierPin.getPath(), (PinTemplate)pin)).getTerm() != null || (pinTopMostNet = TermMap.getTopMostNet((Net)pin.getNet(), (DevicePath)desHierPin.getPath())).size() != 1 || ((Net)pinTopMostNet.iterator().next()).getTermsCount() != 1) continue;
            label.setTerm(term);
        }
    }
}

