/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;

public class ParentNet2ChildTermBulkCreate
extends BulkCreate<Net> {
    public ParentNet2ChildTermBulkCreate(Device childDev) {
        super(childDev, BulkHelper.NetStringGetter);
    }

    @Override
    protected IterableIterator<Net> getSelectedItems() {
        return this.getParentDevT().getNets();
    }

    @Override
    protected void createAndMapItem(Net selectedItem, String newName) {
        if (selectedItem.isNC()) {
            return;
        }
        DeviceTemplate childDevT = this.getChildDevT();
        Term childTerm = childDevT.getTerm(newName);
        if (childTerm == null) {
            Net childNet = childDevT.getNet(newName);
            if (childNet == null) {
                childNet = Net.create((DeviceTemplate)childDevT, (String)newName);
                childNet.syncAttribute(selectedItem);
            }
            childTerm = Term.create((String)newName, (Net)childNet);
            childTerm.syncAttribute(selectedItem);
        }
        TermMap.mapChildTerm((Device)this.getChildDev(), (Term)childTerm, (Net)selectedItem);
    }
}

