/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;

public class ParentTerm2ChildTermBulkCreate
extends BulkCreate<Term> {
    public ParentTerm2ChildTermBulkCreate(Device childDev) {
        super(childDev, BulkHelper.TermStringGetter);
    }

    @Override
    protected IterableIterator<Term> getSelectedItems() {
        return this.getParentDevT().getTerms();
    }

    @Override
    protected void createAndMapItem(Term selectedItem, String newName) {
        Net parentNet;
        DeviceTemplate childDevT = this.getChildDevT();
        Term childTerm = childDevT.getTerm(newName);
        if (childTerm == null) {
            Net childNet = childDevT.getNet(newName);
            if (childNet == null) {
                childNet = Net.create((DeviceTemplate)childDevT, (String)newName);
                childNet.syncAttribute(selectedItem);
            }
            childTerm = Term.create((String)newName, (Net)childNet);
            childTerm.syncAttribute(selectedItem);
        }
        if ((parentNet = selectedItem.getNet()) != null) {
            TermMap.mapChildTerm((Device)this.getChildDev(), (Term)childTerm, (Net)parentNet);
        } else assert (false);
    }
}

