/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.term.BulkCreate;
import com.sigrity.orbit.term.BulkHelper;

public class Term2NetBulkCreate
extends BulkCreate<Term> {
    public Term2NetBulkCreate(Device childDev) {
        super(childDev, BulkHelper.TermStringGetter);
    }

    @Override
    protected IterableIterator<Term> getSelectedItems() {
        return this.getChildDevT().getTerms();
    }

    @Override
    protected void createAndMapItem(Term selectedItem, String newName) {
        String termName;
        String termNetName = selectedItem.getNet().getName();
        if (termNetName.equals(termName = selectedItem.getName()) && !termNetName.equals(newName)) {
            ALog.flogError((String)"Invalid attempt to set term '%s' on net '%s'. Merge or rename net '%s'.", (Object[])new Object[]{termName, newName, termName});
            return;
        }
        Net newNameNet = Net.get((DeviceTemplate)this.getChildDevT(), (String)newName);
        if (newNameNet == null) {
            newNameNet = Net.create((DeviceTemplate)this.getChildDevT(), (String)newName);
            newNameNet.syncAttribute(selectedItem);
        }
        if (selectedItem.getNet() == newNameNet) {
            return;
        }
        selectedItem.setNet(newNameNet);
    }
}

