/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.term.TermList;
import java.io.File;
import java.util.Date;

public class TermListExport {
    private Db mDb;
    private DeviceTemplate mDevT;

    public TermListExport(DeviceTemplate devT) {
        this.mDb = devT.getDb();
        this.mDevT = devT;
    }

    public void exportCsv(String filePath) {
        File file = new File(filePath);
        try (ACsvWriter out = ACsvWriter.open((File)file);){
            this.writeTermList(out);
            ALog.logInfo((String)"Export term list to %s complete.", (Object[])new Object[]{file});
        }
        catch (Exception excep) {
            ALog.logError((Throwable)excep, (String)"There was an unexpected exception while writing file.", (Object[])new Object[0]);
        }
    }

    private void writeTermList(ACsvWriter csvWriter) {
        this.writeDesignInfo(csvWriter);
        this.writeDevTInfo(csvWriter);
        this.writeHeader(csvWriter);
        this.writeTerms(csvWriter);
    }

    protected void writeDesignInfo(ACsvWriter csvWriter) {
        assert (this.mDb != null && csvWriter != null);
        csvWriter.row(new String[]{String.format("#. %s version %s", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion())});
        csvWriter.row(new String[]{String.format("#. Build: %s (%s)", ABuildInfo.getVersion(), ABuildInfo.getTimestamp())});
        csvWriter.row(new String[]{String.format("#. User: %s", System.getProperty("user.name"))});
        csvWriter.row(new String[]{String.format("#. Time: %s", new Date())});
        String file = this.mDb.getCanonicalPath();
        csvWriter.row(new String[]{String.format("#. Source design: %s", file != null ? file : "<Unsaved Design>")});
        csvWriter.row(new String[]{"#."});
    }

    private void writeDevTInfo(ACsvWriter csvWriter) {
        csvWriter.row(new String[]{String.format("#. Substrate: %s", this.mDevT.getSubstrate().getName())});
        csvWriter.row(new String[]{String.format("#. Device template: %s", this.mDevT.getName())});
    }

    private void writeHeader(ACsvWriter csvWriter) {
        csvWriter.header(TermList.CsvHeader.getHeader());
    }

    private void writeTerms(ACsvWriter csvWriter) {
        this.mDevT.getTerms().forEach(term -> this.writeTerm(csvWriter, (Term)term));
    }

    private void writeTerm(ACsvWriter csvWriter, Term term) {
        csvWriter.colData(term.getName());
        csvWriter.colData(term.getNet().getName());
        csvWriter.colData(term.getType().toString());
        csvWriter.colData(term.getUse().toString());
        csvWriter.endRow();
    }
}

