/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.term.TermList;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;

public class TermListImport {
    private DeviceTemplate mDevT;

    public TermListImport(DeviceTemplate devT) {
        this.mDevT = devT;
    }

    public void importCsv(String filePath) {
        File file = new File(filePath);
        if (file.isDirectory()) {
            for (File f : file.listFiles((FileFilter)AFileFilter.CSV)) {
                this.importCsv(f);
            }
        } else if (file.isFile()) {
            this.importCsv(file);
        }
    }

    private void importCsv(File f) {
        assert (f.isFile());
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            CSVDocument csvDoc = parser2.parse(f.getPath());
            if (!parser2.validateHeader(TermList.CsvHeader.getHeader())) {
                ALog.logError((String)"Unexpected header in input file %s.", (Object[])new Object[]{f});
                ALog.logError((String)"Header should be %s", (Object[])new Object[]{Arrays.toString(TermList.CsvHeader.getHeader())});
                return;
            }
            for (int i = 0; i != csvDoc.getItemCount(); ++i) {
                this.createTerm(csvDoc, i);
            }
            ALog.logInfo((String)"Import term list from %s complete.", (Object[])new Object[]{f});
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logWarn((String)"Problems reading %s", (Object[])new Object[]{f});
        }
    }

    private void createTerm(CSVDocument csvDoc, int index) {
        Net net;
        String termName = csvDoc.getItemValue(index, TermList.CsvHeader.TERM.getCsvAttributeName());
        if (termName == null || termName.isEmpty()) {
            return;
        }
        String netName = csvDoc.getItemValue(index, TermList.CsvHeader.NET.getCsvAttributeName());
        if (netName.isEmpty()) {
            netName = termName;
        }
        if ((net = this.mDevT.getNet(netName)) == null) {
            net = Net.create((DeviceTemplate)this.mDevT, (String)netName);
        }
        String useStr = csvDoc.getItemValue(index, TermList.CsvHeader.USE.getCsvAttributeName());
        Term.Use use = Term.Use.getByStr((String)useStr);
        String typeStr = csvDoc.getItemValue(index, TermList.CsvHeader.TYPE.getCsvAttributeName());
        Term.Type type = Term.Type.getByStr((String)typeStr);
        Term term = this.mDevT.getTerm(termName);
        if (term == null) {
            term = Term.create((String)termName, (Net)net);
        } else {
            term.setNet(net);
        }
        term.setType(type);
        term.setUse(use);
        net.setDirection(Net.Direction.get((Term.Type)type));
        net.setUse(Net.Use.get((Term.Use)use));
    }
}

