/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.term.TermMapCsv;
import java.util.Date;

public class TermMapCsvExport {
    private Db mDb;
    private DeviceTemplate mDevT;

    public TermMapCsvExport(DeviceTemplate devT) {
        this.mDb = devT.getDb();
        this.mDevT = devT;
    }

    public void exportCsv(String filePath) {
        try (ACsvWriter out = ACsvWriter.open((String)filePath);){
            this.writeTermMapCsv(out);
            ALog.logInfo((String)"Export term list to %s complete.", (Object[])new Object[]{filePath});
        }
        catch (Exception excep) {
            ALog.logError((Throwable)excep, (String)"There was an unexpected exception while writing file.", (Object[])new Object[0]);
        }
    }

    private void writeTermMapCsv(ACsvWriter csvWriter) {
        this.writeDesignInfo(csvWriter);
        this.writeDevTInfo(csvWriter);
        this.writeHeader(csvWriter);
        this.writeTermMaps(csvWriter);
    }

    protected void writeDesignInfo(ACsvWriter csvWriter) {
        assert (this.mDb != null && csvWriter != null);
        csvWriter.row(new String[]{String.format("#. %s version %s", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion())});
        csvWriter.row(new String[]{String.format("#. Build: %s (%s)", ABuildInfo.getVersion(), ABuildInfo.getTimestamp())});
        csvWriter.row(new String[]{String.format("#. User: %s", System.getProperty("user.name"))});
        csvWriter.row(new String[]{String.format("#. Time: %s", new Date())});
        String file = this.mDb.getCanonicalPath();
        csvWriter.row(new String[]{String.format("#. Source design: %s", file != null ? file : "<Unsaved Design>")});
        csvWriter.row(new String[]{"#."});
    }

    private void writeDevTInfo(ACsvWriter csvWriter) {
        csvWriter.row(new String[]{String.format("#. Substrate: %s", this.mDevT.getSubstrate().getName())});
        csvWriter.row(new String[]{String.format("#. Device template: %s", this.mDevT.getName())});
    }

    private void writeHeader(ACsvWriter csvWriter) {
        csvWriter.header(TermMapCsv.CsvHeader.getHeader());
    }

    private void writeTermMaps(ACsvWriter csvWriter) {
        this.mDevT.getNets().forEach(net -> this.writeTermMap(csvWriter, (Net)net));
    }

    private void writeTermMap(ACsvWriter csvWriter, Net parentNet) {
        TermMap.getTermMaps((Net)parentNet).forEach(termMap -> this.writeTermMap(csvWriter, (TermMap)termMap));
    }

    private void writeTermMap(ACsvWriter csvWriter, TermMap termMap) {
        Term childTerm = termMap.getChildTerm();
        Net parentNet = termMap.getParentNet();
        csvWriter.colData(termMap.getChildDevice().getName());
        csvWriter.colData(childTerm.getName());
        csvWriter.colData(parentNet.getName());
        csvWriter.endRow();
    }
}

